/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jagg.Analytic;
import net.sf.jagg.AnalyticAggregator;
import net.sf.jagg.exception.JaggException;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.Tag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnaTag
extends BaseTag {
    public static final String ATTR_ITEMS = "items";
    public static final String ATTR_ANALYTICS = "analytics";
    public static final String ATTR_ANALYTICS_VAR = "analyticsVar";
    public static final String ATTR_VALUES_VAR = "valuesVar";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("items", "analytics", "valuesVar"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("analyticsVar"));
    private List<Object> myList = null;
    private List<AnalyticAggregator> myAnalytics = null;
    private String myAnalyticsVar = null;
    private String myValuesVar = null;
    private Analytic myAnalytic;

    @Override
    public String getName() {
        return "ana";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (this.isBodiless()) {
            throw new TagParseException("Ana tags must have a body.  Bodiless agg tag found" + this.getLocation());
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.myList = AttributeUtil.evaluateObject((Tag)this, attributes.get(ATTR_ITEMS), beans, ATTR_ITEMS, List.class, null);
        List<String> analyticsList = AttributeUtil.evaluateList(this, attributes.get(ATTR_ANALYTICS), beans, null);
        this.myAnalytics = new ArrayList<AnalyticAggregator>(analyticsList.size());
        for (String anaSpec : analyticsList) {
            this.myAnalytics.add(AnalyticAggregator.getAnalytic((String)anaSpec));
        }
        this.myAnalyticsVar = AttributeUtil.evaluateString(this, attributes.get(ATTR_ANALYTICS_VAR), beans, null);
        this.myValuesVar = AttributeUtil.evaluateString(this, attributes.get(ATTR_VALUES_VAR), beans, null);
        Analytic.Builder builder = new Analytic.Builder().setAnalytics(this.myAnalytics);
        try {
            this.myAnalytic = builder.build();
        }
        catch (JaggException e) {
            throw new TagParseException("AnaTag: Problem executing jAgg call: " + this.getLocation() + ": " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new TagParseException("AnaTag: RuntimeException caught during jAgg execution" + this.getLocation() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        List aggValues = this.myAnalytic.analyze(this.myList);
        beans.put(this.myValuesVar, aggValues);
        if (this.myAnalyticsVar != null) {
            beans.put(this.myAnalyticsVar, this.myAnalytics);
        }
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(context, this.getWorkbookContext());
        return true;
    }
}

