/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregation;
import net.sf.jagg.Aggregator;
import net.sf.jagg.exception.JaggException;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.Tag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AggTag
extends BaseTag {
    public static final String ATTR_ITEMS = "items";
    public static final String ATTR_AGGS = "aggs";
    public static final String ATTR_AGGS_VAR = "aggsVar";
    public static final String ATTR_VALUES_VAR = "valuesVar";
    public static final String ATTR_GROUP_BY = "groupBy";
    public static final String ATTR_PARALLEL = "parallel";
    public static final String ATTR_USE_MSD = "useMsd";
    public static final String ATTR_ROLLUP = "rollup";
    public static final String ATTR_ROLLUPS = "rollups";
    public static final String ATTR_CUBE = "cube";
    public static final String ATTR_GROUPING_SETS = "groupingSets";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("items", "aggs", "valuesVar"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("aggsVar", "groupBy", "parallel", "useMsd", "rollup", "rollups", "cube", "groupingSets"));
    private List<Object> myList = null;
    private List<AggregateFunction> myAggs = null;
    private String myAggsVar = null;
    private String myValuesVar = null;
    private Aggregation myAggregation;

    @Override
    public String getName() {
        return "agg";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (this.isBodiless()) {
            throw new TagParseException("Agg tags must have a body.  Bodiless agg tag found" + this.getLocation());
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.myList = AttributeUtil.evaluateObject((Tag)this, attributes.get(ATTR_ITEMS), beans, ATTR_ITEMS, List.class, null);
        List<String> aggsList = AttributeUtil.evaluateList(this, attributes.get(ATTR_AGGS), beans, null);
        this.myAggs = new ArrayList<AggregateFunction>(aggsList.size());
        for (String aggSpec : aggsList) {
            this.myAggs.add(Aggregator.getAggregator((String)aggSpec));
        }
        this.myAggsVar = AttributeUtil.evaluateString(this, attributes.get(ATTR_AGGS_VAR), beans, null);
        this.myValuesVar = AttributeUtil.evaluateString(this, attributes.get(ATTR_VALUES_VAR), beans, null);
        List<String> groupByProps = AttributeUtil.evaluateList(this, attributes.get(ATTR_GROUP_BY), beans, new ArrayList<String>());
        int parallelism = AttributeUtil.evaluatePositiveInt(this, attributes.get(ATTR_PARALLEL), beans, ATTR_PARALLEL, 1);
        boolean useMsd = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_USE_MSD), beans, false);
        RichTextString rtsRollup = attributes.get(ATTR_ROLLUP);
        RichTextString rtsRollups = attributes.get(ATTR_ROLLUPS);
        RichTextString rtsCube = attributes.get(ATTR_CUBE);
        RichTextString rtsGroupingSets = attributes.get(ATTR_GROUPING_SETS);
        AttributeUtil.ensureAtMostOneExists(this, Arrays.asList(rtsRollup, rtsRollups, rtsCube, rtsGroupingSets), Arrays.asList(ATTR_ROLLUP, ATTR_ROLLUPS, ATTR_CUBE, ATTR_GROUPING_SETS));
        List<Integer> rollup = AttributeUtil.evaluateIntegerArray(this, rtsRollup, beans, null);
        List<Integer> cube = AttributeUtil.evaluateIntegerArray(this, attributes.get(ATTR_CUBE), beans, null);
        List<List<Integer>> rollups = AttributeUtil.evaluateIntegerArrayArray(this, rtsRollups, beans, null);
        List<List<Integer>> groupingSets = AttributeUtil.evaluateIntegerArrayArray(this, rtsGroupingSets, beans, null);
        Aggregation.Builder builder = new Aggregation.Builder().setAggregators(this.myAggs).setParallelism(parallelism).setUseMsd(useMsd);
        if (groupByProps != null) {
            builder.setProperties(groupByProps);
        }
        if (rollup != null) {
            builder.setRollup(rollup);
        } else if (cube != null) {
            builder.setCube(cube);
        } else if (rollups != null) {
            builder.setRollups(rollups);
        } else if (groupingSets != null) {
            builder.setGroupingSets(groupingSets);
        }
        try {
            this.myAggregation = builder.build();
        }
        catch (JaggException e) {
            throw new TagParseException("AggTag: Problem executing jAgg call: " + this.getLocation() + ": " + e.getMessage(), e);
        }
        catch (RuntimeException e) {
            throw new TagParseException("AggTag: RuntimeException caught during jAgg execution" + this.getLocation() + ": " + e.getMessage(), e);
        }
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        List aggValues = this.myAggregation.groupBy(this.myList);
        beans.put(this.myValuesVar, aggValues);
        if (this.myAggsVar != null) {
            beans.put(this.myAggsVar, this.myAggs);
        }
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(context, this.getWorkbookContext());
        return true;
    }
}

