/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.parser;

import java.util.HashMap;
import java.util.Map;
import net.sf.jett.exception.StyleParseException;
import net.sf.jett.model.Alignment;
import net.sf.jett.model.BorderType;
import net.sf.jett.model.FillPattern;
import net.sf.jett.model.FontBoldweight;
import net.sf.jett.model.FontCharset;
import net.sf.jett.model.FontTypeOffset;
import net.sf.jett.model.FontUnderline;
import net.sf.jett.model.Style;
import net.sf.jett.model.VerticalAlignment;
import net.sf.jett.parser.StyleScanner;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleParser {
    private static final boolean DEBUG = false;
    public static final String PROPERTY_ALIGNMENT = "alignment";
    public static final String PROPERTY_BORDER = "border";
    public static final String PROPERTY_BORDER_BOTTOM = "border-bottom";
    public static final String PROPERTY_BORDER_LEFT = "border-left";
    public static final String PROPERTY_BORDER_RIGHT = "border-right";
    public static final String PROPERTY_BORDER_TOP = "border-top";
    public static final String PROPERTY_BORDER_COLOR = "border-color";
    public static final String PROPERTY_BOTTOM_BORDER_COLOR = "bottom-border-color";
    public static final String PROPERTY_LEFT_BORDER_COLOR = "left-border-color";
    public static final String PROPERTY_RIGHT_BORDER_COLOR = "right-border-color";
    public static final String PROPERTY_TOP_BORDER_COLOR = "top-border-color";
    public static final String PROPERTY_COLUMN_WIDTH_IN_CHARS = "column-width-in-chars";
    public static final String PROPERTY_DATA_FORMAT = "data-format";
    public static final String PROPERTY_FILL_BACKGROUND_COLOR = "fill-background-color";
    public static final String PROPERTY_FILL_FOREGROUND_COLOR = "fill-foreground-color";
    public static final String PROPERTY_FILL_PATTERN = "fill-pattern";
    public static final String PROPERTY_HIDDEN = "hidden";
    public static final String PROPERTY_INDENTION = "indention";
    public static final String PROPERTY_LOCKED = "locked";
    public static final String PROPERTY_ROTATION = "rotation";
    public static final String PROPERTY_ROW_HEIGHT_IN_POINTS = "row-height-in-points";
    public static final String PROPERTY_VERTICAL_ALIGNMENT = "vertical-alignment";
    public static final String PROPERTY_WRAP_TEXT = "wrap-text";
    public static final String PROPERTY_FONT_BOLDWEIGHT = "font-weight";
    public static final String PROPERTY_FONT_CHARSET = "font-charset";
    public static final String PROPERTY_FONT_COLOR = "font-color";
    public static final String PROPERTY_FONT_HEIGHT_IN_POINTS = "font-height-in-points";
    public static final String PROPERTY_FONT_NAME = "font-name";
    public static final String PROPERTY_FONT_ITALIC = "font-italic";
    public static final String PROPERTY_FONT_STRIKEOUT = "font-strikeout";
    public static final String PROPERTY_FONT_TYPE_OFFSET = "font-type-offset";
    public static final String PROPERTY_FONT_UNDERLINE = "font-underline";
    public static final String ROTATION_STACKED = "STACKED";
    public static final short POI_ROTATION_STACKED = 255;
    private String myCssText;
    private State myState;
    private Map<String, Style> myStyleMap;

    public StyleParser() {
        this.setCssText("");
    }

    public StyleParser(String cssText) {
        this.setCssText(cssText);
    }

    public void setCssText(String cssText) {
        this.myCssText = cssText;
        this.reset();
    }

    private void reset() {
        this.myState = State.START;
        this.myStyleMap = new HashMap<String, Style>();
    }

    public void parse() {
        StyleScanner scanner = new StyleScanner(this.myCssText);
        StyleScanner.Token token = scanner.getNextToken();
        if (token == StyleScanner.Token.TOKEN_WHITESPACE) {
            token = scanner.getNextToken();
        }
        String styleName = null;
        String propertyName = null;
        String value = null;
        Style currStyle = null;
        while (token.getCode() >= 0 && token != StyleScanner.Token.TOKEN_EOI) {
            switch (token) {
                case TOKEN_WHITESPACE: {
                    if (this.myState != State.EXPECT_SEMICOLON_OR_END_BRACE) break;
                    value = value + scanner.getCurrLexeme();
                    break;
                }
                case TOKEN_STRING: {
                    String lexeme = scanner.getCurrLexeme();
                    switch (this.myState) {
                        case EXPECT_STYLE_NAME: {
                            styleName = lexeme;
                            this.myState = State.EXPECT_BEGIN_BRACE;
                            break;
                        }
                        case EXPECT_PROPERTY_NAME: {
                            propertyName = lexeme;
                            this.myState = State.EXPECT_COLON;
                            break;
                        }
                        case EXPECT_VALUE: {
                            value = lexeme;
                            this.myState = State.EXPECT_SEMICOLON_OR_END_BRACE;
                            break;
                        }
                        case START: {
                            throw new StyleParseException("Expected new style definition, got " + lexeme + ": \"" + this.myCssText + "\"");
                        }
                        case EXPECT_BEGIN_BRACE: {
                            throw new StyleParseException("Expected '{', got " + lexeme + ": \"" + this.myCssText + "\"");
                        }
                        case EXPECT_COLON: {
                            throw new StyleParseException("Expected ':', got " + lexeme + ": \"" + this.myCssText + "\"");
                        }
                        case EXPECT_SEMICOLON_OR_END_BRACE: {
                            value = value + lexeme;
                        }
                    }
                    break;
                }
                case TOKEN_PERIOD: {
                    if (this.myState != State.START) {
                        throw new StyleParseException("Unexpected '.': \"" + this.myCssText + "\"");
                    }
                    this.myState = State.EXPECT_STYLE_NAME;
                    currStyle = new Style();
                    break;
                }
                case TOKEN_SEMICOLON: {
                    if (this.myState != State.EXPECT_SEMICOLON_OR_END_BRACE) {
                        throw new StyleParseException("Unexpected ';': \"" + this.myCssText + "\"");
                    }
                    StyleParser.addStyle(currStyle, propertyName, value);
                    propertyName = null;
                    value = null;
                    this.myState = State.EXPECT_PROPERTY_NAME;
                    break;
                }
                case TOKEN_BEGIN_BRACE: {
                    if (this.myState != State.EXPECT_BEGIN_BRACE) {
                        throw new StyleParseException("Unexpected '{': \"" + this.myCssText + "\"");
                    }
                    this.myState = State.EXPECT_PROPERTY_NAME;
                    break;
                }
                case TOKEN_END_BRACE: {
                    if (this.myState != State.EXPECT_SEMICOLON_OR_END_BRACE && this.myState != State.EXPECT_PROPERTY_NAME) {
                        throw new StyleParseException("Unexpected '}': \"" + this.myCssText + "\"");
                    }
                    if (propertyName != null && value != null) {
                        StyleParser.addStyle(currStyle, propertyName, value);
                        propertyName = null;
                        value = null;
                    }
                    if (styleName != null) {
                        this.myStyleMap.put(styleName, currStyle);
                    }
                    styleName = null;
                    this.myState = State.START;
                    break;
                }
                case TOKEN_COLON: {
                    if (this.myState != State.EXPECT_COLON) {
                        throw new StyleParseException("Unexpected ':': \"" + this.myCssText + "\"");
                    }
                    this.myState = State.EXPECT_VALUE;
                    break;
                }
                case TOKEN_ERROR_EOI_IN_COMMENT: {
                    throw new StyleParseException("End of input reached while scanning comment: \"" + this.myCssText + "\"");
                }
                default: {
                    throw new StyleParseException("Parse error occurred: \"" + this.myCssText + "\"");
                }
            }
            token = scanner.getNextToken();
        }
        if (this.myState != State.START) {
            throw new StyleParseException("Found end of input before end of style definition at \"" + styleName + "\" (" + (Object)((Object)this.myState) + "): \"" + this.myCssText + "\"");
        }
        if (token.getCode() < 0) {
            throw new StyleParseException("Found end of input while scanning comment: \"" + this.myCssText + "\"");
        }
    }

    public static void addStyle(Style style, String property, String value) {
        property = property.toLowerCase();
        value = value.trim().toUpperCase();
        if (PROPERTY_FONT_BOLDWEIGHT.equals(property)) {
            try {
                style.setFontBoldweight(FontBoldweight.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_FONT_ITALIC.equals(property)) {
            if (value != null) {
                style.setFontItalic(Boolean.valueOf(value));
            }
        } else if (PROPERTY_FONT_COLOR.equals(property)) {
            if (value != null) {
                style.setFontColor(value);
            }
        } else if (PROPERTY_FONT_NAME.equals(property)) {
            if (value != null) {
                style.setFontName(value);
            }
        } else if (PROPERTY_FONT_HEIGHT_IN_POINTS.equals(property)) {
            try {
                style.setFontHeightInPoints(Short.valueOf(value));
            }
            catch (NumberFormatException e) {}
        } else if (PROPERTY_ALIGNMENT.equals(property)) {
            try {
                style.setAlignment(Alignment.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_BORDER.equals(property)) {
            try {
                BorderType bt = BorderType.valueOf(value);
                style.setBorderBottomType(bt);
                style.setBorderLeftType(bt);
                style.setBorderRightType(bt);
                style.setBorderTopType(bt);
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_DATA_FORMAT.equals(property)) {
            if (value != null) {
                style.setDataFormat(value);
            }
        } else if (PROPERTY_FONT_UNDERLINE.equals(property)) {
            try {
                style.setFontUnderline(FontUnderline.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_FONT_STRIKEOUT.equals(property)) {
            if (value != null) {
                style.setFontStrikeout(Boolean.valueOf(value));
            }
        } else if (PROPERTY_WRAP_TEXT.equals(property)) {
            if (value != null) {
                style.setWrappingText(Boolean.valueOf(value));
            }
        } else if (PROPERTY_FILL_BACKGROUND_COLOR.equals(property)) {
            if (value != null) {
                style.setFillBackgroundColor(value);
            }
        } else if (PROPERTY_FILL_FOREGROUND_COLOR.equals(property)) {
            if (value != null) {
                style.setFillForegroundColor(value);
            }
        } else if (PROPERTY_FILL_PATTERN.equals(property)) {
            try {
                style.setFillPatternType(FillPattern.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_VERTICAL_ALIGNMENT.equals(property)) {
            try {
                style.setVerticalAlignment(VerticalAlignment.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_INDENTION.equals(property)) {
            try {
                style.setIndention(Short.valueOf(value));
            }
            catch (NumberFormatException e) {}
        } else if (PROPERTY_ROTATION.equals(property)) {
            if (ROTATION_STACKED.equals(value)) {
                style.setRotationDegrees((short)255);
            } else {
                try {
                    style.setRotationDegrees(Short.valueOf(value));
                }
                catch (NumberFormatException e) {}
            }
        } else if (PROPERTY_COLUMN_WIDTH_IN_CHARS.equals(property)) {
            try {
                double width = Double.parseDouble(value);
                style.setColumnWidth((int)Math.round(256.0 * width));
            }
            catch (NumberFormatException e) {}
        } else if (PROPERTY_ROW_HEIGHT_IN_POINTS.equals(property)) {
            try {
                double height = Double.parseDouble(value);
                style.setRowHeight((short)Math.round(20.0 * height));
            }
            catch (NumberFormatException e) {}
        } else if (PROPERTY_BORDER_COLOR.equals(property)) {
            try {
                style.setBorderBottomColor(value);
                style.setBorderLeftColor(value);
                style.setBorderRightColor(value);
                style.setBorderTopColor(value);
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_FONT_CHARSET.equals(property)) {
            try {
                style.setFontCharset(FontCharset.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_FONT_TYPE_OFFSET.equals(property)) {
            try {
                style.setFontTypeOffset(FontTypeOffset.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_LOCKED.equals(property)) {
            if (value != null) {
                style.setLocked(Boolean.valueOf(value));
            }
        } else if (PROPERTY_HIDDEN.equals(property)) {
            if (value != null) {
                style.setHidden(Boolean.valueOf(value));
            }
        } else if (PROPERTY_BORDER_BOTTOM.equals(property)) {
            try {
                style.setBorderBottomType(BorderType.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_BORDER_LEFT.equals(property)) {
            try {
                style.setBorderLeftType(BorderType.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_BORDER_RIGHT.equals(property)) {
            try {
                style.setBorderRightType(BorderType.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_BORDER_TOP.equals(property)) {
            try {
                style.setBorderTopType(BorderType.valueOf(value));
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_BOTTOM_BORDER_COLOR.equals(property)) {
            try {
                if (value != null) {
                    style.setBorderBottomColor(value);
                }
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_LEFT_BORDER_COLOR.equals(property)) {
            try {
                if (value != null) {
                    style.setBorderLeftColor(value);
                }
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_RIGHT_BORDER_COLOR.equals(property)) {
            try {
                if (value != null) {
                    style.setBorderRightColor(value);
                }
            }
            catch (IllegalArgumentException e) {}
        } else if (PROPERTY_TOP_BORDER_COLOR.equals(property)) {
            try {
                if (value != null) {
                    style.setBorderTopColor(value);
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    public Map<String, Style> getStyleMap() {
        return this.myStyleMap;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        START,
        EXPECT_STYLE_NAME,
        EXPECT_BEGIN_BRACE,
        EXPECT_PROPERTY_NAME,
        EXPECT_COLON,
        EXPECT_VALUE,
        EXPECT_SEMICOLON_OR_END_BRACE;

    }
}

