/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.model;

import java.util.HashMap;
import java.util.Map;
import net.sf.jett.model.ExcelColor;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class CellStyleCache {
    private static final boolean DEBUG = false;
    private static final String PROP_SEP = "|";
    private Workbook myWorkbook;
    private Map<String, CellStyle> myCellStyleMap;

    public CellStyleCache(Workbook workbook) {
        this.myWorkbook = workbook;
        this.myCellStyleMap = new HashMap<String, CellStyle>();
        this.cachePreExistingCellStyles();
    }

    private void cachePreExistingCellStyles() {
        short numCellStyles = this.myWorkbook.getNumCellStyles();
        for (short i = 0; i < numCellStyles; i = (short)(i + 1)) {
            this.cacheCellStyle(this.myWorkbook.getCellStyleAt(i));
        }
    }

    public int getNumEntries() {
        return this.myCellStyleMap.size();
    }

    public CellStyle retrieveCellStyle(short fontBoldweight, boolean fontItalic, Color fontColor, String fontName, short fontHeightInPoints, short alignment, short borderBottom, short borderLeft, short borderRight, short borderTop, String dataFormat, byte fontUnderline, boolean fontStrikeout, boolean wrapText, Color fillBackgroundColor, Color fillForegroundColor, short fillPattern, short verticalAlignment, short indention, short rotation, Color bottomBorderColor, Color leftBorderColor, Color rightBorderColor, Color topBorderColor, int fontCharset, short fontTypeOffset, boolean locked, boolean hidden) {
        String representation = this.getRepresentation(fontBoldweight, fontItalic, fontColor, fontName, fontHeightInPoints, alignment, borderBottom, borderLeft, borderRight, borderTop, dataFormat, fontUnderline, fontStrikeout, wrapText, fillBackgroundColor, fillForegroundColor, fillPattern, verticalAlignment, indention, rotation, bottomBorderColor, leftBorderColor, rightBorderColor, topBorderColor, fontCharset, fontTypeOffset, locked, hidden);
        CellStyle cs = this.myCellStyleMap.get(representation);
        return cs;
    }

    public void cacheCellStyle(CellStyle cs) {
        String representation = this.getRepresentation(cs);
        this.myCellStyleMap.put(representation, cs);
    }

    private String getRepresentation(CellStyle cs) {
        HSSFColor fontColor;
        Font f = this.myWorkbook.getFontAt(cs.getFontIndex());
        XSSFColor bottomColor = null;
        XSSFColor leftColor = null;
        XSSFColor rightColor = null;
        XSSFColor topColor = null;
        if (cs instanceof HSSFCellStyle) {
            HSSFFont hf = (HSSFFont)f;
            fontColor = hf.getHSSFColor((HSSFWorkbook)this.myWorkbook);
            if (cs.getBorderBottom() != 0) {
                bottomColor = ExcelColor.getHssfColorByIndex(cs.getBottomBorderColor());
            }
            if (cs.getBorderLeft() != 0) {
                leftColor = ExcelColor.getHssfColorByIndex(cs.getLeftBorderColor());
            }
            if (cs.getBorderRight() != 0) {
                rightColor = ExcelColor.getHssfColorByIndex(cs.getRightBorderColor());
            }
            if (cs.getBorderTop() != 0) {
                topColor = ExcelColor.getHssfColorByIndex(cs.getTopBorderColor());
            }
        } else if (cs instanceof XSSFCellStyle) {
            XSSFFont xf = (XSSFFont)f;
            fontColor = xf.getXSSFColor();
            XSSFCellStyle xcs = (XSSFCellStyle)cs;
            bottomColor = xcs.getBottomBorderXSSFColor();
            leftColor = xcs.getLeftBorderXSSFColor();
            rightColor = xcs.getRightBorderXSSFColor();
            topColor = xcs.getTopBorderXSSFColor();
        } else {
            throw new IllegalArgumentException("Bad CellStyle type: " + cs.getClass().getName());
        }
        return this.getRepresentation(f.getBoldweight(), f.getItalic(), (Color)fontColor, f.getFontName(), f.getFontHeightInPoints(), cs.getAlignment(), cs.getBorderBottom(), cs.getBorderLeft(), cs.getBorderRight(), cs.getBorderTop(), cs.getDataFormatString(), f.getUnderline(), f.getStrikeout(), cs.getWrapText(), cs.getFillBackgroundColorColor(), cs.getFillBackgroundColorColor(), cs.getFillPattern(), cs.getVerticalAlignment(), cs.getIndention(), cs.getRotation(), (Color)bottomColor, (Color)leftColor, (Color)rightColor, (Color)topColor, f.getCharSet(), f.getTypeOffset(), cs.getLocked(), cs.getHidden());
    }

    private String getRepresentation(short fontBoldweight, boolean fontItalic, Color fontColor, String fontName, short fontHeightInPoints, short alignment, short borderBottom, short borderLeft, short borderRight, short borderTop, String dataFormat, byte fontUnderline, boolean fontStrikeout, boolean wrapText, Color fillBackgroundColor, Color fillForegroundColor, short fillPattern, short verticalAlignment, short indention, short rotation, Color bottomBorderColor, Color leftBorderColor, Color rightBorderColor, Color topBorderColor, int fontCharset, short fontTypeOffset, boolean locked, boolean hidden) {
        StringBuilder buf = new StringBuilder();
        buf.append(fontBoldweight).append(PROP_SEP);
        buf.append(fontItalic).append(PROP_SEP);
        buf.append(SheetUtil.getColorHexString(fontColor));
        buf.append(PROP_SEP).append(fontName);
        buf.append(PROP_SEP).append(fontHeightInPoints);
        buf.append(PROP_SEP).append(alignment);
        buf.append(PROP_SEP).append(borderBottom);
        buf.append(PROP_SEP).append(borderLeft);
        buf.append(PROP_SEP).append(borderRight);
        buf.append(PROP_SEP).append(borderTop);
        buf.append(PROP_SEP).append(dataFormat);
        buf.append(PROP_SEP).append(fontUnderline);
        buf.append(PROP_SEP).append(fontStrikeout);
        buf.append(PROP_SEP).append(wrapText);
        buf.append(PROP_SEP).append(SheetUtil.getColorHexString(fillBackgroundColor));
        buf.append(PROP_SEP).append(SheetUtil.getColorHexString(fillForegroundColor));
        buf.append(PROP_SEP).append(fillPattern);
        buf.append(PROP_SEP).append(verticalAlignment);
        buf.append(PROP_SEP).append(indention);
        buf.append(PROP_SEP).append(rotation);
        buf.append(PROP_SEP).append(SheetUtil.getColorHexString(bottomBorderColor));
        buf.append(PROP_SEP).append(SheetUtil.getColorHexString(leftBorderColor));
        buf.append(PROP_SEP).append(SheetUtil.getColorHexString(rightBorderColor));
        buf.append(PROP_SEP).append(SheetUtil.getColorHexString(topBorderColor));
        buf.append(PROP_SEP).append(fontCharset);
        buf.append(PROP_SEP).append(fontTypeOffset);
        buf.append(PROP_SEP).append(locked);
        buf.append(PROP_SEP).append(hidden);
        return buf.toString();
    }
}

