/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.jdbc;

import java.io.BufferedReader;
import java.io.IOException;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import net.sf.jett.jdbc.ResultSetRow;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JDBCExecutor {
    private static final boolean DEBUG = false;
    private Connection myConnection;

    public JDBCExecutor(Connection connection) {
        this.myConnection = connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultSetRow> execQuery(String sql) throws SQLException {
        Statement st = null;
        ResultSet rs = null;
        try {
            st = this.myConnection.createStatement();
            rs = st.executeQuery(sql);
            List<ResultSetRow> list = this.processResultSet(rs);
            return list;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignored) {}
            try {
                if (st != null) {
                    st.close();
                }
            }
            catch (SQLException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ResultSetRow> execQuery(String sql, Object ... bindVariableValues) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            ps = this.myConnection.prepareStatement(sql);
            for (int i = 0; i < bindVariableValues.length; ++i) {
                Object o = bindVariableValues[i];
                if (o instanceof String) {
                    ps.setString(i + 1, (String)o);
                    continue;
                }
                if (o instanceof Integer) {
                    ps.setInt(i + 1, (Integer)o);
                    continue;
                }
                if (o instanceof Double) {
                    ps.setDouble(i + 1, (Double)o);
                    continue;
                }
                if (o instanceof Boolean) {
                    ps.setBoolean(i + 1, (Boolean)o);
                    continue;
                }
                if (o instanceof Float) {
                    ps.setFloat(i + 1, ((Float)o).floatValue());
                    continue;
                }
                if (o instanceof Long) {
                    ps.setLong(i + 1, (Long)o);
                    continue;
                }
                if (o instanceof Date) {
                    ps.setDate(i + 1, (Date)o);
                    continue;
                }
                if (o instanceof Time) {
                    ps.setTime(i + 1, (Time)o);
                    continue;
                }
                if (o instanceof Timestamp) {
                    ps.setTimestamp(i + 1, (Timestamp)o);
                    continue;
                }
                if (o instanceof BigDecimal) {
                    ps.setBigDecimal(i + 1, (BigDecimal)o);
                    continue;
                }
                if (o instanceof Short) {
                    ps.setShort(i + 1, (Short)o);
                    continue;
                }
                if (o instanceof Byte) {
                    ps.setByte(i + 1, (Byte)o);
                    continue;
                }
                if (o instanceof byte[]) {
                    ps.setBytes(i + 1, (byte[])o);
                    continue;
                }
                if (o instanceof Clob) {
                    ps.setClob(i + 1, (Clob)o);
                    continue;
                }
                if (o instanceof Blob) {
                    ps.setBlob(i + 1, (Blob)o);
                    continue;
                }
                if (o instanceof Array) {
                    ps.setArray(i + 1, (Array)o);
                    continue;
                }
                if (o instanceof URL) {
                    ps.setURL(i + 1, (URL)o);
                    continue;
                }
                ps.setObject(i + 1, o);
            }
            rs = ps.executeQuery();
            List<ResultSetRow> list = this.processResultSet(rs);
            return list;
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (SQLException ignored) {}
            try {
                if (ps != null) {
                    ps.close();
                }
            }
            catch (SQLException ignored) {}
        }
    }

    private List<ResultSetRow> processResultSet(ResultSet rs) throws SQLException {
        ResultSetMetaData rsmd = rs.getMetaData();
        List<Integer> types = this.getTypes(rsmd);
        List<String> colNames = this.getColumnNames(rsmd);
        ArrayList<ResultSetRow> rows = new ArrayList<ResultSetRow>();
        while (rs.next()) {
            ResultSetRow row = new ResultSetRow();
            block18: for (int i = 0; i < types.size(); ++i) {
                String colName = colNames.get(i);
                switch (types.get(i)) {
                    case -1: 
                    case 1: 
                    case 12: {
                        row.set(colName, rs.getString(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        row.set(colName, rs.getBytes(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case -7: 
                    case 16: {
                        row.set(colName, rs.getBoolean(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case -6: 
                    case 5: {
                        row.set(colName, rs.getShort(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case 4: {
                        row.set(colName, rs.getInt(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case 7: {
                        row.set(colName, Float.valueOf(rs.getFloat(i + 1)));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case 6: 
                    case 8: {
                        row.set(colName, rs.getDouble(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case 2: 
                    case 3: {
                        row.set(colName, rs.getBigDecimal(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case 91: {
                        row.set(colName, rs.getDate(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case 92: {
                        row.set(colName, rs.getTime(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case 93: {
                        row.set(colName, rs.getTimestamp(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    case 2005: {
                        Clob clob = rs.getClob(i + 1);
                        if (rs.wasNull()) {
                            row.set(colName, null);
                            continue block18;
                        }
                        BufferedReader r = new BufferedReader(clob.getCharacterStream());
                        StringBuffer buf = new StringBuffer();
                        try {
                            String line;
                            while ((line = r.readLine()) != null) {
                                buf.append(line);
                            }
                            row.set(colName, buf.toString());
                        }
                        catch (IOException e) {
                            row.set(colName, e.getMessage());
                        }
                        continue block18;
                    }
                    case 2003: {
                        row.set(colName, rs.getArray(i + 1).getArray());
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                        continue block18;
                    }
                    default: {
                        row.set(colName, rs.getObject(i + 1));
                        if (!rs.wasNull()) continue block18;
                        row.set(colName, null);
                    }
                }
            }
            rows.add(row);
        }
        return rows;
    }

    private List<Integer> getTypes(ResultSetMetaData rsmd) throws SQLException {
        int numCols = rsmd.getColumnCount();
        ArrayList<Integer> types = new ArrayList<Integer>(numCols);
        for (int i = 0; i < numCols; ++i) {
            types.add(rsmd.getColumnType(i + 1));
        }
        return types;
    }

    private List<String> getColumnNames(ResultSetMetaData rsmd) throws SQLException {
        int numCols = rsmd.getColumnCount();
        ArrayList<String> colNames = new ArrayList<String>(numCols);
        for (int i = 0; i < numCols; ++i) {
            colNames.add(rsmd.getColumnName(i + 1));
        }
        return colNames;
    }
}

