/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.transform;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.sf.jett.exception.MetadataParseException;
import net.sf.jett.expression.Expression;
import net.sf.jett.model.BaseLoopTagStatus;
import net.sf.jett.model.HashMapWrapper;
import net.sf.jett.model.MissingCloneSheetProperties;
import net.sf.jett.model.PastEndValue;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.MetadataParser;
import net.sf.jett.parser.SheetNameMetadataParser;
import net.sf.jett.tag.NameTag;
import net.sf.jett.transform.CollectionsTransformer;
import net.sf.jett.transform.SheetTransformer;
import net.sf.jett.util.FormulaUtil;
import net.sf.jett.util.RichTextStringUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.PrintSetup;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFSheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SheetCloner {
    private static final boolean DEBUG = false;
    public static final String BEGIN_METADATA = "$@";
    private Workbook myWorkbook;
    private List<MissingCloneSheetProperties> myMissingPropertiesList;

    public SheetCloner(Workbook workbook) {
        this.myWorkbook = workbook;
        this.myMissingPropertiesList = new ArrayList<MissingCloneSheetProperties>();
    }

    public SheetTransformer.AfterOffSheetProperties getMissingPropertiesSetter() {
        return new SheetTransformer.AfterOffSheetProperties(){

            public void applySettings(Sheet sheet) {
                SheetCloner.this.replaceMissingCloneSheetProperties(sheet, (MissingCloneSheetProperties)SheetCloner.this.myMissingPropertiesList.get(sheet.getWorkbook().getSheetIndex(sheet)));
            }
        };
    }

    private void replaceMissingCloneSheetProperties(Sheet sheet, MissingCloneSheetProperties mcsp) {
        PrintSetup ps = sheet.getPrintSetup();
        sheet.setRepeatingColumns(mcsp.getRepeatingColumns());
        sheet.setRepeatingRows(mcsp.getRepeatingRows());
        if (sheet instanceof XSSFSheet) {
            ps.setCopies(mcsp.getCopies());
            ps.setDraft(mcsp.isDraft());
            ps.setFitHeight(mcsp.getFitHeight());
            ps.setFitWidth(mcsp.getFitWidth());
            ps.setHResolution(mcsp.getHResolution());
            ps.setLandscape(mcsp.isLandscape());
            ps.setLeftToRight(mcsp.isLeftToRight());
            ps.setNoColor(mcsp.isNoColor());
            ps.setNotes(mcsp.isNotes());
            ps.setPageStart(mcsp.getPageStart());
            ps.setPaperSize(mcsp.getPaperSize());
            ps.setScale(mcsp.getScale());
            ps.setUsePage(mcsp.isUsePage());
            ps.setValidSettings(mcsp.isValidSettings());
            ps.setVResolution(mcsp.getVResolution());
        }
    }

    public void cloneForSheetSpecificBeans(List<String> templateSheetNames, List<String> newSheetNames) {
        int i;
        HashMap<String, Integer> firstReferencedSheets = new HashMap<String, Integer>();
        for (i = 0; i < this.myWorkbook.getNumberOfSheets(); ++i) {
            this.myMissingPropertiesList.add(this.getMissingCloneSheetProperties(this.myWorkbook.getSheetAt(i)));
        }
        for (i = 0; i < templateSheetNames.size(); ++i) {
            String templateSheetName = templateSheetNames.get(i);
            String newSheetName = newSheetNames.get(i);
            if (firstReferencedSheets.containsKey(templateSheetName)) {
                int prevIndex = (Integer)firstReferencedSheets.get(templateSheetName);
                MissingCloneSheetProperties cloned = new MissingCloneSheetProperties(this.myMissingPropertiesList.get(prevIndex));
                this.myWorkbook.cloneSheet(prevIndex);
                int clonePos = this.myWorkbook.getNumberOfSheets() - 1;
                newSheetName = SheetUtil.safeSetSheetName(this.myWorkbook, clonePos, newSheetName);
                this.cloneNamedRanges(this.myWorkbook, prevIndex);
                this.myWorkbook.setSheetOrder(newSheetName, i);
                this.updateNamedRangesScope(this.myWorkbook, clonePos, i);
                this.myMissingPropertiesList.add(i, cloned);
                continue;
            }
            int index = this.myWorkbook.getSheetIndex(templateSheetName);
            if (index == -1) {
                throw new RuntimeException("Template Sheet \"" + templateSheetName + "\" not found!");
            }
            newSheetName = SheetUtil.safeSetSheetName(this.myWorkbook, index, newSheetName);
            if (index != i) {
                MissingCloneSheetProperties move = this.myMissingPropertiesList.remove(index);
                this.myWorkbook.setSheetOrder(newSheetName, i);
                this.updateNamedRangesScope(this.myWorkbook, index, i);
                this.myMissingPropertiesList.add(i, move);
            }
            firstReferencedSheets.put(templateSheetName, i);
        }
    }

    private MissingCloneSheetProperties getMissingCloneSheetProperties(Sheet sheet) {
        MissingCloneSheetProperties mcsp = new MissingCloneSheetProperties();
        PrintSetup ps = sheet.getPrintSetup();
        mcsp.setRepeatingColumns(sheet.getRepeatingColumns());
        mcsp.setRepeatingRows(sheet.getRepeatingRows());
        mcsp.setCopies(ps.getCopies());
        mcsp.setDraft(ps.getDraft());
        mcsp.setFitHeight(ps.getFitHeight());
        mcsp.setFitWidth(ps.getFitWidth());
        mcsp.setHResolution(ps.getHResolution());
        mcsp.setLandscape(ps.getLandscape());
        mcsp.setNoColor(ps.getNoColor());
        mcsp.setLeftToRight(ps.getLeftToRight());
        mcsp.setNotes(ps.getNotes());
        mcsp.setPageStart(ps.getPageStart());
        mcsp.setPaperSize(ps.getPaperSize());
        mcsp.setScale(ps.getScale());
        mcsp.setUsePage(ps.getUsePage());
        mcsp.setValidSettings(ps.getValidSettings());
        mcsp.setVResolution(ps.getVResolution());
        return mcsp;
    }

    private void cloneNamedRanges(Workbook workbook, int prevIndex) {
        int numNamedRanges = workbook.getNumberOfNames();
        int clonedSheetIndex = workbook.getNumberOfSheets() - 1;
        for (int i = 0; i < numNamedRanges; ++i) {
            Name name = workbook.getNameAt(i);
            if (name.getSheetIndex() != prevIndex || NameTag.EXCEL_BUILT_IN_NAMES.contains(name.getNameName())) continue;
            Name clone = workbook.createName();
            clone.setSheetIndex(clonedSheetIndex);
            clone.setNameName(name.getNameName());
            clone.setComment(name.getComment());
            clone.setFunction(name.isFunctionName());
            clone.setRefersToFormula(name.getRefersToFormula());
        }
    }

    private void updateNamedRangesScope(Workbook workbook, int fromIndex, int toIndex) {
        if (fromIndex != toIndex) {
            int numNamedRanges = workbook.getNumberOfNames();
            for (int i = 0; i < numNamedRanges; ++i) {
                Name name = workbook.getNameAt(i);
                int scopeIndex = name.getSheetIndex();
                if (scopeIndex == fromIndex) {
                    name.setSheetIndex(toIndex);
                    continue;
                }
                if (fromIndex < scopeIndex && scopeIndex < toIndex) {
                    name.setSheetIndex(scopeIndex - 1);
                    continue;
                }
                if (toIndex >= scopeIndex || scopeIndex >= fromIndex) continue;
                name.setSheetIndex(scopeIndex + 1);
            }
        }
    }

    public Map<String, Object> setupForImplicitCloning(Sheet sheet, Map<String, Object> beans, WorkbookContext context) {
        Map<String, Object> useThisBeansMap = beans;
        MetadataParser parser = this.extractMetadata(sheet, context);
        String replacementValue = "";
        String indexVarName = null;
        int limit = -1;
        String varStatusName = null;
        if (parser != null) {
            replacementValue = parser.getReplacementValue();
            indexVarName = parser.getIndexVarName();
            try {
                limit = Integer.parseInt(parser.getLimit());
            }
            catch (NumberFormatException e) {
                throw new MetadataParseException("Limit must be a number: " + parser.getLimit(), e);
            }
            varStatusName = parser.getVarStatusName();
        }
        List<String> collExprs = this.findCollectionsInSheetName(sheet, beans, context);
        ArrayList<Collection> collections = new ArrayList<Collection>();
        for (String string : collExprs) {
            ArrayList result = Expression.evaluateString("${" + string.trim() + "}", context.getExpressionFactory(), beans);
            if (result == null) {
                result = new ArrayList(0);
            }
            if (!(result instanceof Collection)) {
                throw new MetadataParseException("One of the items in the sheet name is not a Collection: \"" + string);
            }
            collections.add(result);
        }
        int maxSize = 0;
        for (Collection coll : collections) {
            if (coll.size() <= maxSize) continue;
            maxSize = coll.size();
        }
        if (limit == -1) {
            limit = maxSize;
        }
        boolean bl = !context.getTemplateSheetNames().isEmpty();
        String sheetName = sheet.getSheetName();
        int index = this.myWorkbook.getSheetIndex(sheetName);
        CreationHelper helper = this.myWorkbook.getCreationHelper();
        List<Map<String, Object>> beansMaps = context.getBeansMaps();
        if (this.myMissingPropertiesList.size() <= index) {
            if (this.myMissingPropertiesList.size() < index) {
                this.myMissingPropertiesList.addAll(Collections.nCopies(index, null));
            }
            this.myMissingPropertiesList.add(this.getMissingCloneSheetProperties(this.myWorkbook.getSheetAt(index)));
        }
        if (limit > 1) {
            int i;
            if (index == -1) {
                throw new RuntimeException("Implicit cloning Sheet \"" + sheetName + "\" not found!");
            }
            String origSheetName = null;
            for (i = 0; i < limit; ++i) {
                MissingCloneSheetProperties cloned = null;
                if (i > 0) {
                    cloned = new MissingCloneSheetProperties(this.myMissingPropertiesList.get(index));
                    this.myWorkbook.cloneSheet(index);
                }
                Object temp = helper.createRichTextString(sheetName);
                for (String collExpression : collExprs) {
                    String replacement = collExpression + "." + i;
                    temp = RichTextStringUtil.replaceAll((RichTextString)temp, helper, collExpression, replacement, false, 0, true);
                }
                String newSheetName = temp.getString();
                if (i == 0) {
                    newSheetName = SheetUtil.safeSetSheetName(this.myWorkbook, index, newSheetName);
                    FormulaUtil.replaceSheetNameRefs(context, sheetName, newSheetName);
                    origSheetName = newSheetName;
                    continue;
                }
                int clonePos = this.myWorkbook.getNumberOfSheets() - 1;
                newSheetName = SheetUtil.safeSetSheetName(this.myWorkbook, clonePos, newSheetName);
                this.cloneNamedRanges(this.myWorkbook, index);
                this.myWorkbook.setSheetOrder(newSheetName, index + i);
                this.updateNamedRangesScope(this.myWorkbook, clonePos, index + i);
                this.myMissingPropertiesList.add(cloned);
                FormulaUtil.addSheetNameRefsAfterClone(context, origSheetName, newSheetName, index + i);
            }
            if (bl) {
                ArrayList iterators = new ArrayList();
                Map<String, Object> source = beansMaps.get(index);
                for (Collection collection : collections) {
                    iterators.add(collection.iterator());
                }
                for (int i2 = 0; i2 < limit; ++i2) {
                    String newSheetName;
                    Sheet cloned = this.myWorkbook.getSheetAt(index + i2);
                    List<String> varNames = CollectionsTransformer.getImplicitVarNames(collExprs);
                    HashMapWrapper<String, Object> wrappingMap = new HashMapWrapper<String, Object>(source);
                    for (int c = 0; c < collExprs.size(); ++c) {
                        Iterator itr = (Iterator)iterators.get(c);
                        PastEndValue value = itr.hasNext() ? itr.next() : PastEndValue.PAST_END_VALUE;
                        String varName = varNames.get(c);
                        wrappingMap.put(varName, value);
                    }
                    if (indexVarName != null && !indexVarName.isEmpty()) {
                        wrappingMap.put(indexVarName, i2);
                    }
                    if (varStatusName != null && !varStatusName.isEmpty()) {
                        wrappingMap.put(varStatusName, new BaseLoopTagStatus(i2, limit));
                    }
                    if (i2 == 0) {
                        beansMaps.set(index, wrappingMap);
                        useThisBeansMap = wrappingMap;
                    } else {
                        beansMaps.add(index + i2, wrappingMap);
                    }
                    SheetUtil.setUpSheetForImplicitCloningAccess(cloned, collExprs, varNames);
                    ArrayList<String> pastEndRefs = new ArrayList<String>();
                    for (int c = 0; c < collections.size(); ++c) {
                        if (i2 < ((Collection)collections.get(c)).size()) continue;
                        pastEndRefs.add(varNames.get(c));
                        pastEndRefs.add(collExprs.get(c) + "." + i2);
                    }
                    sheetName = cloned.getSheetName();
                    if (sheetName.equals(newSheetName = SheetUtil.takePastEndAction(cloned, pastEndRefs, replacementValue))) continue;
                    FormulaUtil.replaceSheetNameRefs(context, sheetName, newSheetName);
                }
            } else {
                if (indexVarName != null && !indexVarName.isEmpty()) {
                    ArrayList<Integer> indexVars = new ArrayList<Integer>();
                    for (int i3 = 0; i3 < limit; ++i3) {
                        indexVars.add(i3);
                    }
                    beans.put(indexVarName, indexVars);
                }
                if (varStatusName != null && !varStatusName.isEmpty()) {
                    ArrayList<BaseLoopTagStatus> varStatuses = new ArrayList<BaseLoopTagStatus>();
                    for (int i4 = 0; i4 < limit; ++i4) {
                        varStatuses.add(new BaseLoopTagStatus(i4, limit));
                    }
                    beans.put(varStatusName, varStatuses);
                }
                for (i = 0; i < limit; ++i) {
                    String newSheetName;
                    Sheet cloned = this.myWorkbook.getSheetAt(index + i);
                    ArrayList<String> localCollExprs = new ArrayList<String>(collExprs);
                    ArrayList<String> replacementExprs = new ArrayList<String>(localCollExprs.size());
                    for (String collExpr : localCollExprs) {
                        replacementExprs.add(collExpr + "." + i);
                    }
                    if (indexVarName != null && !indexVarName.isEmpty()) {
                        localCollExprs.add(indexVarName);
                        replacementExprs.add(indexVarName + "." + i);
                    }
                    if (varStatusName != null && !varStatusName.isEmpty()) {
                        localCollExprs.add(varStatusName);
                        replacementExprs.add(varStatusName + "." + i);
                    }
                    SheetUtil.setUpSheetForImplicitCloningAccess(cloned, localCollExprs, replacementExprs);
                    ArrayList<String> pastEndRefs = new ArrayList<String>();
                    for (int c = 0; c < collections.size(); ++c) {
                        if (i < ((Collection)collections.get(c)).size()) continue;
                        pastEndRefs.add((String)replacementExprs.get(c));
                    }
                    sheetName = cloned.getSheetName();
                    if (sheetName.equalsIgnoreCase(newSheetName = SheetUtil.takePastEndAction(cloned, pastEndRefs, replacementValue))) continue;
                    FormulaUtil.replaceSheetNameRefs(context, sheetName, newSheetName);
                }
            }
        } else if (limit == 0) {
            String newSheetName;
            Sheet toBlank = this.myWorkbook.getSheetAt(index);
            String oldSheetName = toBlank.getSheetName();
            ArrayList<String> augmented = new ArrayList<String>(collExprs);
            if (indexVarName != null && !indexVarName.isEmpty()) {
                augmented.add(indexVarName);
            }
            if (varStatusName != null && !varStatusName.isEmpty()) {
                augmented.add(varStatusName);
            }
            if (!oldSheetName.equals(newSheetName = SheetUtil.takePastEndAction(toBlank, augmented, replacementValue))) {
                FormulaUtil.replaceSheetNameRefs(context, sheetName, newSheetName);
            }
        }
        return useThisBeansMap;
    }

    private MetadataParser extractMetadata(Sheet sheet, WorkbookContext context) {
        SheetNameMetadataParser parser = null;
        String name = sheet.getSheetName();
        int metadataIndIdx = name.indexOf(BEGIN_METADATA);
        if (metadataIndIdx != -1) {
            String metadata = name.substring(metadataIndIdx + BEGIN_METADATA.length());
            parser = new SheetNameMetadataParser(metadata);
            parser.setCell(null);
            parser.parse();
            String metadataRemoved = name.replaceAll(Pattern.quote(BEGIN_METADATA + metadata), "");
            Workbook workbook = sheet.getWorkbook();
            metadataRemoved = SheetUtil.safeSetSheetName(workbook, workbook.getSheetIndex(sheet), metadataRemoved);
            FormulaUtil.replaceSheetNameRefs(context, name, metadataRemoved);
        }
        return parser;
    }

    private List<String> findCollectionsInSheetName(Sheet sheet, Map<String, Object> beans, WorkbookContext context) {
        String metadataRemoved = sheet.getSheetName();
        return Expression.getImplicitCollectionExpr(metadataRemoved, beans, context);
    }
}

