/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.transform;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jett.event.CellListener;
import net.sf.jett.event.SheetListener;
import net.sf.jett.expression.Expression;
import net.sf.jett.expression.ExpressionFactory;
import net.sf.jett.formula.CellRef;
import net.sf.jett.formula.Formula;
import net.sf.jett.model.CellStyleCache;
import net.sf.jett.model.FontCache;
import net.sf.jett.model.Style;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.StyleParser;
import net.sf.jett.tag.JtTagLibrary;
import net.sf.jett.tag.TagLibrary;
import net.sf.jett.tag.TagLibraryRegistry;
import net.sf.jett.transform.SheetCloner;
import net.sf.jett.transform.SheetTransformer;
import net.sf.jett.util.FormulaUtil;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExcelTransformer {
    private static final boolean DEBUG = false;
    private TagLibraryRegistry myRegistry = new TagLibraryRegistry();
    private List<CellListener> myCellListeners;
    private List<SheetListener> mySheetListeners;
    private List<String> myFixedSizeCollectionNames;
    private List<String> myNoImplicitProcessingCollectionNames;
    private Map<String, Style> myStyleMap;
    private boolean amIEvaluatingFormulas;
    private boolean amIForcingRecalculationOnOpening;
    private boolean amIChangingForcingRecalculation;
    private ExpressionFactory myExpressionFactory;

    public ExcelTransformer() {
        this.registerTagLibrary("jt", JtTagLibrary.getJtTagLibrary());
        this.myCellListeners = new ArrayList<CellListener>();
        this.mySheetListeners = new ArrayList<SheetListener>();
        this.myFixedSizeCollectionNames = new ArrayList<String>();
        this.myNoImplicitProcessingCollectionNames = new ArrayList<String>();
        this.myStyleMap = new HashMap<String, Style>();
        this.amIEvaluatingFormulas = false;
        this.amIForcingRecalculationOnOpening = false;
        this.amIChangingForcingRecalculation = false;
        this.myExpressionFactory = new ExpressionFactory();
    }

    public void registerTagLibrary(String namespace, TagLibrary library) {
        this.myRegistry.registerTagLibrary(namespace, library);
    }

    public void addCellListener(CellListener listener) {
        if (listener != null) {
            this.myCellListeners.add(listener);
        }
    }

    public void addSheetListener(SheetListener listener) {
        if (listener != null) {
            this.mySheetListeners.add(listener);
        }
    }

    public void addFixedSizeCollectionName(String collName) {
        if (collName != null) {
            this.myFixedSizeCollectionNames.add(collName);
        }
    }

    public void turnOffImplicitCollectionProcessing(String collName) {
        if (collName != null) {
            this.myNoImplicitProcessingCollectionNames.add(collName);
        }
    }

    public void setLenient(boolean lenient) {
        this.myExpressionFactory.setLenient(lenient);
    }

    public void setSilent(boolean silent) {
        this.myExpressionFactory.setSilent(silent);
    }

    public void setCache(int size) {
        this.myExpressionFactory.setCache(size);
    }

    public void setDebug(boolean debug) {
        this.myExpressionFactory.setDebug(debug);
    }

    public void registerFuncs(String namespace, Object funcsObject) {
        this.myExpressionFactory.registerFuncs(namespace, funcsObject);
    }

    public void addCssText(String cssText) {
        StyleParser parser = new StyleParser(cssText);
        parser.parse();
        this.myStyleMap.putAll(parser.getStyleMap());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCssFile(String filename) throws IOException {
        StringBuilder buf = new StringBuilder();
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(filename));
            while ((line = reader.readLine()) != null) {
                buf.append(line);
                buf.append("\n");
            }
            this.addCssText(buf.toString());
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public void setEvaluateFormulas(boolean evaluate) {
        this.amIEvaluatingFormulas = evaluate;
    }

    public void setForceRecalculationOnOpening(boolean forceRecalc) {
        this.amIChangingForcingRecalculation = true;
        this.amIForcingRecalculationOnOpening = forceRecalc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String inFilename, String outFilename, Map<String, Object> beans) throws IOException, InvalidFormatException {
        FileOutputStream fileOut = null;
        try {
            fileOut = new FileOutputStream(outFilename);
            Workbook workbook = WorkbookFactory.create((File)new File(inFilename));
            this.transform(workbook, beans);
            workbook.write((OutputStream)fileOut);
        }
        finally {
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public Workbook transform(InputStream is, Map<String, Object> beans) throws IOException, InvalidFormatException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        this.transform(workbook, beans);
        return workbook;
    }

    public void transform(Workbook workbook, Map<String, Object> beans) {
        Expression.clearExpressionToCollNamesMap();
        SheetTransformer sheetTransformer = new SheetTransformer();
        WorkbookContext context = this.createContext(workbook, sheetTransformer);
        this.exposeWorkbook(beans, workbook);
        for (int s = 0; s < workbook.getNumberOfSheets(); ++s) {
            Sheet sheet = workbook.getSheetAt(s);
            sheetTransformer.transform(sheet, context, beans);
        }
        this.postTransformation(workbook, context, sheetTransformer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void transform(String inFilename, String outFilename, List<String> templateSheetNamesList, List<String> newSheetNamesList, List<Map<String, Object>> beansList) throws IOException, InvalidFormatException {
        FileOutputStream fileOut = null;
        InputStream fileIn = null;
        try {
            fileOut = new FileOutputStream(outFilename);
            fileIn = new BufferedInputStream(new FileInputStream(inFilename));
            Workbook workbook = this.transform(fileIn, templateSheetNamesList, newSheetNamesList, beansList);
            workbook.write((OutputStream)fileOut);
        }
        finally {
            if (fileIn != null) {
                try {
                    fileIn.close();
                }
                catch (IOException ignored) {}
            }
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException ignored) {}
            }
        }
    }

    public Workbook transform(InputStream is, List<String> templateSheetNamesList, List<String> newSheetNamesList, List<Map<String, Object>> beansList) throws IOException, InvalidFormatException {
        Workbook workbook = WorkbookFactory.create((InputStream)is);
        this.transform(workbook, templateSheetNamesList, newSheetNamesList, beansList);
        return workbook;
    }

    public void transform(Workbook workbook, List<String> templateSheetNamesList, List<String> newSheetNamesList, List<Map<String, Object>> beansList) {
        SheetCloner cloner = new SheetCloner(workbook);
        cloner.cloneForSheetSpecificBeans(templateSheetNamesList, newSheetNamesList);
        SheetTransformer sheetTransformer = new SheetTransformer();
        WorkbookContext context = this.createContext(workbook, sheetTransformer, templateSheetNamesList, newSheetNamesList, beansList);
        FormulaUtil.updateSheetNameRefsAfterClone(context);
        int numItemsProcessed = 0;
        beansList = context.getBeansMaps();
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            if (numItemsProcessed < beansList.size()) {
                Map<String, Object> beans = beansList.get(i);
                this.exposeWorkbook(beans, workbook);
                Sheet sheet = workbook.getSheetAt(i);
                Expression.clearExpressionToCollNamesMap();
                sheetTransformer.transform(sheet, context, beans, cloner);
            }
            ++numItemsProcessed;
        }
        this.postTransformation(workbook, context, sheetTransformer);
    }

    private void postTransformation(Workbook workbook, WorkbookContext context, SheetTransformer sheetTransformer) {
        if (!context.getFormulaMap().isEmpty()) {
            this.replaceFormulas(workbook, context, sheetTransformer);
        }
        if (this.amIEvaluatingFormulas) {
            workbook.getCreationHelper().createFormulaEvaluator().evaluateAll();
        }
        if (this.amIChangingForcingRecalculation) {
            workbook.setForceFormulaRecalculation(this.amIForcingRecalculationOnOpening);
        }
    }

    public WorkbookContext createContext(Workbook workbook, SheetTransformer transformer) {
        return this.createContext(workbook, transformer, new ArrayList<String>(), new ArrayList<String>(), new ArrayList<Map<String, Object>>());
    }

    public WorkbookContext createContext(Workbook workbook, SheetTransformer transformer, List<String> templateSheetNames, List<String> sheetNames, List<Map<String, Object>> beansMaps) {
        WorkbookContext context = new WorkbookContext();
        context.setCellListeners(this.myCellListeners);
        context.setSheetListeners(this.mySheetListeners);
        context.setRegistry(this.myRegistry);
        context.setFixedSizeCollectionNames(this.myFixedSizeCollectionNames);
        context.setNoImplicitCollectionProcessingNames(this.myNoImplicitProcessingCollectionNames);
        HashMap<String, Formula> formulaMap = new HashMap<String, Formula>();
        HashMap<String, String> tagLocationsMap = new HashMap<String, String>();
        this.createFormulaAndCellMaps(workbook, transformer, formulaMap, tagLocationsMap);
        context.setFormulaMap(formulaMap);
        context.setTagLocationsMap(tagLocationsMap);
        Map<String, List<CellRef>> cellRefMap = FormulaUtil.createCellRefMap(formulaMap);
        context.setCellRefMap(cellRefMap);
        CellStyleCache csCache = new CellStyleCache(workbook);
        context.setCellStyleCache(csCache);
        FontCache fCache = new FontCache(workbook);
        context.setFontCache(fCache);
        context.setStyleMap(this.myStyleMap);
        context.setTemplateSheetNames(templateSheetNames);
        context.setSheetNames(sheetNames);
        context.setExpressionFactory(this.myExpressionFactory);
        context.setBeansMaps(beansMaps);
        return context;
    }

    private void createFormulaAndCellMaps(Workbook workbook, SheetTransformer transformer, Map<String, Formula> formulaMap, Map<String, String> tagLocationsMap) {
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            transformer.gatherFormulasAndTagLocations(sheet, formulaMap, tagLocationsMap);
        }
    }

    private void replaceFormulas(Workbook workbook, WorkbookContext context, SheetTransformer transformer) {
        Map<String, Formula> formulaMap = context.getFormulaMap();
        Map<String, List<CellRef>> cellRefMap = context.getCellRefMap();
        FormulaUtil.findAndReplaceCellRanges(cellRefMap);
        for (int i = 0; i < workbook.getNumberOfSheets(); ++i) {
            Sheet sheet = workbook.getSheetAt(i);
            transformer.replaceFormulas(sheet, context);
        }
        int numNamedRanges = workbook.getNumberOfNames();
        for (String key : formulaMap.keySet()) {
            Formula formula;
            int questionMark = key.indexOf("?");
            if (questionMark == -1) continue;
            int exclamation = key.indexOf("!");
            if (exclamation == -1) {
                throw new IllegalStateException("Expected '!' character not found in formula key \"" + key + "\"!");
            }
            String sheetName = key.substring(0, exclamation);
            String namedRangeName = key.substring(exclamation + 1, questionMark);
            String scopeSheetName = key.substring(questionMark + 1);
            int sheetScopeIndex = -1;
            if (scopeSheetName != null && scopeSheetName.length() > 0) {
                sheetScopeIndex = workbook.getSheetIndex(scopeSheetName);
            }
            Name namedRange = null;
            for (int i = 0; i < numNamedRanges; ++i) {
                Name n = workbook.getNameAt(i);
                if (!n.getNameName().equals(namedRangeName) || n.getSheetIndex() != sheetScopeIndex) continue;
                namedRange = n;
                break;
            }
            if (namedRange == null || (formula = formulaMap.get(key)) == null) continue;
            String excelFormula = FormulaUtil.createExcelFormulaString(formula, sheetName, context);
            namedRange.setRefersToFormula(excelFormula);
        }
    }

    private void exposeWorkbook(Map<String, Object> beans, Workbook workbook) {
        beans.put("workbook", workbook);
    }
}

