/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.transform;

import java.util.Map;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.CellTransformer;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

public class BlockTransformer {
    private static final boolean DEBUG = false;

    public void transform(TagContext context, WorkbookContext workbookContext) {
        this.transform(context, workbookContext, true);
    }

    public void transform(TagContext context, WorkbookContext workbookContext, boolean process) {
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        Map<String, Cell> processedCells = context.getProcessedCellsMap();
        CellTransformer transformer = new CellTransformer();
        for (int rowNum = block.getTopRowNum(); rowNum <= block.getBottomRowNum(); ++rowNum) {
            Row row = sheet.getRow(rowNum);
            if (row == null) continue;
            int startCellNum = block.getLeftColNum();
            int endCellNum = block.getRightColNum();
            for (int cellNum = startCellNum; cellNum <= endCellNum && rowNum <= block.getBottomRowNum(); ++cellNum) {
                boolean cellProcessed;
                Cell cell = row.getCell(cellNum);
                if (cell != null) {
                    if (process) {
                        cellProcessed = transformer.transform(cell, workbookContext, context);
                    } else {
                        cellProcessed = true;
                        processedCells.put(SheetUtil.getCellKey(cell), cell);
                    }
                } else {
                    cellProcessed = true;
                }
                endCellNum = block.getRightColNum();
                if (cellProcessed) continue;
                --cellNum;
            }
        }
    }
}

