/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jagg.AggregateFunction;
import net.sf.jagg.Aggregations;
import net.sf.jagg.Aggregator;
import net.sf.jagg.model.AggregateValue;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.Tag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TotalTag
extends BaseTag {
    public static final String ATTR_ITEMS = "items";
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_PARALLEL = "parallel";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("items", "value"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("parallel"));
    private List<Object> myList = null;
    private AggregateFunction myAggregateFunction = null;
    private int myParallelism = 1;

    @Override
    public String getName() {
        return "total";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (!this.isBodiless()) {
            throw new TagParseException("Total tags must not have a body.  Total tag with body found" + this.getLocation());
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.myList = AttributeUtil.evaluateObject((Tag)this, attributes.get(ATTR_ITEMS), beans, ATTR_ITEMS, List.class, new ArrayList(0));
        this.myParallelism = AttributeUtil.evaluatePositiveInt(this, attributes.get(ATTR_PARALLEL), beans, ATTR_PARALLEL, 1);
        String aggSpec = AttributeUtil.evaluateString(this, attributes.get(ATTR_VALUE), beans, null);
        this.myAggregateFunction = Aggregator.getAggregator((String)aggSpec);
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        ArrayList propsList = new ArrayList(0);
        ArrayList<AggregateFunction> aggList = new ArrayList<AggregateFunction>(1);
        aggList.add(this.myAggregateFunction);
        List aggValues = Aggregations.groupBy(this.myList, propsList, aggList, (int)this.myParallelism);
        AggregateValue aggValue = (AggregateValue)aggValues.get(0);
        Object value = aggValue.getAggregateValue(this.myAggregateFunction);
        Row row = sheet.getRow(block.getTopRowNum());
        Cell cell = row.getCell(block.getLeftColNum());
        WorkbookContext workbookContext = this.getWorkbookContext();
        SheetUtil.setCellValue(workbookContext, cell, value, this.getAttributes().get(ATTR_VALUE));
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(context, workbookContext);
        return true;
    }
}

