/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.model.CellStyleCache;
import net.sf.jett.model.ExcelColor;
import net.sf.jett.model.FontCache;
import net.sf.jett.model.Style;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.parser.StyleParser;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StyleTag
extends BaseTag {
    private static final boolean DEBUG = false;
    public static final String ATTR_STYLE = "style";
    public static final String ATTR_CLASS = "class";
    private static final String SPLIT_SPEC = "(?<!\\\\);";
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("class", "style"));
    private Style myStyle;

    @Override
    public String getName() {
        return ATTR_STYLE;
    }

    @Override
    protected List<String> getRequiredAttributes() {
        return super.getRequiredAttributes();
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        String line;
        super.validateAttributes();
        if (this.isBodiless()) {
            throw new TagParseException("Style tags must have a body.  Bodiless style tag found" + this.getLocation());
        }
        TagContext context = this.getContext();
        WorkbookContext wc = this.getWorkbookContext();
        Map<String, Style> styleMap = wc.getStyleMap();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.myStyle = new Style();
        List<String> styleClasses = AttributeUtil.evaluateList(this, attributes.get(ATTR_CLASS), beans, null);
        if (styleClasses != null) {
            for (String styleClass : styleClasses) {
                Style style = styleMap.get(styleClass.trim());
                if (style == null) continue;
                this.myStyle.apply(style);
            }
        }
        if ((line = AttributeUtil.evaluateString(this, attributes.get(ATTR_STYLE), beans, null)) != null) {
            String[] styles;
            for (String strStyle : styles = line.split(SPLIT_SPEC)) {
                String[] parts = strStyle.replace("\\;", ";").split(":", 2);
                if (parts.length < 2) continue;
                String property = parts[0].trim();
                String value = parts[1].trim();
                if (value.length() < 1) continue;
                StyleParser.addStyle(this.myStyle, property, value);
            }
        }
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Workbook workbook = sheet.getWorkbook();
        Block block = context.getBlock();
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        int top = block.getTopRowNum();
        int bottom = block.getBottomRowNum();
        if (this.myStyle.isStyleToApply()) {
            for (int r = top; r <= bottom; ++r) {
                Row row = sheet.getRow(r);
                if (row == null) continue;
                for (int c = left; c <= right; ++c) {
                    Cell cell = row.getCell(c);
                    if (cell == null) continue;
                    this.examineAndApplyStyle(workbook, cell);
                }
            }
        }
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(context, this.getWorkbookContext());
        return true;
    }

    private void examineAndApplyStyle(Workbook workbook, Cell cell) {
        CellStyle foundStyle;
        short rotationDegrees;
        XSSFColor fontColor;
        WorkbookContext wc = this.getWorkbookContext();
        CellStyleCache csCache = wc.getCellStyleCache();
        FontCache fCache = wc.getFontCache();
        CellStyle cs = cell.getCellStyle();
        Font f = workbook.getFontAt(cs.getFontIndex());
        short alignment = this.myStyle.getAlignment() != null ? this.myStyle.getAlignment().getIndex() : cs.getAlignment();
        short borderBottom = this.myStyle.getBorderBottomType() != null ? this.myStyle.getBorderBottomType().getIndex() : cs.getBorderBottom();
        short borderLeft = this.myStyle.getBorderLeftType() != null ? this.myStyle.getBorderLeftType().getIndex() : cs.getBorderLeft();
        short borderRight = this.myStyle.getBorderRightType() != null ? this.myStyle.getBorderRightType().getIndex() : cs.getBorderRight();
        short borderTop = this.myStyle.getBorderTopType() != null ? this.myStyle.getBorderTopType().getIndex() : cs.getBorderTop();
        String dataFormat = this.myStyle.getDataFormat() != null ? this.myStyle.getDataFormat() : cs.getDataFormatString();
        Color fillBackgroundColor = this.myStyle.getFillBackgroundColor() != null ? SheetUtil.getColor(workbook, this.myStyle.getFillBackgroundColor()) : cs.getFillBackgroundColorColor();
        Color fillForegroundColor = this.myStyle.getFillForegroundColor() != null ? SheetUtil.getColor(workbook, this.myStyle.getFillForegroundColor()) : cs.getFillForegroundColorColor();
        short fillPattern = this.myStyle.getFillPatternType() != null ? this.myStyle.getFillPatternType().getIndex() : cs.getFillPattern();
        boolean hidden = this.myStyle.isHidden() != null ? this.myStyle.isHidden().booleanValue() : cs.getHidden();
        short indention = this.myStyle.getIndention() != null ? this.myStyle.getIndention().shortValue() : cs.getIndention();
        boolean locked = this.myStyle.isLocked() != null ? this.myStyle.isLocked().booleanValue() : cs.getLocked();
        short verticalAlignment = this.myStyle.getVerticalAlignment() != null ? this.myStyle.getVerticalAlignment().getIndex() : cs.getVerticalAlignment();
        boolean wrapText = this.myStyle.isWrappingText() != null ? this.myStyle.isWrappingText().booleanValue() : cs.getWrapText();
        short fontBoldweight = this.myStyle.getFontBoldweight() != null ? this.myStyle.getFontBoldweight().getIndex() : f.getBoldweight();
        int fontCharset = this.myStyle.getFontCharset() != null ? this.myStyle.getFontCharset().getIndex() : f.getCharSet();
        short fontHeightInPoints = this.myStyle.getFontHeightInPoints() != null ? this.myStyle.getFontHeightInPoints().shortValue() : f.getFontHeightInPoints();
        String fontName = this.myStyle.getFontName() != null ? this.myStyle.getFontName() : f.getFontName();
        boolean fontItalic = this.myStyle.isFontItalic() != null ? this.myStyle.isFontItalic().booleanValue() : f.getItalic();
        boolean fontStrikeout = this.myStyle.isFontStrikeout() != null ? this.myStyle.isFontStrikeout().booleanValue() : f.getStrikeout();
        short fontTypeOffset = this.myStyle.getFontTypeOffset() != null ? this.myStyle.getFontTypeOffset().getIndex() : f.getTypeOffset();
        byte fontUnderline = this.myStyle.getFontUnderline() != null ? this.myStyle.getFontUnderline().getIndex() : f.getUnderline();
        XSSFColor bottomBorderColor = null;
        XSSFColor leftBorderColor = null;
        XSSFColor rightBorderColor = null;
        XSSFColor topBorderColor = null;
        if (workbook instanceof HSSFWorkbook) {
            short hssfFontColor;
            short hssfBottomBorderColor = this.myStyle.getBorderBottomColor() != null ? ((HSSFColor)SheetUtil.getColor(workbook, this.myStyle.getBorderBottomColor())).getIndex() : cs.getBottomBorderColor();
            short hssfLeftBorderColor = this.myStyle.getBorderLeftColor() != null ? ((HSSFColor)SheetUtil.getColor(workbook, this.myStyle.getBorderLeftColor())).getIndex() : cs.getLeftBorderColor();
            short hssfRightBorderColor = this.myStyle.getBorderRightColor() != null ? ((HSSFColor)SheetUtil.getColor(workbook, this.myStyle.getBorderRightColor())).getIndex() : cs.getRightBorderColor();
            short hssfTopBorderColor = this.myStyle.getBorderTopColor() != null ? ((HSSFColor)SheetUtil.getColor(workbook, this.myStyle.getBorderTopColor())).getIndex() : cs.getTopBorderColor();
            short s = hssfFontColor = this.myStyle.getFontColor() != null ? ((HSSFColor)SheetUtil.getColor(workbook, this.myStyle.getFontColor())).getIndex() : f.getColor();
            if (hssfBottomBorderColor != 0) {
                bottomBorderColor = ExcelColor.getHssfColorByIndex(hssfBottomBorderColor);
            }
            if (hssfLeftBorderColor != 0) {
                leftBorderColor = ExcelColor.getHssfColorByIndex(hssfLeftBorderColor);
            }
            if (hssfRightBorderColor != 0) {
                rightBorderColor = ExcelColor.getHssfColorByIndex(hssfRightBorderColor);
            }
            if (hssfTopBorderColor != 0) {
                topBorderColor = ExcelColor.getHssfColorByIndex(hssfTopBorderColor);
            }
            fontColor = ExcelColor.getHssfColorByIndex(hssfFontColor);
            rotationDegrees = this.myStyle.getRotationDegrees() != null ? this.myStyle.getRotationDegrees().shortValue() : cs.getRotation();
        } else {
            XSSFCellStyle xcs = (XSSFCellStyle)cs;
            bottomBorderColor = this.myStyle.getBorderBottomColor() != null ? (XSSFColor)SheetUtil.getColor(workbook, this.myStyle.getBorderBottomColor()) : xcs.getBottomBorderXSSFColor();
            leftBorderColor = this.myStyle.getBorderLeftColor() != null ? (XSSFColor)SheetUtil.getColor(workbook, this.myStyle.getBorderLeftColor()) : xcs.getLeftBorderXSSFColor();
            rightBorderColor = this.myStyle.getBorderRightColor() != null ? (XSSFColor)SheetUtil.getColor(workbook, this.myStyle.getBorderRightColor()) : xcs.getRightBorderXSSFColor();
            topBorderColor = this.myStyle.getBorderTopColor() != null ? (XSSFColor)SheetUtil.getColor(workbook, this.myStyle.getBorderTopColor()) : xcs.getTopBorderXSSFColor();
            fontColor = this.myStyle.getFontColor() != null ? (XSSFColor)SheetUtil.getColor(workbook, this.myStyle.getFontColor()) : ((XSSFFont)f).getXSSFColor();
            short s = rotationDegrees = this.myStyle.getRotationDegrees() != null ? this.myStyle.getRotationDegrees().shortValue() : cs.getRotation();
            if (rotationDegrees < 0) {
                rotationDegrees = (short)(90 - rotationDegrees);
            }
        }
        if (this.myStyle.getRowHeight() != null) {
            cell.getRow().setHeight(this.myStyle.getRowHeight().shortValue());
        }
        if (this.myStyle.getColumnWidth() != null) {
            cell.getSheet().setColumnWidth(cell.getColumnIndex(), this.myStyle.getColumnWidth().intValue());
        }
        if ((foundStyle = csCache.retrieveCellStyle(fontBoldweight, fontItalic, (Color)fontColor, fontName, fontHeightInPoints, alignment, borderBottom, borderLeft, borderRight, borderTop, dataFormat, fontUnderline, fontStrikeout, wrapText, fillBackgroundColor, fillForegroundColor, fillPattern, verticalAlignment, indention, rotationDegrees, (Color)bottomBorderColor, (Color)leftBorderColor, (Color)rightBorderColor, (Color)topBorderColor, fontCharset, fontTypeOffset, locked, hidden)) == null) {
            Font foundFont = fCache.retrieveFont(fontBoldweight, fontItalic, (Color)fontColor, fontName, fontHeightInPoints, fontUnderline, fontStrikeout, fontCharset, fontTypeOffset);
            if (foundFont == null) {
                foundFont = SheetUtil.createFont(workbook, fontBoldweight, fontItalic, (Color)fontColor, fontName, fontHeightInPoints, fontUnderline, fontStrikeout, fontCharset, fontTypeOffset);
                fCache.cacheFont(foundFont);
            }
            foundStyle = SheetUtil.createCellStyle(workbook, alignment, borderBottom, borderLeft, borderRight, borderTop, dataFormat, wrapText, fillBackgroundColor, fillForegroundColor, fillPattern, verticalAlignment, indention, rotationDegrees, (Color)bottomBorderColor, (Color)leftBorderColor, (Color)rightBorderColor, (Color)topBorderColor, locked, hidden);
            foundStyle.setFont(foundFont);
            csCache.cacheCellStyle(foundStyle);
        }
        cell.setCellStyle(foundStyle);
    }
}

