/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NullTag
extends BaseTag {
    public static final String ATTR_TEXT = "text";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("text"));

    @Override
    public String getName() {
        return "null";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        if (this.isBodiless()) {
            reqAttrs.addAll(REQ_ATTRS);
        }
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        return super.getOptionalAttributes();
    }

    @Override
    public void validateAttributes() {
        super.validateAttributes();
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        int left = block.getLeftColNum();
        int top = block.getTopRowNum();
        WorkbookContext workbookContext = this.getWorkbookContext();
        if (this.isBodiless()) {
            Row row = sheet.getRow(top);
            Cell cell = row.getCell(left);
            SheetUtil.setCellValue(workbookContext, cell, this.getAttributes().get(ATTR_TEXT));
        } else {
            BlockTransformer transformer = new BlockTransformer();
            transformer.transform(context, workbookContext, false);
        }
        return true;
    }
}

