/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.util.AttributeUtil;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.util.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageTag
extends BaseTag {
    public static final String ATTR_ROWS = "rows";
    public static final String ATTR_COLS = "cols";
    public static final String ATTR_PATHNAME = "pathname";
    public static final String ATTR_TYPE = "type";
    public static final String TYPE_DIB = "dib";
    public static final String TYPE_EMF = "emf";
    public static final String TYPE_JPEG = "jpeg";
    public static final String TYPE_PICT = "pict";
    public static final String TYPE_PNG = "png";
    public static final String TYPE_WMF = "wmf";
    public static final String DEF_TYPE = "png";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("pathname"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("rows", "cols", "type"));
    private String myPathname;
    private int myType;
    private boolean amISizing;
    private int myRows;
    private int myCols;

    @Override
    public String getName() {
        return "image";
    }

    @Override
    public List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    public List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (!this.isBodiless()) {
            throw new TagParseException("Image tags must not have a body.  Image tag with body found" + this.getLocation());
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        RichTextString rtsRows = attributes.get(ATTR_ROWS);
        RichTextString rtsCols = attributes.get(ATTR_COLS);
        if (rtsRows == null && rtsCols == null) {
            this.amISizing = false;
        } else {
            if (rtsRows != null) {
                this.myRows = AttributeUtil.evaluatePositiveInt(this, rtsRows, beans, ATTR_ROWS, 1);
            }
            if (rtsCols != null) {
                this.myCols = AttributeUtil.evaluatePositiveInt(this, rtsCols, beans, ATTR_COLS, 1);
            }
        }
        this.myPathname = AttributeUtil.evaluateStringNotNull(this, attributes.get(ATTR_PATHNAME), beans, ATTR_PATHNAME, "");
        RichTextString rtsType = attributes.get(ATTR_TYPE);
        String type = rtsType != null ? AttributeUtil.evaluateStringSpecificValues(this, rtsType, beans, ATTR_TYPE, Arrays.asList(TYPE_DIB, TYPE_EMF, TYPE_JPEG, TYPE_PICT, "png", TYPE_WMF), "png") : "png";
        if (TYPE_DIB.equalsIgnoreCase(type)) {
            this.myType = 7;
        } else if (TYPE_EMF.equalsIgnoreCase(type)) {
            this.myType = 2;
        } else if (TYPE_JPEG.equalsIgnoreCase(type)) {
            this.myType = 5;
        } else if (TYPE_PICT.equalsIgnoreCase(type)) {
            this.myType = 4;
        } else if ("png".equalsIgnoreCase(type)) {
            this.myType = 6;
        } else if (TYPE_WMF.equalsIgnoreCase(type)) {
            this.myType = 3;
        }
    }

    @Override
    public boolean process() {
        int pictIdx;
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Workbook workbook = sheet.getWorkbook();
        Block block = context.getBlock();
        int left = block.getLeftColNum();
        int top = block.getTopRowNum();
        try {
            FileInputStream is = new FileInputStream(this.myPathname);
            byte[] imageData = IOUtils.toByteArray((InputStream)is);
            pictIdx = workbook.addPicture(imageData, this.myType);
        }
        catch (IOException e) {
            throw new TagParseException("Read of pathname \"" + this.myPathname + "\" failed.", e);
        }
        Drawing drawing = context.createDrawing();
        ClientAnchor anchor = workbook.getCreationHelper().createClientAnchor();
        anchor.setCol1(left);
        anchor.setRow1(top);
        if (this.amISizing) {
            anchor.setCol2(left + this.myCols - 1);
            anchor.setRow2(top + this.myRows - 1);
        }
        Picture pict = drawing.createPicture(anchor, pictIdx);
        if (!this.amISizing) {
            pict.resize();
        }
        this.clearBlock();
        return true;
    }
}

