/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IfTag
extends BaseTag {
    public static final String ELSE_ACTION_SHIFT_UP = "shiftup";
    public static final String ELSE_ACTION_SHIFT_LEFT = "shiftleft";
    public static final String ELSE_ACTION_CLEAR = "clear";
    public static final String ELSE_ACTION_REMOVE = "remove";
    public static final String ATTR_TEST = "test";
    public static final String ATTR_THEN = "then";
    public static final String ATTR_ELSE = "else";
    public static final String ATTR_ELSE_ACTION = "elseAction";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("test"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("elseAction"));
    private static final List<String> REQ_ATTRS_BODILESS = new ArrayList<String>(Arrays.asList("test", "then"));
    private static final List<String> OPT_ATTRS_BODILESS = new ArrayList<String>(Arrays.asList("else"));
    private String myElseAction;

    @Override
    public String getName() {
        return "if";
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        if (this.isBodiless()) {
            reqAttrs.addAll(REQ_ATTRS_BODILESS);
        } else {
            reqAttrs.addAll(REQ_ATTRS);
        }
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        if (this.isBodiless()) {
            optAttrs.addAll(OPT_ATTRS_BODILESS);
        } else {
            optAttrs.addAll(OPT_ATTRS);
        }
        return optAttrs;
    }

    @Override
    public void validateAttributes() {
        super.validateAttributes();
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        Block block = context.getBlock();
        String elseAction = AttributeUtil.evaluateStringSpecificValues(this, attributes.get(ATTR_ELSE_ACTION), beans, ATTR_ELSE_ACTION, Arrays.asList(ELSE_ACTION_SHIFT_UP, ELSE_ACTION_SHIFT_LEFT, ELSE_ACTION_CLEAR, ELSE_ACTION_REMOVE), ELSE_ACTION_SHIFT_UP);
        if (elseAction != null) {
            if (ELSE_ACTION_SHIFT_UP.equalsIgnoreCase(elseAction)) {
                block.setDirection(Block.Direction.VERTICAL);
            } else if (ELSE_ACTION_SHIFT_LEFT.equalsIgnoreCase(elseAction)) {
                block.setDirection(Block.Direction.HORIZONTAL);
            } else if (ELSE_ACTION_CLEAR.equalsIgnoreCase(elseAction) || ELSE_ACTION_REMOVE.equalsIgnoreCase(elseAction)) {
                block.setDirection(Block.Direction.NONE);
            }
            this.myElseAction = elseAction;
        }
    }

    @Override
    public boolean process() {
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        Map<String, Object> beans = context.getBeans();
        WorkbookContext workbookContext = this.getWorkbookContext();
        Map<String, RichTextString> attributes = this.getAttributes();
        boolean condition = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_TEST), beans, true);
        if (this.isBodiless()) {
            RichTextString result = condition ? attributes.get(ATTR_THEN) : attributes.get(ATTR_ELSE);
            Row row = sheet.getRow(block.getTopRowNum());
            Cell cell = row.getCell(block.getLeftColNum());
            SheetUtil.setCellValue(workbookContext, cell, result, result);
            BlockTransformer transformer = new BlockTransformer();
            transformer.transform(context, workbookContext);
        } else if (condition) {
            BlockTransformer transformer = new BlockTransformer();
            transformer.transform(context, workbookContext);
        } else {
            if (ELSE_ACTION_CLEAR.equals(this.myElseAction)) {
                this.clearBlock();
            } else {
                this.removeBlock();
            }
            return false;
        }
        return true;
    }
}

