/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import net.sf.jett.model.Block;
import net.sf.jett.tag.BaseHideTag;
import net.sf.jett.tag.TagContext;
import org.apache.poi.ss.usermodel.Sheet;

public class HideColsTag
extends BaseHideTag {
    public String getName() {
        return "hideCols";
    }

    public void setHidden(boolean hide) {
        TagContext context = this.getContext();
        Block block = context.getBlock();
        int left = block.getLeftColNum();
        int right = block.getRightColNum();
        Sheet sheet = context.getSheet();
        for (int c = left; c <= right; ++c) {
            boolean isHidden = sheet.isColumnHidden(c);
            if (isHidden != hide) {
                sheet.setColumnHidden(c, hide);
            }
            if (!isHidden || hide || sheet.getColumnWidth(c) != 0) continue;
            sheet.setColumnWidth(c, 256 * sheet.getDefaultColumnWidth());
        }
    }
}

