/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.model.Block;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommentTag
extends BaseTag {
    public static final String ATTR_VALUE = "value";
    public static final String ATTR_AUTHOR = "author";
    public static final String ATTR_COMMENT = "comment";
    public static final String ATTR_VISIBLE = "visible";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("value", "author", "comment"));
    private static final List<String> OPT_ATTRS = new ArrayList<String>(Arrays.asList("visible"));
    private RichTextString myValue;
    private RichTextString myAuthor;
    private RichTextString myComment;
    private boolean amIVisible;

    @Override
    public String getName() {
        return ATTR_COMMENT;
    }

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        ArrayList<String> optAttrs = new ArrayList<String>(super.getOptionalAttributes());
        optAttrs.addAll(OPT_ATTRS);
        return optAttrs;
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (!this.isBodiless()) {
            throw new TagParseException("Comment tags must not have a body.  Comment tag with body found" + this.getLocation());
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.myValue = attributes.get(ATTR_VALUE);
        this.myAuthor = attributes.get(ATTR_AUTHOR);
        this.myComment = attributes.get(ATTR_COMMENT);
        this.amIVisible = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_VISIBLE), beans, false);
    }

    @Override
    public boolean process() {
        double fontHeightPoints;
        TagContext context = this.getContext();
        Sheet sheet = context.getSheet();
        Block block = context.getBlock();
        Map<String, Object> beans = context.getBeans();
        int left = block.getLeftColNum();
        int top = block.getTopRowNum();
        Row row = sheet.getRow(top);
        Cell cell = row.getCell(left);
        WorkbookContext workbookContext = this.getWorkbookContext();
        SheetUtil.setCellValue(workbookContext, cell, this.myValue);
        Drawing drawing = context.createDrawing();
        CreationHelper helper = sheet.getWorkbook().getCreationHelper();
        ClientAnchor anchor = helper.createClientAnchor();
        Object commentString = AttributeUtil.evaluateRichTextStringNotNull(this, this.myComment, helper, beans, ATTR_COMMENT, "");
        String author = AttributeUtil.evaluateStringNotNull(this, this.myAuthor, beans, ATTR_AUTHOR, "");
        int commentLength = commentString instanceof RichTextString ? ((RichTextString)commentString).length() : commentString.toString().length();
        int rows = 0;
        int cols = 0;
        double width = 0.0;
        double height = 0.0;
        double d = fontHeightPoints = cell instanceof HSSFCell ? (double)((HSSFCell)cell).getCellStyle().getFont(sheet.getWorkbook()).getFontHeightInPoints() : (double)((XSSFCell)cell).getCellStyle().getFont().getFontHeightInPoints();
        while (width * height < (double)commentLength && !((width += (double)(sheet.getColumnWidth(left + ++cols) / 256)) * height >= (double)commentLength)) {
            Row r = sheet.getRow(top + rows);
            if (r == null) {
                r = sheet.createRow(top + rows);
            }
            height += (double)r.getHeightInPoints() / fontHeightPoints;
            ++rows;
        }
        if (cell instanceof HSSFCell) {
            ++rows;
        }
        anchor.setCol1(left);
        anchor.setCol2(left + cols);
        anchor.setRow1(top);
        anchor.setRow2(top + rows);
        Comment comment = drawing.createCellComment(anchor);
        comment.setAuthor(author);
        if (commentString instanceof RichTextString) {
            comment.setString((RichTextString)commentString);
        } else {
            comment.setString(helper.createRichTextString(commentString.toString()));
        }
        comment.setVisible(this.amIVisible);
        cell.setCellComment(comment);
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(context, workbookContext);
        return true;
    }
}

