/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.tag;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import net.sf.jett.exception.TagParseException;
import net.sf.jett.tag.BaseTag;
import net.sf.jett.tag.TagContext;
import net.sf.jett.transform.BlockTransformer;
import net.sf.jett.util.AttributeUtil;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class BaseHideTag
extends BaseTag {
    public static final String ATTR_TEST = "test";
    private static final List<String> REQ_ATTRS = new ArrayList<String>(Arrays.asList("test"));
    private boolean amIHiding;

    @Override
    protected List<String> getRequiredAttributes() {
        ArrayList<String> reqAttrs = new ArrayList<String>(super.getRequiredAttributes());
        reqAttrs.addAll(REQ_ATTRS);
        return reqAttrs;
    }

    @Override
    protected List<String> getOptionalAttributes() {
        return super.getOptionalAttributes();
    }

    @Override
    public void validateAttributes() throws TagParseException {
        super.validateAttributes();
        if (this.isBodiless()) {
            throw new TagParseException(this.getName() + " tags must have a body.  Bodiless Group tag found" + this.getLocation());
        }
        TagContext context = this.getContext();
        Map<String, Object> beans = context.getBeans();
        Map<String, RichTextString> attributes = this.getAttributes();
        this.amIHiding = AttributeUtil.evaluateBoolean(this, attributes.get(ATTR_TEST), beans, true);
    }

    @Override
    public boolean process() {
        this.setHidden(this.amIHiding);
        BlockTransformer transformer = new BlockTransformer();
        transformer.transform(this.getContext(), this.getWorkbookContext());
        return true;
    }

    public abstract void setHidden(boolean var1);
}

