/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.parser;

public class TagScanner {
    private static final String PUNCT_CHARS_NOT_AS_STRING = "\":=<>/";
    private String myTagText;
    private int myOffset;
    private boolean amIInsideDoubleQuotes;
    private String myCurrLexeme;

    public TagScanner() {
        this("");
    }

    public TagScanner(String tagText) {
        this.setTagText(tagText);
    }

    public Token getNextToken() {
        int iStartOfToken = this.myOffset;
        int iTokenLength = 0;
        Token tokenType = Token.TOKEN_UNKNOWN;
        if (this.amIInsideDoubleQuotes) {
            if (iStartOfToken >= this.myTagText.length()) {
                iTokenLength = 0;
                tokenType = Token.TOKEN_ERROR_EOI_IN_DQUOTES;
            } else if (this.myTagText.charAt(iStartOfToken) == '\"') {
                iTokenLength = 1;
                tokenType = Token.TOKEN_DOUBLE_QUOTE;
                this.amIInsideDoubleQuotes = false;
            } else {
                while (iStartOfToken + iTokenLength < this.myTagText.length() && this.myTagText.charAt(iStartOfToken + iTokenLength) != '\"') {
                    if (this.myTagText.charAt(iStartOfToken + iTokenLength) == '\\' && iStartOfToken + iTokenLength + 1 < this.myTagText.length() && "\"\\'ntrbf".indexOf(this.myTagText.charAt(iStartOfToken + iTokenLength + 1)) >= 0) {
                        iTokenLength += 2;
                        continue;
                    }
                    ++iTokenLength;
                }
                tokenType = Token.TOKEN_STRING;
            }
        } else if (iStartOfToken >= this.myTagText.length()) {
            iTokenLength = 0;
            tokenType = Token.TOKEN_EOI;
        } else if (iStartOfToken + iTokenLength < this.myTagText.length() && !Character.isWhitespace(this.myTagText.charAt(iStartOfToken + iTokenLength)) && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myTagText.charAt(iStartOfToken + iTokenLength)) == -1) {
            while (iStartOfToken + iTokenLength < this.myTagText.length() && !Character.isWhitespace(this.myTagText.charAt(iStartOfToken + iTokenLength)) && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myTagText.charAt(iStartOfToken + iTokenLength)) == -1) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_STRING;
        } else if (this.myTagText.charAt(iStartOfToken) == ':') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_COLON;
        } else if (this.myTagText.charAt(iStartOfToken) == '=') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_EQUALS;
        } else if (this.myTagText.charAt(iStartOfToken) == '>') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_END_ANGLE_BRACKET;
        } else if (this.myTagText.charAt(iStartOfToken) == '<') {
            if (iStartOfToken + 1 < this.myTagText.length() && this.myTagText.charAt(iStartOfToken + 1) == '/') {
                tokenType = Token.TOKEN_BEGIN_ANGLE_BRACKET_SLASH;
                iTokenLength = 2;
            } else {
                iTokenLength = 1;
                tokenType = Token.TOKEN_BEGIN_ANGLE_BRACKET;
            }
        } else if (this.myTagText.charAt(iStartOfToken) == '/') {
            if (iStartOfToken + 1 < this.myTagText.length() && this.myTagText.charAt(iStartOfToken + 1) == '>') {
                tokenType = Token.TOKEN_SLASH_END_ANGLE_BRACKET;
                iTokenLength = 2;
            } else {
                tokenType = Token.TOKEN_UNKNOWN;
                iTokenLength = 1;
            }
        } else if (this.myTagText.charAt(iStartOfToken) == '\"') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_DOUBLE_QUOTE;
            this.amIInsideDoubleQuotes = true;
        } else if (Character.isWhitespace(this.myTagText.charAt(iStartOfToken))) {
            while (iStartOfToken + iTokenLength < this.myTagText.length() && Character.isWhitespace(this.myTagText.charAt(iStartOfToken + iTokenLength))) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_WHITESPACE;
        }
        this.myCurrLexeme = this.myTagText.substring(iStartOfToken, iStartOfToken + iTokenLength);
        this.myOffset += iTokenLength;
        return tokenType;
    }

    public String getCurrLexeme() {
        return this.myCurrLexeme;
    }

    public int getNextPosition() {
        return this.myOffset;
    }

    public void reset() {
        this.myOffset = 0;
        this.amIInsideDoubleQuotes = false;
        this.myCurrLexeme = null;
    }

    public void setTagText(String tagText) {
        this.myTagText = tagText;
        this.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        TOKEN_ERROR_EOI_IN_DQUOTES(-3),
        TOKEN_ERROR_BUF_NULL(-2),
        TOKEN_UNKNOWN(-1),
        TOKEN_WHITESPACE(0),
        TOKEN_STRING(1),
        TOKEN_COLON(11),
        TOKEN_DOUBLE_QUOTE(12),
        TOKEN_BEGIN_ANGLE_BRACKET(13),
        TOKEN_BEGIN_ANGLE_BRACKET_SLASH(14),
        TOKEN_END_ANGLE_BRACKET(15),
        TOKEN_SLASH_END_ANGLE_BRACKET(16),
        TOKEN_EQUALS(17),
        TOKEN_EOI(99);

        private int myCode;

        private Token(int code) {
            this.myCode = code;
        }

        public int getCode() {
            return this.myCode;
        }
    }
}

