/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.parser;

public class MetadataScanner {
    private static final String PUNCT_CHARS_NOT_AS_STRING = "\";=";
    private String myMetadataText;
    private int myOffset;
    private boolean amIInsideSingleQuotes;
    private boolean amIInsideDoubleQuotes;
    private String myCurrLexeme;

    public MetadataScanner() {
        this("");
    }

    public MetadataScanner(String metadataText) {
        this.setMetadataText(metadataText);
    }

    public Token getNextToken() {
        int iStartOfToken = this.myOffset;
        int iTokenLength = 0;
        Token tokenType = Token.TOKEN_UNKNOWN;
        if (this.amIInsideSingleQuotes) {
            if (iStartOfToken >= this.myMetadataText.length()) {
                iTokenLength = 0;
                tokenType = Token.TOKEN_ERROR_EOI_IN_SQUOTES;
            } else if (this.myMetadataText.charAt(iStartOfToken) == '\'') {
                iTokenLength = 1;
                tokenType = Token.TOKEN_SINGLE_QUOTE;
                this.amIInsideSingleQuotes = false;
            } else {
                while (iStartOfToken + iTokenLength < this.myMetadataText.length() && this.myMetadataText.charAt(iStartOfToken + iTokenLength) != '\'') {
                    ++iTokenLength;
                }
                tokenType = Token.TOKEN_STRING;
            }
        } else if (this.amIInsideDoubleQuotes) {
            if (iStartOfToken >= this.myMetadataText.length()) {
                iTokenLength = 0;
                tokenType = Token.TOKEN_ERROR_EOI_IN_DQUOTES;
            } else if (this.myMetadataText.charAt(iStartOfToken) == '\"') {
                iTokenLength = 1;
                tokenType = Token.TOKEN_DOUBLE_QUOTE;
                this.amIInsideDoubleQuotes = false;
            } else {
                while (iStartOfToken + iTokenLength < this.myMetadataText.length() && this.myMetadataText.charAt(iStartOfToken + iTokenLength) != '\"') {
                    ++iTokenLength;
                }
                tokenType = Token.TOKEN_STRING;
            }
        } else if (iStartOfToken >= this.myMetadataText.length()) {
            iTokenLength = 0;
            tokenType = Token.TOKEN_EOI;
        } else if (iStartOfToken + iTokenLength < this.myMetadataText.length() && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myMetadataText.charAt(iStartOfToken + iTokenLength)) == -1) {
            while (iStartOfToken + iTokenLength < this.myMetadataText.length() && PUNCT_CHARS_NOT_AS_STRING.indexOf(this.myMetadataText.charAt(iStartOfToken + iTokenLength)) == -1) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_STRING;
        } else if (this.myMetadataText.charAt(iStartOfToken) == ';') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_SEMICOLON;
        } else if (this.myMetadataText.charAt(iStartOfToken) == '=') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_EQUALS;
        } else if (this.myMetadataText.charAt(iStartOfToken) == '\"') {
            iTokenLength = 1;
            tokenType = Token.TOKEN_DOUBLE_QUOTE;
            this.amIInsideDoubleQuotes = true;
        } else if (Character.isWhitespace(this.myMetadataText.charAt(iStartOfToken))) {
            while (iStartOfToken + iTokenLength < this.myMetadataText.length() && Character.isWhitespace(this.myMetadataText.charAt(iStartOfToken + iTokenLength))) {
                ++iTokenLength;
            }
            tokenType = Token.TOKEN_WHITESPACE;
        }
        this.myCurrLexeme = this.myMetadataText.substring(iStartOfToken, iStartOfToken + iTokenLength);
        this.myOffset += iTokenLength;
        return tokenType;
    }

    public String getCurrLexeme() {
        return this.myCurrLexeme;
    }

    public void reset() {
        this.myOffset = 0;
        this.amIInsideDoubleQuotes = false;
        this.amIInsideSingleQuotes = false;
        this.myCurrLexeme = null;
    }

    public void setMetadataText(String metadataText) {
        this.myMetadataText = metadataText;
        this.reset();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Token {
        TOKEN_ERROR_EOI_IN_SQUOTES(-4),
        TOKEN_ERROR_EOI_IN_DQUOTES(-3),
        TOKEN_ERROR_BUF_NULL(-2),
        TOKEN_UNKNOWN(-1),
        TOKEN_WHITESPACE(0),
        TOKEN_STRING(1),
        TOKEN_SINGLE_QUOTE(11),
        TOKEN_DOUBLE_QUOTE(12),
        TOKEN_SEMICOLON(13),
        TOKEN_EQUALS(14),
        TOKEN_EOI(99);

        private int myCode;

        private Token(int code) {
            this.myCode = code;
        }

        public int getCode() {
            return this.myCode;
        }
    }
}

