/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.parser;

import java.util.Map;
import net.sf.jett.exception.MetadataParseException;
import net.sf.jett.parser.MetadataScanner;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetadataParser {
    public static final String VAR_NAME_EXTRA_ROWS = "extraRows";
    public static final String VAR_NAME_LEFT = "left";
    public static final String VAR_NAME_RIGHT = "right";
    public static final String VAR_NAME_COPY_RIGHT = "copyRight";
    public static final String VAR_NAME_FIXED = "fixed";
    public static final String VAR_NAME_PAST_END_ACTION = "pastEndAction";
    public static final String VAR_NAME_REPLACE_VALUE = "replaceValue";
    public static final String VAR_NAME_GROUP_DIR = "groupDir";
    public static final String VAR_NAME_COLLAPSE = "collapse";
    public static final String VAR_NAME_ON_LOOP_PROCESSED = "onLoopProcessed";
    public static final String VAR_NAME_ON_PROCESSED = "onProcessed";
    public static final String VAR_NAME_INDEXVAR = "indexVar";
    public static final String VAR_NAME_LIMIT = "limit";
    public static final String VAR_NAME_VAR_STATUS = "varStatus";
    private Cell myCell;
    private boolean amIExpectingAValue;
    private String myMetadataText;
    private String myExtraRows;
    private String myColsLeft;
    private String myColsRight;
    private boolean amIDefiningCols;
    private String myCopyingRight;
    private String myFixed;
    private String myPastEndActionValue;
    private String myReplacementValue;
    private String myGroupDir;
    private String myCollapsingGroup;
    private String myTagLoopListener;
    private String myTagListener;
    private String myIndexVarName;
    private String myLimit;
    private String myVarStatusName;

    public MetadataParser() {
        this.setMetadataText("");
    }

    public MetadataParser(String metadataText) {
        this.setMetadataText(metadataText);
    }

    public void setCell(Cell cell) {
        this.myCell = cell;
    }

    public void setMetadataText(String metadataText) {
        this.myMetadataText = metadataText;
        this.reset();
    }

    private void reset() {
        this.amIExpectingAValue = false;
        this.myExtraRows = null;
        this.myColsLeft = null;
        this.myColsRight = null;
        this.amIDefiningCols = false;
        this.myCopyingRight = null;
        this.myFixed = null;
        this.myPastEndActionValue = null;
        this.myReplacementValue = "";
        this.myGroupDir = null;
        this.myCollapsingGroup = null;
        this.myTagLoopListener = null;
        this.myTagListener = null;
        this.myIndexVarName = null;
        this.myLimit = null;
    }

    public void parse() {
        MetadataScanner scanner = new MetadataScanner(this.myMetadataText);
        Map<String, String> abbr = this.getAbbreviations();
        MetadataScanner.Token token = scanner.getNextToken();
        if (token == MetadataScanner.Token.TOKEN_WHITESPACE) {
            token = scanner.getNextToken();
        }
        String varName = null;
        while (token.getCode() >= 0 && token != MetadataScanner.Token.TOKEN_EOI) {
            switch (token) {
                case TOKEN_WHITESPACE: {
                    break;
                }
                case TOKEN_STRING: {
                    if (this.amIExpectingAValue) {
                        String lexeme = scanner.getCurrLexeme();
                        if (abbr != null && abbr.containsKey(varName)) {
                            varName = abbr.get(varName);
                        }
                        if (VAR_NAME_EXTRA_ROWS.equals(varName)) {
                            this.myExtraRows = lexeme;
                        } else if (VAR_NAME_LEFT.equals(varName)) {
                            this.myColsLeft = lexeme;
                            this.amIDefiningCols = true;
                        } else if (VAR_NAME_RIGHT.equals(varName)) {
                            this.myColsRight = lexeme;
                            this.amIDefiningCols = true;
                        } else if (VAR_NAME_COPY_RIGHT.equals(varName)) {
                            this.myCopyingRight = lexeme;
                        } else if (VAR_NAME_FIXED.equals(varName)) {
                            this.myFixed = lexeme;
                        } else if (VAR_NAME_PAST_END_ACTION.equals(varName)) {
                            this.myPastEndActionValue = lexeme;
                        } else if (VAR_NAME_REPLACE_VALUE.equals(varName)) {
                            this.myReplacementValue = lexeme;
                        } else if (VAR_NAME_GROUP_DIR.equals(varName)) {
                            this.myGroupDir = lexeme;
                        } else if (VAR_NAME_COLLAPSE.equals(varName)) {
                            this.myCollapsingGroup = lexeme;
                        } else if (VAR_NAME_ON_LOOP_PROCESSED.equals(varName)) {
                            this.myTagLoopListener = lexeme;
                        } else if (VAR_NAME_ON_PROCESSED.equals(varName)) {
                            this.myTagListener = lexeme;
                        } else if (VAR_NAME_INDEXVAR.equals(varName)) {
                            this.myIndexVarName = lexeme;
                        } else if (VAR_NAME_LIMIT.equals(varName)) {
                            this.myLimit = lexeme;
                        } else if (VAR_NAME_VAR_STATUS.equals(varName)) {
                            this.myVarStatusName = lexeme;
                        } else {
                            throw new MetadataParseException("Unrecognized variable name: \"" + varName + "\"." + SheetUtil.getCellLocation(this.myCell));
                        }
                        if (this.isRestricted(varName)) {
                            throw new MetadataParseException("Variable name \"" + varName + "\" is restricted in this context.");
                        }
                        varName = null;
                        this.amIExpectingAValue = false;
                        break;
                    }
                    varName = scanner.getCurrLexeme();
                    break;
                }
                case TOKEN_EQUALS: {
                    if (varName == null) {
                        throw new MetadataParseException("Variable name missing before \"=\": " + this.myMetadataText + SheetUtil.getCellLocation(this.myCell));
                    }
                    this.amIExpectingAValue = true;
                    break;
                }
                case TOKEN_SEMICOLON: {
                    break;
                }
                case TOKEN_DOUBLE_QUOTE: 
                case TOKEN_SINGLE_QUOTE: {
                    break;
                }
                default: {
                    throw new MetadataParseException("Parse error occurred: " + this.myMetadataText + SheetUtil.getCellLocation(this.myCell));
                }
            }
            token = scanner.getNextToken();
        }
        if (varName != null) {
            throw new MetadataParseException("Found end of metadata before equals sign at \"" + varName + "\": " + this.myMetadataText);
        }
        if (this.amIExpectingAValue) {
            throw new MetadataParseException("Found end of metadata before variable value: " + this.myMetadataText + SheetUtil.getCellLocation(this.myCell));
        }
        if (token.getCode() < 0) {
            throw new MetadataParseException("Found end of input while scanning metadata value: " + this.myMetadataText + SheetUtil.getCellLocation(this.myCell));
        }
    }

    protected boolean isRestricted(String metadataKey) {
        return false;
    }

    protected Map<String, String> getAbbreviations() {
        return null;
    }

    public String getExtraRows() {
        return this.myExtraRows;
    }

    public String getColsLeft() {
        return this.myColsLeft;
    }

    public String getColsRight() {
        return this.myColsRight;
    }

    public boolean isDefiningCols() {
        return this.amIDefiningCols;
    }

    public String getCopyingRight() {
        return this.myCopyingRight;
    }

    public String getFixed() {
        return this.myFixed;
    }

    public String getPastEndAction() {
        return this.myPastEndActionValue;
    }

    public String getReplacementValue() {
        return this.myReplacementValue;
    }

    public String getGroupDir() {
        return this.myGroupDir;
    }

    public String getCollapsingGroup() {
        return this.myCollapsingGroup;
    }

    public String getTagLoopListener() {
        return this.myTagLoopListener;
    }

    public String getTagListener() {
        return this.myTagListener;
    }

    public String getIndexVarName() {
        return this.myIndexVarName;
    }

    public String getLimit() {
        return this.myLimit;
    }

    public String getVarStatusName() {
        return this.myVarStatusName;
    }
}

