/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.parser;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import net.sf.jett.exception.FormulaParseException;
import net.sf.jett.formula.CellRef;
import net.sf.jett.parser.FormulaScanner;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.ss.usermodel.Cell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FormulaParser {
    private static final boolean DEBUG = false;
    private static final Pattern CELL_REF_PATTERN = Pattern.compile("\\$?[A-Za-z]+\\$?[1-9][0-9]*");
    private String myFormulaText;
    private List<CellRef> myCellReferences;
    private String mySheetName;
    private Cell myCell;
    private String myCellReference;
    private String myDefaultValue;
    private boolean amIInsideSingleQuotes;
    private boolean amIExpectingADefaultValue;

    public FormulaParser() {
        this.setFormulaText("");
    }

    public FormulaParser(String formulaText) {
        this.setFormulaText(formulaText);
    }

    public void setCell(Cell cell) {
        this.myCell = cell;
    }

    public void setFormulaText(String formulaText) {
        this.myFormulaText = formulaText;
        this.reset();
    }

    private void reset() {
        this.myCellReferences = new ArrayList<CellRef>();
        this.mySheetName = null;
        this.myCellReference = null;
        this.myDefaultValue = null;
        this.amIInsideSingleQuotes = false;
        this.amIExpectingADefaultValue = false;
    }

    public void parse() {
        FormulaScanner scanner = new FormulaScanner(this.myFormulaText);
        FormulaScanner.Token token = scanner.getNextToken();
        if (token == FormulaScanner.Token.TOKEN_WHITESPACE) {
            token = scanner.getNextToken();
        }
        while (token.getCode() >= 0 && token != FormulaScanner.Token.TOKEN_EOI) {
            switch (token) {
                case TOKEN_WHITESPACE: {
                    this.addCellReferenceIfFound();
                    this.mySheetName = null;
                    this.myCellReference = null;
                    break;
                }
                case TOKEN_STRING: {
                    if (this.amIExpectingADefaultValue) {
                        this.myDefaultValue = this.myDefaultValue == null ? scanner.getCurrLexeme() : this.myDefaultValue + scanner.getCurrLexeme();
                        this.amIExpectingADefaultValue = false;
                        break;
                    }
                    this.myCellReference = this.myCellReference == null ? scanner.getCurrLexeme() : this.myCellReference + scanner.getCurrLexeme();
                    break;
                }
                case TOKEN_EXCLAMATION: {
                    if (this.myCellReference == null) {
                        throw new FormulaParseException("Sheet name delimiter (\"!\") found with no sheet name: " + this.myFormulaText + SheetUtil.getCellLocation(this.myCell));
                    }
                    if (this.amIExpectingADefaultValue) {
                        throw new FormulaParseException("Sheet name delimiter (\"!\") found while expecting a default value: " + this.myFormulaText + SheetUtil.getCellLocation(this.myCell));
                    }
                    this.mySheetName = this.myCellReference;
                    this.myCellReference = null;
                    break;
                }
                case TOKEN_LEFT_PAREN: {
                    this.mySheetName = null;
                    this.myCellReference = null;
                    break;
                }
                case TOKEN_OPERATOR: {
                    if (this.amIExpectingADefaultValue && scanner.getCurrLexeme().charAt(0) == '-') {
                        this.myDefaultValue = "-";
                        break;
                    }
                    if (!this.addCellReferenceIfFound()) break;
                    this.myCellReference = this.myCellReference + scanner.getCurrLexeme();
                    break;
                }
                case TOKEN_RIGHT_PAREN: 
                case TOKEN_COMMA: 
                case TOKEN_DOUBLE_QUOTE: {
                    this.addCellReferenceIfFound();
                    break;
                }
                case TOKEN_SINGLE_QUOTE: {
                    this.amIInsideSingleQuotes = !this.amIInsideSingleQuotes;
                    break;
                }
                case TOKEN_DOUBLE_PIPE: {
                    if (this.amIExpectingADefaultValue) {
                        throw new FormulaParseException("Cannot have two default values for a cell reference: " + this.myFormulaText + SheetUtil.getCellLocation(this.myCell));
                    }
                    if (this.myCellReference == null) {
                        throw new FormulaParseException("Default value indicator (\"||\") found without a cell reference: " + this.myFormulaText + SheetUtil.getCellLocation(this.myCell));
                    }
                    this.amIExpectingADefaultValue = true;
                    break;
                }
                default: {
                    throw new FormulaParseException("Parse error occurred: " + this.myFormulaText + SheetUtil.getCellLocation(this.myCell));
                }
            }
            if ((token = scanner.getNextToken()) != FormulaScanner.Token.TOKEN_EOI) continue;
        }
        if (token.getCode() < 0) {
            throw new FormulaParseException("Found end of input while scanning formula text: " + this.myFormulaText + SheetUtil.getCellLocation(this.myCell));
        }
        this.addCellReferenceIfFound();
    }

    private boolean addCellReferenceIfFound() {
        if (this.myCellReference != null) {
            if (CELL_REF_PATTERN.matcher(this.myCellReference).matches()) {
                CellRef ref = this.mySheetName != null ? new CellRef(this.mySheetName + "!" + this.myCellReference) : new CellRef(this.myCellReference);
                if (this.myDefaultValue != null) {
                    ref.setDefaultValue(this.myDefaultValue);
                }
                if (!this.myCellReferences.contains(ref)) {
                    this.myCellReferences.add(ref);
                }
            } else if (this.mySheetName == null) {
                return true;
            }
        }
        this.mySheetName = null;
        this.myCellReference = null;
        this.myDefaultValue = null;
        return false;
    }

    public List<CellRef> getCellReferences() {
        return this.myCellReferences;
    }
}

