/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashMapWrapper<K, V>
extends HashMap<K, V> {
    private Map<K, V> myWrappedMap;
    private int mySize = 0;

    public HashMapWrapper(Map<K, V> otherMap) {
        this.myWrappedMap = otherMap;
        this.mySize = this.myWrappedMap.size();
    }

    @Override
    public void clear() {
        super.clear();
        this.myWrappedMap.clear();
        this.mySize = 0;
    }

    @Override
    public boolean containsKey(Object key) {
        return super.containsKey(key) || this.myWrappedMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return super.containsValue(value) || this.myWrappedMap.containsValue(value);
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet entrySet = new HashSet(super.entrySet());
        entrySet.addAll(this.myWrappedMap.entrySet());
        return entrySet;
    }

    @Override
    public V get(Object key) {
        if (super.containsKey(key)) {
            return super.get(key);
        }
        return this.myWrappedMap.get(key);
    }

    @Override
    public boolean isEmpty() {
        return super.isEmpty() && this.myWrappedMap.isEmpty();
    }

    @Override
    public Set<K> keySet() {
        HashSet keySet = new HashSet(super.keySet());
        keySet.addAll(this.myWrappedMap.keySet());
        return keySet;
    }

    @Override
    public V put(K key, V value) {
        V oldValue;
        if (!super.containsKey(key) && !this.myWrappedMap.containsKey(key)) {
            ++this.mySize;
        }
        if (super.containsKey(key)) {
            oldValue = super.put(key, value);
        } else {
            oldValue = this.myWrappedMap.get(key);
            super.put(key, value);
        }
        return oldValue;
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object key) {
        if (super.containsKey(key)) {
            if (!this.myWrappedMap.containsKey(key)) {
                --this.mySize;
            }
            return super.remove(key);
        }
        return null;
    }

    @Override
    public int size() {
        return this.mySize;
    }

    @Override
    public Collection<V> values() {
        ArrayList<V> values = new ArrayList<V>();
        for (Map.Entry<K, V> entry : this.entrySet()) {
            values.add(entry.getValue());
        }
        return values;
    }
}

