/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.model;

import java.util.HashMap;
import java.util.Map;
import net.sf.jett.util.SheetUtil;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.Color;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.xssf.usermodel.XSSFFont;

public class FontCache {
    private static final boolean DEBUG = false;
    private static final String PROP_SEP = "|";
    private Workbook myWorkbook;
    private Map<String, Font> myFontMap;

    public FontCache(Workbook workbook) {
        this.myWorkbook = workbook;
        this.myFontMap = new HashMap<String, Font>();
        this.cachePreExistingFonts();
    }

    private void cachePreExistingFonts() {
        short numFonts = this.myWorkbook.getNumberOfFonts();
        for (short i = 0; i < numFonts; i = (short)(i + 1)) {
            this.cacheFont(this.myWorkbook.getFontAt(i));
        }
    }

    public int getNumEntries() {
        return this.myFontMap.size();
    }

    public Font retrieveFont(short fontBoldweight, boolean fontItalic, Color fontColor, String fontName, short fontHeightInPoints, byte fontUnderline, boolean fontStrikeout, int fontCharset, short fontTypeOffset) {
        String representation = this.getRepresentation(fontBoldweight, fontItalic, fontColor, fontName, fontHeightInPoints, fontUnderline, fontStrikeout, fontCharset, fontTypeOffset);
        Font f = this.myFontMap.get(representation);
        return f;
    }

    public void cacheFont(Font f) {
        String representation = this.getRepresentation(f);
        this.myFontMap.put(representation, f);
    }

    public Font findFont(Font f) {
        String representation = this.getRepresentation(f);
        return this.myFontMap.get(representation);
    }

    private String getRepresentation(Font f) {
        HSSFColor fontColor;
        if (f instanceof HSSFFont) {
            HSSFFont hf = (HSSFFont)f;
            fontColor = hf.getHSSFColor((HSSFWorkbook)this.myWorkbook);
        } else if (f instanceof XSSFFont) {
            XSSFFont xf = (XSSFFont)f;
            fontColor = xf.getXSSFColor();
        } else {
            throw new IllegalArgumentException("Bad Font type: " + f.getClass().getName());
        }
        return this.getRepresentation(f.getBoldweight(), f.getItalic(), (Color)fontColor, f.getFontName(), f.getFontHeightInPoints(), f.getUnderline(), f.getStrikeout(), f.getCharSet(), f.getTypeOffset());
    }

    private String getRepresentation(short fontBoldweight, boolean fontItalic, Color fontColor, String fontName, short fontHeightInPoints, byte fontUnderline, boolean fontStrikeout, int fontCharset, short fontTypeOffset) {
        StringBuilder buf = new StringBuilder();
        buf.append(fontBoldweight).append(PROP_SEP);
        buf.append(fontItalic).append(PROP_SEP);
        buf.append(SheetUtil.getColorHexString(fontColor));
        buf.append(PROP_SEP).append(fontName);
        buf.append(PROP_SEP).append(fontHeightInPoints);
        buf.append(PROP_SEP).append(fontUnderline);
        buf.append(PROP_SEP).append(fontStrikeout);
        buf.append(PROP_SEP).append(fontCharset);
        buf.append(PROP_SEP).append(fontTypeOffset);
        return buf.toString();
    }
}

