/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.model;

import org.apache.poi.hssf.util.HSSFColor;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.xssf.usermodel.XSSFColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ExcelColor {
    AQUA((HSSFColor)new HSSFColor.AQUA(), IndexedColors.AQUA, 51, 204, 204),
    AUTOMATIC((HSSFColor)new HSSFColor.AUTOMATIC(), IndexedColors.AUTOMATIC, 0, 0, 0),
    BLACK((HSSFColor)new HSSFColor.BLACK(), IndexedColors.BLACK, 0, 0, 0),
    BLUE((HSSFColor)new HSSFColor.BLUE(), IndexedColors.BLUE, 0, 0, 255),
    BLUEGREY((HSSFColor)new HSSFColor.BLUE_GREY(), IndexedColors.BLUE_GREY, 102, 102, 153),
    BRIGHTGREEN((HSSFColor)new HSSFColor.BRIGHT_GREEN(), IndexedColors.BRIGHT_GREEN, 0, 255, 0),
    BROWN((HSSFColor)new HSSFColor.BROWN(), IndexedColors.BROWN, 153, 51, 0),
    CORAL((HSSFColor)new HSSFColor.CORAL(), IndexedColors.CORAL, 255, 128, 128),
    CORNFLOWERBLUE((HSSFColor)new HSSFColor.CORNFLOWER_BLUE(), IndexedColors.CORNFLOWER_BLUE, 153, 153, 255),
    DARKBLUE((HSSFColor)new HSSFColor.DARK_BLUE(), IndexedColors.DARK_BLUE, 0, 0, 128),
    DARKGREEN((HSSFColor)new HSSFColor.DARK_GREEN(), IndexedColors.DARK_GREEN, 0, 51, 0),
    DARKRED((HSSFColor)new HSSFColor.DARK_RED(), IndexedColors.DARK_RED, 128, 0, 0),
    DARKTEAL((HSSFColor)new HSSFColor.DARK_TEAL(), IndexedColors.DARK_TEAL, 0, 51, 102),
    DARKYELLOW((HSSFColor)new HSSFColor.DARK_YELLOW(), IndexedColors.DARK_YELLOW, 128, 128, 0),
    GOLD((HSSFColor)new HSSFColor.GOLD(), IndexedColors.GOLD, 255, 204, 0),
    GREEN((HSSFColor)new HSSFColor.GREEN(), IndexedColors.GREEN, 0, 128, 0),
    GREY25PERCENT((HSSFColor)new HSSFColor.GREY_25_PERCENT(), IndexedColors.GREY_25_PERCENT, 192, 192, 192),
    GREY40PERCENT((HSSFColor)new HSSFColor.GREY_40_PERCENT(), IndexedColors.GREY_40_PERCENT, 150, 150, 150),
    GREY50PERCENT((HSSFColor)new HSSFColor.GREY_50_PERCENT(), IndexedColors.GREY_50_PERCENT, 128, 128, 128),
    GREY80PERCENT((HSSFColor)new HSSFColor.GREY_80_PERCENT(), IndexedColors.GREY_80_PERCENT, 51, 51, 51),
    INDIGO((HSSFColor)new HSSFColor.INDIGO(), IndexedColors.INDIGO, 51, 51, 153),
    LAVENDER((HSSFColor)new HSSFColor.LAVENDER(), IndexedColors.LAVENDER, 204, 153, 255),
    LEMONCHIFFON((HSSFColor)new HSSFColor.LEMON_CHIFFON(), IndexedColors.LEMON_CHIFFON, 255, 255, 204),
    LIGHTBLUE((HSSFColor)new HSSFColor.LIGHT_BLUE(), IndexedColors.LIGHT_BLUE, 51, 102, 255),
    LIGHTCORNFLOWERBLUE((HSSFColor)new HSSFColor.LIGHT_CORNFLOWER_BLUE(), IndexedColors.LIGHT_CORNFLOWER_BLUE, 204, 204, 255),
    LIGHTGREEN((HSSFColor)new HSSFColor.LIGHT_GREEN(), IndexedColors.LIGHT_GREEN, 204, 255, 204),
    LIGHTORANGE((HSSFColor)new HSSFColor.LIGHT_ORANGE(), IndexedColors.LIGHT_ORANGE, 255, 153, 0),
    LIGHTTURQUOISE((HSSFColor)new HSSFColor.LIGHT_TURQUOISE(), IndexedColors.LIGHT_TURQUOISE, 204, 255, 255),
    LIGHTYELLOW((HSSFColor)new HSSFColor.LIGHT_YELLOW(), IndexedColors.LIGHT_YELLOW, 255, 255, 153),
    LIME((HSSFColor)new HSSFColor.LIME(), IndexedColors.LIME, 153, 204, 0),
    MAROON((HSSFColor)new HSSFColor.MAROON(), IndexedColors.MAROON, 128, 0, 0),
    OLIVEGREEN((HSSFColor)new HSSFColor.OLIVE_GREEN(), IndexedColors.OLIVE_GREEN, 51, 51, 0),
    ORANGE((HSSFColor)new HSSFColor.ORANGE(), IndexedColors.ORANGE, 255, 102, 0),
    ORCHID((HSSFColor)new HSSFColor.ORCHID(), IndexedColors.ORCHID, 102, 0, 102),
    PALEBLUE((HSSFColor)new HSSFColor.PALE_BLUE(), IndexedColors.PALE_BLUE, 153, 204, 255),
    PINK((HSSFColor)new HSSFColor.PINK(), IndexedColors.PINK, 255, 0, 255),
    PLUM((HSSFColor)new HSSFColor.PLUM(), IndexedColors.PLUM, 153, 51, 102),
    RED((HSSFColor)new HSSFColor.RED(), IndexedColors.RED, 255, 0, 0),
    ROSE((HSSFColor)new HSSFColor.ROSE(), IndexedColors.ROSE, 255, 103, 204),
    ROYALBLUE((HSSFColor)new HSSFColor.ROYAL_BLUE(), IndexedColors.ROYAL_BLUE, 0, 102, 204),
    SEAGREEN((HSSFColor)new HSSFColor.SEA_GREEN(), IndexedColors.SEA_GREEN, 51, 153, 102),
    SKYBLUE((HSSFColor)new HSSFColor.SKY_BLUE(), IndexedColors.SKY_BLUE, 0, 204, 255),
    TAN((HSSFColor)new HSSFColor.TAN(), IndexedColors.TAN, 255, 204, 153),
    TEAL((HSSFColor)new HSSFColor.TEAL(), IndexedColors.TEAL, 0, 128, 128),
    TURQUOISE((HSSFColor)new HSSFColor.TURQUOISE(), IndexedColors.TURQUOISE, 0, 255, 255),
    VIOLET((HSSFColor)new HSSFColor.VIOLET(), IndexedColors.VIOLET, 128, 0, 128),
    WHITE((HSSFColor)new HSSFColor.WHITE(), IndexedColors.WHITE, 255, 255, 255),
    YELLOW((HSSFColor)new HSSFColor.YELLOW(), IndexedColors.YELLOW, 255, 255, 0);

    public static final HSSFColor HSSF_COLOR_AUTOMATIC;
    public static final short XSSF_COLOR_COMMENT = 81;
    private HSSFColor myHssfColor;
    private XSSFColor myXssfColor;
    private IndexedColors myIndexedColor;
    private int myRed;
    private int myGreen;
    private int myBlue;
    private static HSSFColor[] hssfColors;

    private ExcelColor(HSSFColor hssfColor, IndexedColors indexedColor, int red, int green, int blue) {
        this.myHssfColor = hssfColor;
        this.myXssfColor = new XSSFColor(new byte[]{(byte)red, (byte)green, (byte)blue});
        this.myIndexedColor = indexedColor;
        this.myRed = red;
        this.myGreen = green;
        this.myBlue = blue;
    }

    public HSSFColor getHssfColor() {
        return this.myHssfColor;
    }

    public XSSFColor getXssfColor() {
        return this.myXssfColor;
    }

    public int getIndex() {
        return this.myIndexedColor.getIndex();
    }

    public IndexedColors getIndexedColor() {
        return this.myIndexedColor;
    }

    public int getRed() {
        return this.myRed;
    }

    public int getGreen() {
        return this.myGreen;
    }

    public int getBlue() {
        return this.myBlue;
    }

    public String getHexString() {
        StringBuilder builder = new StringBuilder();
        builder.append("#");
        String value = Integer.toHexString(this.myRed);
        if (value.length() == 1) {
            builder.append("0");
        }
        builder.append(value);
        value = Integer.toHexString(this.myGreen);
        if (value.length() == 1) {
            builder.append("0");
        }
        builder.append(value);
        value = Integer.toHexString(this.myBlue);
        if (value.length() == 1) {
            builder.append("0");
        }
        builder.append(value);
        return builder.toString();
    }

    public int distance(int red, int green, int blue) {
        return Math.abs(red - this.myRed) + Math.abs(green - this.myGreen) + Math.abs(blue - this.myBlue);
    }

    public String toString() {
        return this.name().trim().toLowerCase().replace("_", "");
    }

    public static HSSFColor getHssfColorByIndex(short index) {
        if (index == Short.MAX_VALUE || index == 81) {
            return HSSF_COLOR_AUTOMATIC;
        }
        return hssfColors[index];
    }

    static {
        HSSF_COLOR_AUTOMATIC = new HSSFColor.AUTOMATIC();
        hssfColors = new HSSFColor[65];
        for (ExcelColor excelColor : ExcelColor.values()) {
            HSSFColor hssfColor;
            ExcelColor.hssfColors[hssfColor.getIndex()] = hssfColor = excelColor.getHssfColor();
        }
    }
}

