/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.model;

import org.apache.poi.ss.usermodel.Cell;

public class Block {
    private int myLeftColNum;
    private int myRightColNum;
    private int myTopRowNum;
    private int myBottomRowNum;
    private Direction myDirection;
    private Block myParent;

    public Block(Block parent, Cell startTag, Cell endTag) {
        this.myTopRowNum = startTag.getRowIndex();
        this.myBottomRowNum = endTag.getRowIndex();
        this.myLeftColNum = startTag.getColumnIndex();
        this.myRightColNum = endTag.getColumnIndex();
        this.myDirection = Direction.VERTICAL;
        this.myParent = parent;
    }

    public Block(Block parent, Cell tag) {
        this.myTopRowNum = tag.getRowIndex();
        this.myBottomRowNum = tag.getRowIndex();
        this.myLeftColNum = tag.getColumnIndex();
        this.myRightColNum = tag.getColumnIndex();
        this.myDirection = Direction.NONE;
        this.myParent = parent;
    }

    public Block(Block parent, int left, int right, int top, int bottom) {
        this.myLeftColNum = left;
        this.myRightColNum = right;
        this.myTopRowNum = top;
        this.myBottomRowNum = bottom;
        this.myDirection = Direction.VERTICAL;
        this.myParent = parent;
    }

    public int getLeftColNum() {
        return this.myLeftColNum;
    }

    public int getRightColNum() {
        return this.myRightColNum;
    }

    public int getTopRowNum() {
        return this.myTopRowNum;
    }

    public int getBottomRowNum() {
        return this.myBottomRowNum;
    }

    public Direction getDirection() {
        return this.myDirection;
    }

    public void setDirection(Direction dir) {
        this.myDirection = dir;
    }

    public void translate(int cols, int rows) {
        this.myLeftColNum += cols;
        this.myRightColNum += cols;
        this.myTopRowNum += rows;
        this.myBottomRowNum += rows;
    }

    public void expand(int cols, int rows) {
        this.myRightColNum += cols;
        this.myBottomRowNum += rows;
    }

    public void collapse() {
        this.myRightColNum = this.myLeftColNum - 1;
        this.myBottomRowNum = this.myTopRowNum - 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Block: left=");
        buf.append(this.myLeftColNum);
        buf.append(", right=");
        buf.append(this.myRightColNum);
        buf.append(", top=");
        buf.append(this.myTopRowNum);
        buf.append(", bottom=");
        buf.append(this.myBottomRowNum);
        buf.append(", direction=");
        buf.append((Object)this.myDirection);
        return buf.toString();
    }

    public Block getParent() {
        return this.myParent;
    }

    public void reactToGrowth(Block sibling, int colGrowth, int rowGrowth) {
        switch (this.myDirection) {
            case VERTICAL: {
                int diff;
                if (colGrowth > 0 && (diff = sibling.myRightColNum - sibling.myLeftColNum - this.myRightColNum + this.myLeftColNum) > 0) {
                    this.expand(diff, 0);
                }
                this.translate(0, rowGrowth);
                break;
            }
            case HORIZONTAL: {
                int diff;
                this.translate(colGrowth, 0);
                if (rowGrowth <= 0 || (diff = sibling.myBottomRowNum - sibling.myTopRowNum - this.myBottomRowNum + this.myTopRowNum) <= 0) break;
                this.expand(0, diff);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Direction {
        VERTICAL,
        HORIZONTAL,
        NONE;

    }
}

