/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.model;

import net.sf.jett.model.LoopTagStatus;
import net.sf.jett.tag.Tag;

public class BaseLoopTagStatus
implements LoopTagStatus {
    private int myNumIterations;
    private int myCurrIndex;
    private Tag myParentTag;

    public BaseLoopTagStatus(Tag tag, int numIterations) {
        if (tag == null) {
            throw new IllegalArgumentException("The tag parameter must not be null!");
        }
        this.myParentTag = tag;
        this.myNumIterations = numIterations;
        this.myCurrIndex = 0;
    }

    public BaseLoopTagStatus(int currIteration, int numIterations) {
        if (currIteration < 0 || currIteration >= numIterations) {
            throw new IllegalArgumentException("The current iteration number (" + currIteration + ") must be at least 0 and less than the number of iterations (" + numIterations + ")!");
        }
        this.myParentTag = null;
        this.myNumIterations = numIterations;
        this.myCurrIndex = currIteration;
    }

    public int getIndex() {
        return this.myCurrIndex;
    }

    public boolean isFirst() {
        return this.myCurrIndex == 0;
    }

    public boolean isLast() {
        return this.myCurrIndex + 1 == this.myNumIterations;
    }

    public int getNumIterations() {
        return this.myNumIterations;
    }

    public void incrementIndex(Tag tag) {
        if (tag == null || tag != this.myParentTag) {
            throw new IllegalArgumentException("Tag given is not this object's parent tag!");
        }
        ++this.myCurrIndex;
    }
}

