/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.formula;

import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.util.CellReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CellRef
extends CellReference
implements Comparable<CellRef> {
    public static final String DEF_DEFAULT_VALUE = "0";
    public static final String DEFAULT_VALUE_IND = "||";
    private String myDefaultValue = null;

    public CellRef(String cellRef) {
        super(cellRef);
    }

    public CellRef(int pRow, int pCol) {
        super(pRow, pCol);
    }

    public CellRef(int pRow, short pCol) {
        super(pRow, pCol);
    }

    public CellRef(Cell cell) {
        super(cell);
    }

    public CellRef(int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        super(pRow, pCol, pAbsRow, pAbsCol);
    }

    public CellRef(String pSheetName, int pRow, int pCol, boolean pAbsRow, boolean pAbsCol) {
        super(pSheetName, pRow, pCol, pAbsRow, pAbsCol);
    }

    public boolean equals(Object o) {
        if (!(o instanceof CellRef)) {
            return false;
        }
        CellRef cr = (CellRef)o;
        return this.getRow() == cr.getRow() && this.getCol() == cr.getCol() && this.isRowAbsolute() == cr.isRowAbsolute() && this.isColAbsolute() == cr.isColAbsolute() && (this.getSheetName() == null && cr.getSheetName() == null || this.getSheetName() != null && this.getSheetName().equals(cr.getSheetName()));
    }

    public void setDefaultValue(String defaultValue) {
        this.myDefaultValue = defaultValue;
    }

    public String getDefaultValue() {
        return this.myDefaultValue;
    }

    public String formatAsStringWithDef() {
        String formatted = this.formatAsString();
        if (this.myDefaultValue != null) {
            formatted = formatted + DEFAULT_VALUE_IND + this.myDefaultValue;
        }
        return formatted;
    }

    @Override
    public int compareTo(CellRef other) {
        int comp;
        String sheetName1 = "";
        String sheetName2 = "";
        if (this.getSheetName() != null) {
            sheetName1 = this.getSheetName();
        }
        if (other.getSheetName() != null) {
            sheetName2 = other.getSheetName();
        }
        if ((comp = sheetName1.compareTo(sheetName2)) != 0) {
            return comp;
        }
        comp = this.getRow() - other.getRow();
        if (comp != 0) {
            return comp;
        }
        return this.getCol() - other.getCol();
    }
}

