/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.expression;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.poi.ss.util.CellReference;

public class JettFuncs {
    private static final Integer[] CARDS = new Integer[52];
    private static int numCardsDealt = 0;

    public static String cellRef(int rowNum, int colNum) {
        return CellReference.convertNumToColString((int)colNum) + (rowNum + 1);
    }

    public static String cellRef(int rowNum, int colNum, int numRows, int numCols) {
        return CellReference.convertNumToColString((int)colNum) + (rowNum + 1) + ":" + CellReference.convertNumToColString((int)(colNum + numCols - 1)) + (rowNum + numRows);
    }

    public static String pickACard() {
        int index;
        if (numCardsDealt == 0) {
            for (int i = 0; i < CARDS.length; ++i) {
                JettFuncs.CARDS[i] = i;
            }
        }
        if ((index = numCardsDealt % CARDS.length) == 0) {
            List<Integer> asList = Arrays.asList(CARDS);
            Collections.shuffle(asList);
        }
        int card = CARDS[index];
        int suit = card / 13;
        int rank = card % 13;
        ++numCardsDealt;
        StringBuilder buf = new StringBuilder();
        switch (rank) {
            case 0: {
                buf.append("Two");
                break;
            }
            case 1: {
                buf.append("Three");
                break;
            }
            case 2: {
                buf.append("Four");
                break;
            }
            case 3: {
                buf.append("Five");
                break;
            }
            case 4: {
                buf.append("Six");
                break;
            }
            case 5: {
                buf.append("Seven");
                break;
            }
            case 6: {
                buf.append("Eight");
                break;
            }
            case 7: {
                buf.append("Nine");
                break;
            }
            case 8: {
                buf.append("Ten");
                break;
            }
            case 9: {
                buf.append("Jack");
                break;
            }
            case 10: {
                buf.append("Queen");
                break;
            }
            case 11: {
                buf.append("King");
                break;
            }
            case 12: {
                buf.append("Ace");
            }
        }
        buf.append(" of ");
        switch (suit) {
            case 0: {
                buf.append("Clubs");
                break;
            }
            case 1: {
                buf.append("Diamonds");
                break;
            }
            case 2: {
                buf.append("Spades");
                break;
            }
            case 3: {
                buf.append("Hearts");
            }
        }
        return buf.toString();
    }
}

