/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.expression;

import java.util.HashMap;
import java.util.Map;
import net.sf.jett.expression.JaggFuncs;
import net.sf.jett.expression.JettFuncs;
import org.apache.commons.jexl2.Expression;
import org.apache.commons.jexl2.JexlEngine;

public class ExpressionFactory {
    private JexlEngine myEngine = new JexlEngine();
    private Map<String, Object> myFuncs;
    private Map<String, Expression> myExpressionCache;

    public ExpressionFactory() {
        this.myEngine.setLenient(true);
        this.myEngine.setSilent(false);
        this.myEngine.setDebug(false);
        this.myFuncs = new HashMap<String, Object>();
        this.myEngine.setFunctions(this.myFuncs);
        this.myFuncs.put("jagg", JaggFuncs.class);
        this.myFuncs.put("jett", JettFuncs.class);
        this.myExpressionCache = new HashMap<String, Expression>();
    }

    public void setLenient(boolean lenient) {
        this.myEngine.setLenient(lenient);
    }

    public boolean isLenient() {
        return this.myEngine.isLenient();
    }

    public void setSilent(boolean silent) {
        this.myEngine.setSilent(silent);
    }

    public boolean isSilent() {
        return this.myEngine.isSilent();
    }

    public void setCache(int size) {
        this.myEngine.setCache(size);
    }

    public void setDebug(boolean debug) {
        this.myEngine.setDebug(debug);
    }

    public void registerFuncs(String namespace, Object funcsObject) {
        if (this.myFuncs.get(namespace) != null) {
            throw new IllegalArgumentException("A functions object with namespace \"" + namespace + "\" has already been registered.");
        }
        this.myFuncs.put(namespace, funcsObject);
    }

    public Expression createExpression(String expression) {
        Expression jexlExpr = this.myExpressionCache.get(expression);
        if (jexlExpr == null) {
            jexlExpr = this.myEngine.createExpression(expression);
            this.myExpressionCache.put(expression, jexlExpr);
        }
        return jexlExpr;
    }
}

