/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.expression;

import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jett.exception.ParseException;
import net.sf.jett.expression.ClassAwareMapContext;
import net.sf.jett.expression.ExpressionFactory;
import net.sf.jett.model.WorkbookContext;
import net.sf.jett.util.FormulaUtil;
import net.sf.jett.util.RichTextStringUtil;
import org.apache.commons.jexl2.JexlContext;
import org.apache.commons.jexl2.parser.ASTIdentifier;
import org.apache.commons.jexl2.parser.ASTJexlScript;
import org.apache.commons.jexl2.parser.ASTMethodNode;
import org.apache.commons.jexl2.parser.ASTNumberLiteral;
import org.apache.commons.jexl2.parser.ASTReference;
import org.apache.commons.jexl2.parser.ASTSizeMethod;
import org.apache.commons.jexl2.parser.JexlNode;
import org.apache.commons.jexl2.parser.Node;
import org.apache.commons.jexl2.parser.Parser;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.RichTextString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Expression {
    private static final boolean DEBUG = false;
    private static final Map<String, String> MAP_EXPRESSION_TO_COLL_NAMES = new HashMap<String, String>();
    public static final String NEGATIVE_LOOKBEHIND_BACKSLASH = "(?<![\\\\])";
    public static final String BEGIN_EXPR = "${";
    public static final String END_EXPR = "}";
    private String myExpression;

    public Expression(String expression) {
        this.myExpression = expression;
    }

    public Object evaluate(ExpressionFactory factory, Map<String, Object> beans) {
        if (beans != null && !beans.isEmpty()) {
            ClassAwareMapContext context = new ClassAwareMapContext(beans);
            return factory.createExpression(this.myExpression).evaluate((JexlContext)context);
        }
        return this.myExpression;
    }

    private List<ASTReference> findReferences(Node node) {
        ArrayList<ASTReference> references = new ArrayList<ASTReference>();
        if (node instanceof ASTReference) {
            references.add((ASTReference)node);
        }
        int count = node.jjtGetNumChildren();
        for (int i = 0; i < count; ++i) {
            references.addAll(this.findReferences(node.jjtGetChild(i)));
        }
        return references;
    }

    private String findCollectionName(ASTReference node, Map<String, Object> beans, WorkbookContext context) {
        ExpressionFactory factory = context.getExpressionFactory();
        List<String> noImplProcCollNames = context.getNoImplicitProcessingCollectionNames();
        int count = node.jjtGetNumChildren();
        String collectionName = null;
        for (int i = 0; i < count; ++i) {
            Expression expr;
            Object result;
            JexlNode child = node.jjtGetChild(i);
            if (!(child instanceof ASTIdentifier)) continue;
            ASTIdentifier identifier = (ASTIdentifier)child;
            collectionName = collectionName == null ? identifier.image : collectionName + "." + identifier.image;
            if (noImplProcCollNames.contains(identifier.image) || !((result = (expr = new Expression(collectionName)).evaluate(factory, beans)) instanceof Collection)) continue;
            if (i < count - 1) {
                JexlNode nextChild = node.jjtGetChild(i + 1);
                if (nextChild instanceof ASTMethodNode) {
                    ASTMethodNode methodNode = (ASTMethodNode)nextChild;
                    ASTIdentifier childIdentifier = (ASTIdentifier)methodNode.jjtGetChild(0);
                    if (childIdentifier.image != null && (childIdentifier.image.startsWith("capacity") || childIdentifier.image.startsWith("contains") || childIdentifier.image.startsWith("element") || childIdentifier.image.startsWith("equals") || childIdentifier.image.equals("get") || childIdentifier.image.startsWith("hashCode") || childIdentifier.image.startsWith("indexOf") || childIdentifier.image.startsWith("isEmpty") || childIdentifier.image.startsWith("lastIndexOf") || childIdentifier.image.startsWith("size") || childIdentifier.image.startsWith("toString"))) {
                        continue;
                    }
                } else if (nextChild instanceof ASTSizeMethod || nextChild instanceof ASTNumberLiteral) {
                    continue;
                }
            } else {
                return null;
            }
            return collectionName;
        }
        return null;
    }

    public String getValueIndicatingImplicitCollection(Map<String, Object> beans, WorkbookContext context) {
        String expression = this.myExpression;
        String cachedResult = MAP_EXPRESSION_TO_COLL_NAMES.get(expression);
        if (cachedResult != null) {
            return cachedResult;
        }
        Parser parser = new Parser((Reader)new StringReader(";"));
        try {
            ASTJexlScript tree = parser.parse((Reader)new StringReader(expression), null);
            List<ASTReference> references = this.findReferences((Node)tree);
            for (ASTReference node : references) {
                String collectionName = this.findCollectionName(node, beans, context);
                if (collectionName == null) continue;
                MAP_EXPRESSION_TO_COLL_NAMES.put(expression, collectionName);
                return collectionName;
            }
        }
        catch (org.apache.commons.jexl2.parser.ParseException e) {
            throw new ParseException("JEXL ParseException caught on expression \"" + expression + "\": " + e.getMessage(), e);
        }
        MAP_EXPRESSION_TO_COLL_NAMES.put(expression, "");
        return null;
    }

    public static void clearExpressionToCollNamesMap() {
        MAP_EXPRESSION_TO_COLL_NAMES.clear();
    }

    public static List<String> getImplicitCollectionExpr(String value, Map<String, Object> beans, WorkbookContext context) {
        ExpressionFactory factory = context.getExpressionFactory();
        List<Expression> expressions = Expression.getExpressions(value);
        ArrayList<String> implicitCollections = new ArrayList<String>();
        boolean lenient = factory.isLenient();
        boolean silent = factory.isSilent();
        factory.setLenient(true);
        factory.setSilent(true);
        if (value.startsWith(BEGIN_EXPR) && value.endsWith(END_EXPR) && expressions.size() == 1) {
            Expression expression = new Expression(value.substring(2, value.length() - 1));
            String implColl = expression.getValueIndicatingImplicitCollection(beans, context);
            if (implColl != null && !"".equals(implColl)) {
                implicitCollections.add(implColl);
            }
        } else if (expressions.size() >= 1) {
            for (Expression expression : expressions) {
                String implColl = expression.getValueIndicatingImplicitCollection(beans, context);
                if (implColl == null || "".equals(implColl)) continue;
                implicitCollections.add(implColl);
            }
        }
        factory.setLenient(lenient);
        factory.setSilent(silent);
        return implicitCollections;
    }

    public static Object evaluateString(RichTextString richTextString, CreationHelper helper, ExpressionFactory factory, Map<String, Object> beans) {
        String value = richTextString.getString();
        List<Expression> expressions = Expression.getExpressions(value);
        if (value.startsWith(BEGIN_EXPR) && value.endsWith(END_EXPR) && expressions.size() == 1) {
            Expression expression = new Expression(value.substring(2, value.length() - 1));
            Object result = expression.evaluate(factory, beans);
            if (result instanceof String) {
                return RichTextStringUtil.replaceAll(richTextString, helper, value, (String)result, true);
            }
            return result;
        }
        return Expression.replaceExpressions(richTextString, helper, expressions, factory, beans);
    }

    public static Object evaluateString(String value, ExpressionFactory factory, Map<String, Object> beans) {
        List<Expression> expressions = Expression.getExpressions(value);
        if (value.startsWith(BEGIN_EXPR) && value.endsWith(END_EXPR) && expressions.size() == 1) {
            Expression expression = new Expression(value.substring(2, value.length() - 1));
            return expression.evaluate(factory, beans);
        }
        return Expression.replaceExpressions(value, expressions, factory, beans);
    }

    private static List<Expression> getExpressions(String value) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        int beginIdx = value.indexOf(BEGIN_EXPR);
        int endIdx = Expression.findEndOfExpression(value, beginIdx + BEGIN_EXPR.length());
        while (beginIdx != -1 && endIdx != -1 && endIdx > beginIdx) {
            int formulaBeginIdx = value.indexOf("$[");
            int formulaEndIdx = formulaBeginIdx != -1 ? FormulaUtil.getEndOfJettFormula(value, formulaBeginIdx) : value.indexOf("]");
            boolean exprFound = true;
            if (beginIdx > 0 && value.charAt(beginIdx - 1) == '\\') {
                exprFound = false;
            }
            if (formulaBeginIdx != -1 && formulaEndIdx != -1 && formulaBeginIdx < beginIdx && formulaEndIdx > endIdx) {
                exprFound = false;
            }
            if (exprFound) {
                String strExpr = value.substring(beginIdx + 2, endIdx);
                Expression expr = new Expression(strExpr);
                expressions.add(expr);
            }
            beginIdx = value.indexOf(BEGIN_EXPR, endIdx + 1);
            endIdx = Expression.findEndOfExpression(value, beginIdx + BEGIN_EXPR.length());
        }
        return expressions;
    }

    private static String replaceExpressions(String value, List<Expression> expressions, ExpressionFactory factory, Map<String, Object> beans) {
        for (Expression expr : expressions) {
            int beginIdx = value.indexOf(BEGIN_EXPR);
            int endIdx = beginIdx + BEGIN_EXPR.length() + expr.myExpression.length();
            if (beginIdx == -1 || endIdx == -1 || endIdx <= beginIdx) break;
            String replaceMe = value.substring(beginIdx, endIdx + 1);
            Object result = expr.evaluate(factory, beans);
            String replaceWith = "";
            if (result != null) {
                replaceWith = expr.evaluate(factory, beans).toString();
            }
            value = value.replaceFirst(NEGATIVE_LOOKBEHIND_BACKSLASH + Pattern.quote(replaceMe), Matcher.quoteReplacement(replaceWith));
        }
        value = value.replace("\\${", BEGIN_EXPR);
        return value;
    }

    private static RichTextString replaceExpressions(RichTextString richTextString, CreationHelper helper, List<Expression> expressions, ExpressionFactory factory, Map<String, Object> beans) {
        ArrayList<String> exprStrings = new ArrayList<String>(expressions.size());
        ArrayList<String> exprValues = new ArrayList<String>(expressions.size());
        for (Expression expr : expressions) {
            exprStrings.add(BEGIN_EXPR + expr.myExpression + END_EXPR);
            Object result = expr.evaluate(factory, beans);
            if (result != null) {
                exprValues.add(result.toString());
                continue;
            }
            exprValues.add("");
        }
        return RichTextStringUtil.replaceValues(richTextString, helper, exprStrings, exprValues, false);
    }

    private static int findEndOfExpression(String value, int startIdx) {
        int begins = 1;
        int ends = 0;
        for (int i = startIdx; i < value.length(); ++i) {
            char c = value.charAt(i);
            if (c == '{') {
                ++begins;
            } else if (c == '}') {
                ++ends;
            }
            if (begins != ends) continue;
            return i;
        }
        return -1;
    }
}

