/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jett.expression;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.jexl2.MapContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassAwareMapContext
extends MapContext {
    private static final Map<String, Object> additionalValues = new HashMap<String, Object>();

    public ClassAwareMapContext() {
    }

    public ClassAwareMapContext(Map<String, Object> beans) {
        super(beans);
    }

    public boolean has(String name) {
        try {
            return super.has(name) || additionalValues.containsKey(name) || Class.forName(name) != null;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    public Object get(String name) {
        try {
            Class<?> value = super.get(name);
            if (value == null && !super.has(name) && (value = additionalValues.get(name)) == null) {
                value = Class.forName(name);
            }
            return value;
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    static {
        additionalValues.put("answerToLifeTheUniverseAndEverything", 42);
        additionalValues.put("JETT", Arrays.asList("Java Excel Template Translator", "Joan Jett", "Jett Travolta", "Bennie and the Jetts", "Jett Blue", "New York Jetts", "Winnipeg Jetts", "The Jettsons", "Jett Engine", "Jettpack", "Jett Li", "Lady Suffrajett", "Jett Propulsion Laboratory", "Jett Stream", "Jett Ski", "Jett Lag", "Jett Fuel", "Jett Airliner"));
    }
}

