package net.serenitybdd.jbehave;

import org.apache.commons.io.IOUtils;
import org.jbehave.core.io.InvalidStoryResource;
import org.jbehave.core.io.LoadFromClasspath;

import java.io.IOException;
import java.io.InputStream;

public class UTF8StoryLoader extends LoadFromClasspath {

	public String loadResourceAsText(String resourcePath) {
        InputStream stream = resourceAsStream(resourcePath);
		try {
			return IOUtils.toString(stream, "UTF-8");
		} catch (IOException e) {
			throw new InvalidStoryResource(resourcePath, stream, e);
		}
	}
}
