/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.var;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.paoding.rose.util.PlaceHolderUtils;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.var.Model;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.Conventions;
import org.springframework.util.Assert;

public class ModelImpl
implements Model {
    private static Log logger = LogFactory.getLog(ModelImpl.class);
    private Map<String, Object> map = new HashMap<String, Object>();
    private Invocation invocation;
    final Object mutex;

    public ModelImpl(Invocation inv) {
        this.invocation = inv;
        this.mutex = this.map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Object> getAttributes() {
        HashMap<String, Object> cloneAndFiltered = new HashMap<String, Object>(this.map.size() * 2);
        Object object = this.mutex;
        synchronized (object) {
            for (Map.Entry<String, Object> entry : this.map.entrySet()) {
                String key = entry.getKey();
                if (key == null || key.startsWith("$$paoding-rose")) continue;
                cloneAndFiltered.put(key, entry.getValue());
            }
        }
        return Collections.unmodifiableMap(cloneAndFiltered);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model add(String name, Object value) {
        Assert.notNull((Object)name, (String)"Model attribute name must not be null");
        if (value instanceof String) {
            value = PlaceHolderUtils.resolve((String)value, this.invocation);
        }
        Object object = this.mutex;
        synchronized (object) {
            this.map.put(name, value);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("add attribute to model: " + name + "=" + value));
        }
        return this;
    }

    @Override
    public Model add(Object value) {
        if (value != null) {
            Collection collection;
            if (value instanceof Collection && (collection = (Collection)value).size() == 0) {
                return this;
            }
            return this.add(Conventions.getVariableName((Object)value), value);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(String name) {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.containsKey(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object get(String name) {
        Object object = this.mutex;
        synchronized (object) {
            return this.map.get(name);
        }
    }

    @Override
    public Model merge(Map<String, Object> attributes) {
        if (attributes != null) {
            for (Map.Entry<String, Object> entry : attributes.entrySet()) {
                String key = entry.getKey();
                if (this.contains(key)) continue;
                this.add(key, entry.getValue());
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model remove(String name) {
        if (name == null) {
            return this;
        }
        Object object = this.mutex;
        synchronized (object) {
            this.map.remove(name);
        }
        return this;
    }

    public Invocation getInvocation() {
        return this.invocation;
    }
}

