/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.var;

import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.util.Base64;
import net.paoding.rose.util.PlaceHolderUtils;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.var.Flash;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class FlashImpl
implements Flash {
    private static final String DELIM = "___";
    private static final String cookiePrefix = "___flashMessage___";
    private static Log logger = LogFactory.getLog(FlashImpl.class);
    private Map<String, String> last = Collections.emptyMap();
    private boolean lastRead = false;
    private Map<String, String> next = Collections.emptyMap();
    private static final Base64 base64 = new Base64();
    private Invocation invocation;

    public FlashImpl(Invocation invocation) {
        this.invocation = invocation;
    }

    protected synchronized void readLastMessages() {
        if (this.lastRead) {
            return;
        }
        this.lastRead = true;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"readLastMessages");
        }
        Cookie[] cookies = this.invocation.getRequest().getCookies();
        for (int i = 0; cookies != null && i < cookies.length; ++i) {
            String flashMessage;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("cookie " + cookies[i].getName() + "=" + cookies[i].getValue() + "; age=" + cookies[i].getMaxAge()));
            }
            if (cookies[i].getValue() == null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("ignore cookie: " + cookies[i].getName()));
                continue;
            }
            if (!cookies[i].getName().startsWith(cookiePrefix)) continue;
            StringTokenizer st = new StringTokenizer(cookies[i].getName(), DELIM);
            String[] splits = new String[st.countTokens()];
            for (int j = 0; j < splits.length; ++j) {
                splits[j] = st.nextToken();
            }
            if (splits.length < 2) {
                if (!logger.isInfoEnabled()) continue;
                logger.info((Object)("ignore flash cookie: " + cookies[i].getName()));
                continue;
            }
            String name = splits[1];
            String cookieValue = cookies[i].getValue();
            if (cookieValue.length() == 0) {
                flashMessage = "";
            } else {
                try {
                    flashMessage = new String(base64.decodeFromString(cookieValue), "UTF-8");
                }
                catch (Exception e) {
                    logger.error((Object)("failed to decode '" + cookieValue + "' as" + " a base64 string"), (Throwable)e);
                    flashMessage = cookieValue;
                }
            }
            if (this.last.size() == 0) {
                this.last = new LinkedHashMap<String, String>();
            }
            this.last.put(name, flashMessage);
            Cookie cookie = new Cookie(cookies[i].getName(), "");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            this.invocation.getResponse().addCookie(cookie);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("found flash message:" + name + "=" + flashMessage));
        }
    }

    public void writeNewMessages() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"writeNextMessages");
        }
        HttpServletResponse response = this.invocation.getResponse();
        ArrayList<String> responseCookies = null;
        for (Map.Entry<String, String> entry : this.next.entrySet()) {
            String cookieValue;
            if (responseCookies == null) {
                responseCookies = new ArrayList<String>(this.next.size());
            }
            if (entry.getValue() == null) {
                cookieValue = "";
            } else {
                try {
                    cookieValue = base64.encodeToString(entry.getValue().getBytes("UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new Error(e);
                }
            }
            Cookie cookie = new Cookie(cookiePrefix + entry.getKey(), cookieValue);
            cookie.setPath("/");
            response.addCookie(cookie);
            responseCookies.add(cookie.getName());
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("write flash cookie:" + cookie.getName() + "=" + cookie.getValue()));
        }
        for (Map.Entry<String, String> entry : this.last.entrySet()) {
            if (responseCookies != null && responseCookies.contains(entry.getKey())) continue;
            Cookie c = new Cookie(entry.getKey(), null);
            c.setMaxAge(0);
            c.setPath("/");
            response.addCookie(c);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("delete flash cookie:" + c.getName() + "=" + c.getValue()));
        }
    }

    @Override
    public boolean contains(String name) {
        this.readLastMessages();
        return this.last.containsKey(name);
    }

    @Override
    public String get(String name) {
        this.readLastMessages();
        return this.last.get(name);
    }

    @Override
    public Collection<String> getMessageNames() {
        this.readLastMessages();
        return this.last.keySet();
    }

    @Override
    public Map<String, String> getMessages() {
        return Collections.unmodifiableMap(this.last);
    }

    @Override
    public Flash add(String name, String flashMessage) {
        Assert.notNull((Object)name, (String)"Flash attribute name must not be null");
        flashMessage = PlaceHolderUtils.resolve(flashMessage, this.invocation);
        if (this.next.size() == 0) {
            this.next = new LinkedHashMap<String, String>(2);
        }
        this.next.put(name, flashMessage);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("add flashMessage: " + name + "=" + flashMessage));
        }
        return this;
    }

    @Override
    public Collection<String> getNewMessageNames() {
        return this.next.keySet();
    }

    @Override
    public Map<String, String> getNewMessages() {
        return Collections.unmodifiableMap(this.next);
    }
}

