/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.paramresolver;

import java.beans.PropertyEditor;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Map;
import javax.servlet.ServletRequest;
import net.paoding.rose.web.paramresolver.ResolverFactoryImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.PropertyValues;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.web.bind.ServletRequestBindingException;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.util.WebUtils;

public class ServletRequestDataBinder
extends WebDataBinder {
    private String prefix;

    public ServletRequestDataBinder(Object target) {
        super(target);
    }

    public ServletRequestDataBinder(Object target, String objectName) {
        super(target, objectName);
        this.prefix = objectName + '.';
    }

    protected AbstractPropertyBindingResult getInternalBindingResult() {
        AbstractPropertyBindingResult bindingResult = super.getInternalBindingResult();
        PropertyEditorRegistry registry = bindingResult.getPropertyEditorRegistry();
        registry.registerCustomEditor(Date.class, (PropertyEditor)new ResolverFactoryImpl.DateEditor(Date.class));
        registry.registerCustomEditor(java.sql.Date.class, (PropertyEditor)new ResolverFactoryImpl.DateEditor(java.sql.Date.class));
        registry.registerCustomEditor(Time.class, (PropertyEditor)new ResolverFactoryImpl.DateEditor(Time.class));
        registry.registerCustomEditor(Timestamp.class, (PropertyEditor)new ResolverFactoryImpl.DateEditor(Timestamp.class));
        return bindingResult;
    }

    public void bind(ServletRequest request) {
        MutablePropertyValues mpvs = new MutablePropertyValues(WebUtils.getParametersStartingWith((ServletRequest)request, (String)this.prefix));
        MultipartRequest multipartRequest = (MultipartRequest)WebUtils.getNativeRequest((ServletRequest)request, MultipartRequest.class);
        if (multipartRequest != null) {
            this.bindMultipart((Map)multipartRequest.getMultiFileMap(), mpvs);
        }
        this.addBindValues(mpvs, request);
        this.doBind(mpvs);
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
    }

    protected void doBind(MutablePropertyValues mpvs) {
        PropertyValue[] pvArray = mpvs.getPropertyValues();
        MutablePropertyValues newMpvs = null;
        for (int i = 0; i < pvArray.length; ++i) {
            PropertyValue pv = pvArray[i];
            String propertyName = pv.getName();
            int dot = propertyName.indexOf(46);
            while (dot != -1) {
                String field = propertyName.substring(0, dot);
                if (this.getPropertyAccessor().isWritableProperty(field) && !mpvs.contains(field)) {
                    Class fieldType = this.getPropertyAccessor().getPropertyType(field);
                    if (newMpvs == null) {
                        newMpvs = new MutablePropertyValues();
                    }
                    newMpvs.addPropertyValue(field, BeanUtils.instantiateClass((Class)fieldType));
                }
                dot = propertyName.indexOf(46, dot + 1);
            }
        }
        if (newMpvs == null) {
            super.doBind(mpvs);
        } else {
            newMpvs.addPropertyValues((PropertyValues)mpvs);
            super.doBind(newMpvs);
        }
    }

    public void closeNoCatch() throws ServletRequestBindingException {
        if (this.getBindingResult().hasErrors()) {
            throw new ServletRequestBindingException("Errors binding onto object '" + this.getBindingResult().getObjectName() + "'", (Throwable)new BindException(this.getBindingResult()));
        }
    }
}

