/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.paramresolver;

import java.beans.PropertyEditorSupport;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import net.paoding.rose.util.RoseBeanUtils;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.annotation.Create;
import net.paoding.rose.web.annotation.DefValue;
import net.paoding.rose.web.annotation.FlashParam;
import net.paoding.rose.web.annotation.Param;
import net.paoding.rose.web.annotation.Pattern;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.thread.InvocationBean;
import net.paoding.rose.web.impl.thread.Rose;
import net.paoding.rose.web.paramresolver.MethodParameterResolver;
import net.paoding.rose.web.paramresolver.ParamMetaData;
import net.paoding.rose.web.paramresolver.ParamResolver;
import net.paoding.rose.web.paramresolver.ResolverFactory;
import net.paoding.rose.web.paramresolver.SafedTypeConverterFactory;
import net.paoding.rose.web.paramresolver.ServletRequestDataBinder;
import net.paoding.rose.web.var.Flash;
import net.paoding.rose.web.var.Model;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.util.WebUtils;

public class ResolverFactoryImpl
implements ResolverFactory {
    private static Log logger = LogFactory.getLog(MethodParameterResolver.class);
    public static final String MAP_SEPARATOR = ":";
    private static final Map<Class<?>, Class<?>> primitiveWrapperTypeMap = new HashMap(8);
    private static final Map<Class<?>, Class<?>> arrayTypeMap;
    private static final ParamResolver[] buildinResolvers;
    private final List<ParamResolver> customerResolvers = new ArrayList<ParamResolver>();

    public void addCustomerResolver(ParamResolver resolver) {
        this.customerResolvers.add(new IndexAliasResolver(resolver));
    }

    @Override
    public ParamResolver supports(ParamMetaData metaData) {
        for (ParamResolver resolver : this.customerResolvers) {
            if (!resolver.supports(metaData)) continue;
            return resolver;
        }
        for (ParamResolver resolver : buildinResolvers) {
            if (!resolver.supports(metaData)) continue;
            return resolver;
        }
        return null;
    }

    private static Object resolveArray(Invocation inv, ParamMetaData metaData, Class<?> compnentType) {
        if (compnentType == MultipartFile.class) {
            String filterName = metaData.getParamName();
            if (filterName == null) {
                filterName = "";
            }
            if (inv.getRequest() instanceof MultipartRequest) {
                LinkedList<MultipartFile> files = new LinkedList<MultipartFile>();
                MultipartRequest multipartRequest = (MultipartRequest)inv.getRequest();
                Iterator names = multipartRequest.getFileNames();
                while (names.hasNext()) {
                    String name = (String)names.next();
                    if (!name.startsWith(filterName)) continue;
                    files.add(multipartRequest.getFile(name));
                }
                return files.toArray(new MultipartFile[0]);
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"cann't set MultipartFile param to method , the request is not a MultipartRequest");
            }
        } else {
            String[] toConvert = null;
            for (String paramName : metaData.getParamNames()) {
                if (paramName != null && (toConvert = inv.getRequest().getParameterValues(paramName)) != null) break;
            }
            if (toConvert != null) {
                Class<?> arrayType;
                if (((String[])toConvert).length == 1) {
                    toConvert = ((String[])toConvert)[0].split(",");
                }
                if (metaData.getParamType().isArray()) {
                    arrayType = metaData.getParamType();
                } else {
                    arrayType = arrayTypeMap.get(compnentType);
                    if (arrayType == null) {
                        arrayType = Array.newInstance(compnentType, 0).getClass();
                    }
                }
                SimpleTypeConverter typeConverter = SafedTypeConverterFactory.getCurrentConverter();
                Object array = typeConverter.convertIfNecessary((Object)toConvert, arrayType);
                return array;
            }
        }
        return Array.newInstance(compnentType, 0);
    }

    private static Class<?>[] compileGenericParameterTypesDetail(Method method, int index) {
        Type genericParameterType = method.getGenericParameterTypes()[index];
        ArrayList<Class<String>> typeDetailList = new ArrayList<Class<String>>();
        if (genericParameterType instanceof ParameterizedType) {
            Type[] parameterArgTypes;
            ParameterizedType aType = (ParameterizedType)genericParameterType;
            for (Type parameterArgType : parameterArgTypes = aType.getActualTypeArguments()) {
                if (parameterArgType instanceof Class) {
                    typeDetailList.add((Class)parameterArgType);
                    continue;
                }
                typeDetailList.add(String.class);
            }
            Class[] types = new Class[typeDetailList.size()];
            typeDetailList.toArray(types);
            return types;
        }
        return null;
    }

    private static boolean addIndexAliasParamNameIfNeccessary(ParamMetaData metaData) {
        int breakIndex;
        Class<?>[] paramTypes = metaData.getMethod().getParameterTypes();
        int index = metaData.getIndex();
        int uriParamIndex = 0;
        for (breakIndex = 0; breakIndex < paramTypes.length && breakIndex <= index; ++breakIndex) {
            Class<?> type = paramTypes[breakIndex];
            if (type.isArray()) {
                type = type.getComponentType();
            } else if (Collection.class.isAssignableFrom(type)) {
                Class<?>[] generics = ResolverFactoryImpl.compileGenericParameterTypesDetail(metaData.getMethod(), breakIndex);
                if (generics == null) {
                    return false;
                }
                Assert.isTrue((generics.length > 0 ? 1 : 0) != 0);
                type = generics[0];
            }
            if (!ClassUtils.isPrimitiveOrWrapper(type) && type != String.class && !Date.class.isAssignableFrom(type)) continue;
            ++uriParamIndex;
        }
        if (breakIndex - 1 == index && uriParamIndex > 0) {
            String alias = "$" + uriParamIndex;
            metaData.addAliasParamName(alias);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("add index alias paramName: '" + alias + "' for " + metaData.getControllerClass().getName() + "." + metaData.getMethod().getName() + "(..." + metaData.getParamType() + "[index=" + breakIndex + "] ...)"));
            }
            return true;
        }
        return false;
    }

    static {
        primitiveWrapperTypeMap.put(Boolean.TYPE, Boolean.class);
        primitiveWrapperTypeMap.put(Byte.TYPE, Byte.class);
        primitiveWrapperTypeMap.put(Character.TYPE, Character.class);
        primitiveWrapperTypeMap.put(Double.TYPE, Double.class);
        primitiveWrapperTypeMap.put(Float.TYPE, Float.class);
        primitiveWrapperTypeMap.put(Integer.TYPE, Integer.class);
        primitiveWrapperTypeMap.put(Long.TYPE, Long.class);
        primitiveWrapperTypeMap.put(Short.TYPE, Short.class);
        arrayTypeMap = new HashMap();
        arrayTypeMap.put(Boolean.TYPE, Boolean.class);
        arrayTypeMap.put(Byte.TYPE, byte[].class);
        arrayTypeMap.put(Character.TYPE, char[].class);
        arrayTypeMap.put(Double.TYPE, double[].class);
        arrayTypeMap.put(Float.TYPE, float[].class);
        arrayTypeMap.put(Integer.TYPE, int[].class);
        arrayTypeMap.put(Long.TYPE, long[].class);
        arrayTypeMap.put(Short.TYPE, short[].class);
        arrayTypeMap.put(Boolean.class, Boolean[].class);
        arrayTypeMap.put(Byte.class, Byte[].class);
        arrayTypeMap.put(Character.class, Character[].class);
        arrayTypeMap.put(Double.class, Double[].class);
        arrayTypeMap.put(Float.class, Float[].class);
        arrayTypeMap.put(Integer.class, Integer[].class);
        arrayTypeMap.put(Long.class, Long[].class);
        arrayTypeMap.put(Short.class, Short[].class);
        buildinResolvers = new ParamResolver[]{new InvocationResolver(), new RoseResolver(), new ApplicationContextResolver(), new MessageSourceResolver(), new ModelResolver(), new FlashResolver(), new ModuleResolver(), new IndexAliasResolver(new StringResolver()), new RequestResolver(), new ResponseResolver(), new HttpSessionResolver(), new MultipartFileResolver(), new MultipartRequestResolver(), new MultipartHttpServletRequestResolver(), new ServletContextResolver(), new IndexAliasResolver(new ArrayResolver()), new IndexAliasResolver(new ListResolver()), new IndexAliasResolver(new SetResolver()), new IndexAliasResolver(new MapResolver()), new BindingResultResolver(), new IndexAliasResolver(new DateResolver()), new IndexAliasResolver(new EditorResolver()), new IndexAliasResolver(new EnumResolver()), new BeanResolver(), new IndexAliasResolver(new MultipartResolverResolver())};
    }

    static final class EditorResolver
    implements ParamResolver {
        EditorResolver() {
        }

        @Override
        public boolean supports(ParamMetaData metaData) {
            if (ClassUtils.isPrimitiveOrWrapper(metaData.getParamType())) {
                return true;
            }
            SimpleTypeConverter simpleTypeConverter = SafedTypeConverterFactory.getCurrentConverter();
            return simpleTypeConverter.findCustomEditor(metaData.getParamType(), null) != null || simpleTypeConverter.getDefaultEditor(metaData.getParamType()) != null;
        }

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) {
            SimpleTypeConverter typeConverter;
            DefValue defValudeAnnotation;
            String toConvert = null;
            FlashParam flashParam = metaData.getAnnotation(FlashParam.class);
            if (flashParam != null) {
                toConvert = inv.getFlash().get(flashParam.value());
            }
            for (String paramName : metaData.getParamNames()) {
                if (paramName != null && (toConvert = inv.getRequest().getParameter(paramName)) != null) break;
            }
            if (toConvert == null && (defValudeAnnotation = metaData.getAnnotation(DefValue.class)) != null && !"$$paoding-rose.param.nativeDefualt".equals(defValudeAnnotation.value())) {
                toConvert = defValudeAnnotation.value();
            }
            if (toConvert != null) {
                typeConverter = SafedTypeConverterFactory.getCurrentConverter();
                return typeConverter.convertIfNecessary((Object)toConvert, metaData.getParamType());
            }
            if (metaData.getParamType().isPrimitive()) {
                if (metaData.getParamType() == Integer.TYPE) {
                    return 0;
                }
                if (metaData.getParamType() == Long.TYPE) {
                    return 0L;
                }
                if (metaData.getParamType() == Boolean.TYPE) {
                    return Boolean.FALSE;
                }
                if (metaData.getParamType() == Double.TYPE) {
                    return 0.0;
                }
                if (metaData.getParamType() == Float.TYPE) {
                    return Float.valueOf(0.0f);
                }
                typeConverter = SafedTypeConverterFactory.getCurrentConverter();
                return typeConverter.convertIfNecessary((Object)"0", metaData.getParamType());
            }
            return null;
        }
    }

    static final class DateResolver
    implements ParamResolver {
        DateResolver() {
        }

        @Override
        public boolean supports(ParamMetaData metaData) {
            return Date.class == metaData.getParamType() || java.sql.Date.class == metaData.getParamType() || Time.class == metaData.getParamType() || Timestamp.class == metaData.getParamType();
        }

        @Override
        public Date resolve(Invocation inv, ParamMetaData metaData) throws Exception {
            String text = null;
            for (String paramName : metaData.getParamNames()) {
                if (paramName != null && (text = inv.getParameter(paramName)) != null && (text = text.trim()).length() > 0) break;
            }
            Date date = this.resolveUtilDate(text, metaData);
            return DatePatterns.changeType(date, metaData.getParamType());
        }

        protected Date resolveUtilDate(String text, ParamMetaData metaData) throws ParseException {
            Annotation[] paramAnnotations;
            if (StringUtils.isEmpty((String)text)) {
                DefValue defaultValudeAnnotation = metaData.getAnnotation(DefValue.class);
                if (defaultValudeAnnotation != null && !"$$paoding-rose.param.nativeDefualt".equals(defaultValudeAnnotation.value())) {
                    if (StringUtils.isEmpty((String)defaultValudeAnnotation.value())) {
                        return new Date();
                    }
                    text = defaultValudeAnnotation.value();
                } else {
                    return null;
                }
            }
            for (Annotation annotation : paramAnnotations = metaData.getMethod().getParameterAnnotations()[metaData.getIndex()]) {
                String[] patterns;
                if (!(annotation instanceof Pattern)) continue;
                for (String pattern : patterns = ((Pattern)Pattern.class.cast(annotation)).value()) {
                    if ("long".equals(pattern)) {
                        boolean digit = true;
                        for (int i = 0; i < text.length(); ++i) {
                            if (Character.isDigit(text.charAt(i))) continue;
                            digit = false;
                            break;
                        }
                        if (digit) {
                            return new Date(Long.parseLong(text));
                        }
                    }
                    if (text.length() != pattern.length()) continue;
                    return new SimpleDateFormat(pattern).parse(text);
                }
                break;
            }
            return DatePatterns.parse(text);
        }
    }

    static final class DatePatterns {
        private static final String dateTimePattern = "yyyy-MM-dd HH:mm:ss";
        private static final String dateTimePattern2 = "yyyy/MM/dd HH:mm:ss";
        private static final String dateTimePattern3 = "yyyyMMddHHmmss";
        private static final String datePattern = "yyyy-MM-dd";
        private static final String datePattern2 = "yyyy/MM/dd";
        private static final String datePattern3 = "yyyy-MM";
        private static final String timePattern = "HH:mm:ss";
        private static final String stimePattern = "HH:mm";

        DatePatterns() {
        }

        private static Date parse(String text) throws ParseException {
            if (text.length() == dateTimePattern.length()) {
                if (text.charAt(4) == '-' && text.charAt(7) == '-') {
                    return new SimpleDateFormat(dateTimePattern).parse(text);
                }
                if (text.charAt(4) == '/' && text.charAt(7) == '/' && text.charAt(13) == ':' && text.charAt(16) == ':') {
                    return new SimpleDateFormat(dateTimePattern2).parse(text);
                }
            } else {
                if (text.length() == dateTimePattern3.length()) {
                    return new SimpleDateFormat(dateTimePattern3).parse(text);
                }
                if (text.length() == datePattern3.length()) {
                    return new SimpleDateFormat(datePattern3).parse(text);
                }
                if (text.length() == datePattern.length()) {
                    if (text.charAt(4) == '-' && text.charAt(7) == '-') {
                        return new SimpleDateFormat(datePattern).parse(text);
                    }
                    if (text.charAt(4) == '/' && text.charAt(7) == '/') {
                        return new SimpleDateFormat(datePattern2).parse(text);
                    }
                } else if (text.length() == timePattern.length()) {
                    if (text.charAt(2) == ':' && text.charAt(5) == ':') {
                        return new SimpleDateFormat(timePattern).parse(text);
                    }
                } else if (text.length() == stimePattern.length() && text.charAt(2) == ':') {
                    return new SimpleDateFormat(stimePattern).parse(text);
                }
            }
            return new Date(Long.parseLong(text));
        }

        private static Date changeType(Date date, Class<?> targetType) {
            if (date == null) {
                return date;
            }
            if (java.sql.Date.class == targetType) {
                date = new java.sql.Date(date.getTime());
            } else if (Time.class == targetType) {
                date = new Time(date.getTime());
            } else if (Timestamp.class == targetType) {
                date = new Timestamp(date.getTime());
            }
            return date;
        }
    }

    static class DateEditor
    extends PropertyEditorSupport {
        private Class<?> targetType;

        public DateEditor(Class<?> targetType) {
            this.targetType = targetType;
        }

        @Override
        public void setAsText(String text) throws IllegalArgumentException {
            if (text == null || (text = text.trim()).length() == 0) {
                return;
            }
            try {
                this.setValue(DatePatterns.changeType(DatePatterns.parse(text), this.targetType));
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }
    }

    static final class MapResolver
    implements ParamResolver {
        MapResolver() {
        }

        @Override
        public boolean supports(ParamMetaData metaData) {
            boolean supports;
            boolean bl = supports = Map.class == metaData.getParamType() || HashMap.class == metaData.getParamType();
            if (supports) {
                Class[] generics = ResolverFactoryImpl.compileGenericParameterTypesDetail(metaData.getMethod(), metaData.getIndex());
                if (generics == null || generics.length == 0) {
                    throw new IllegalArgumentException("please use generic for " + metaData.getParamType().getName() + " [" + metaData.getControllerClass().getName() + "." + metaData.getMethod().getName() + "]");
                }
                metaData.setUserObject(this, generics);
            }
            return supports;
        }

        @Override
        public Map<?, ?> resolve(Invocation inv, ParamMetaData metaData) {
            if (StringUtils.isNotEmpty((String)metaData.getParamName())) {
                Class[] genericTypes = (Class[])metaData.getUserObject(this);
                Class keyType = genericTypes[0];
                Class valueType = genericTypes[1];
                Map toConvert = WebUtils.getParametersStartingWith((ServletRequest)inv.getRequest(), (String)(metaData.getParamName() + ResolverFactoryImpl.MAP_SEPARATOR));
                if (toConvert != null) {
                    if (keyType != String.class || valueType != String.class) {
                        HashMap ret = new HashMap();
                        for (Map.Entry entry : toConvert.entrySet()) {
                            Object key = entry.getKey();
                            Object value = entry.getValue();
                            SimpleTypeConverter typeConverter = SafedTypeConverterFactory.getCurrentConverter();
                            if (keyType != String.class) {
                                key = typeConverter.convertIfNecessary(key, keyType);
                            }
                            if (valueType != String.class) {
                                value = typeConverter.convertIfNecessary(value, valueType);
                            }
                            ret.put(key, value);
                        }
                        return ret;
                    }
                    return toConvert;
                }
            }
            return new HashMap(2);
        }
    }

    static final class SetResolver
    extends CollectionResolver<Set<?>> {
        SetResolver() {
        }

        @Override
        public boolean innerSupports(ParamMetaData metaData) {
            return Set.class == metaData.getParamType() || !Modifier.isAbstract(metaData.getParamType().getModifiers()) && Set.class.isAssignableFrom(metaData.getParamType());
        }

        @Override
        protected Collection create(ParamMetaData metaData, int len) throws Exception {
            if (metaData.getParamType().isInterface()) {
                return new HashSet(len);
            }
            return (Collection)metaData.getParamType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    static final class ListResolver
    extends CollectionResolver<List<?>> {
        ListResolver() {
        }

        @Override
        public boolean innerSupports(ParamMetaData metaData) {
            return List.class == metaData.getParamType() || Collection.class == metaData.getParamType() || !Modifier.isAbstract(metaData.getParamType().getModifiers()) && List.class.isAssignableFrom(metaData.getParamType());
        }

        @Override
        protected Collection create(ParamMetaData metaData, int len) throws Exception {
            if (metaData.getParamType().isInterface()) {
                return new ArrayList(len);
            }
            return (Collection)metaData.getParamType().getConstructor(new Class[0]).newInstance(new Object[0]);
        }
    }

    static abstract class CollectionResolver<T extends Collection<?>>
    implements ParamResolver {
        CollectionResolver() {
        }

        @Override
        public final boolean supports(ParamMetaData metaData) {
            if (this.innerSupports(metaData)) {
                Class[] generics = ResolverFactoryImpl.compileGenericParameterTypesDetail(metaData.getMethod(), metaData.getIndex());
                if (generics == null || generics.length == 0) {
                    throw new IllegalArgumentException("please use generic for " + metaData.getParamType().getName() + " [" + metaData.getControllerClass().getName() + "." + metaData.getMethod().getName() + "]");
                }
                metaData.setUserObject(this, generics[0]);
                return true;
            }
            return false;
        }

        public abstract boolean innerSupports(ParamMetaData var1);

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) throws Exception {
            Object array = ResolverFactoryImpl.resolveArray(inv, metaData, (Class)metaData.getUserObject(this));
            int len = ArrayUtils.getLength((Object)array);
            Collection<?> collection = this.create(metaData, len);
            for (int i = 0; i < len; ++i) {
                collection.add(Array.get(array, i));
            }
            return collection;
        }

        protected abstract Collection<?> create(ParamMetaData var1, int var2) throws Exception;
    }

    static final class ArrayResolver
    implements ParamResolver {
        ArrayResolver() {
        }

        @Override
        public boolean supports(ParamMetaData metaData) {
            return metaData.getParamType().isArray();
        }

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) {
            return ResolverFactoryImpl.resolveArray(inv, metaData, metaData.getParamType().getComponentType());
        }
    }

    public static final class BindingResultResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return BindingResult.class == metaData.getParamType() || Errors.class == metaData.getParamType();
        }

        public BindingResult resolve(Invocation inv, ParamMetaData metaData) {
            if (metaData.getParamName() != null) {
                return inv.getBindingResult(metaData.getParamName());
            }
            return inv.getParameterBindingResult();
        }
    }

    public static final class BeanResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return !Modifier.isAbstract(metaData.getParamType().getModifiers());
        }

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) {
            Object bean = RoseBeanUtils.instantiateClass(metaData.getParamType());
            ServletRequestDataBinder binder = !metaData.isAnnotationPresent(Param.class) ? new ServletRequestDataBinder(bean) : new ServletRequestDataBinder(bean, metaData.getParamName());
            binder.bind((ServletRequest)inv.getRequest());
            String bindingResultName = BindingResult.MODEL_KEY_PREFIX + metaData.getParamName() + "BindingResult";
            inv.addModel(bindingResultName, binder.getBindingResult());
            return bean;
        }
    }

    public static final class EnumResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return metaData.getParamType().isEnum();
        }

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) {
            for (String paramName : metaData.getParamNames()) {
                String value;
                if (paramName == null || (value = inv.getParameter(paramName)) == null) continue;
                return Enum.valueOf(metaData.getParamType(), value);
            }
            return null;
        }
    }

    public static final class RoseResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            boolean result;
            boolean bl = result = metaData.getParamType() == Rose.class;
            if (result && !metaData.getControllerClass().getName().startsWith("net.paoding.rose")) {
                throw new IllegalStateException("Rose is not allowed as a method parameter:" + metaData);
            }
            return result;
        }

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) throws Exception {
            return ((InvocationBean)inv).getRose();
        }
    }

    public static final class MultipartFileResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return MultipartFile.class == metaData.getParamType();
        }

        public MultipartFile resolve(Invocation inv, ParamMetaData metaData) {
            MultipartFile multipartFile = null;
            if (inv.getRequest() instanceof MultipartRequest) {
                Iterator allFileNames;
                MultipartRequest multipartRequest = (MultipartRequest)inv.getRequest();
                String fileName = metaData.getParamName();
                if (StringUtils.isBlank((String)fileName) && (allFileNames = multipartRequest.getFileNames()).hasNext()) {
                    fileName = (String)allFileNames.next();
                }
                if (StringUtils.isNotBlank((String)fileName)) {
                    multipartFile = multipartRequest.getFile(fileName);
                }
                if (multipartFile == null) {
                    if (StringUtils.isNotBlank((String)fileName)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)("not found multipartFile named " + fileName + " in this request: " + inv.getRequestPath().getUri()));
                        }
                    } else if (logger.isDebugEnabled()) {
                        logger.debug((Object)("not found MultipartFile named:" + metaData.getParamName() + " in this request: " + inv.getRequestPath().getUri()));
                    }
                }
            } else if (logger.isDebugEnabled()) {
                logger.debug((Object)"cann't set MultipartFile param to method , the request is not a MultipartRequest");
            }
            return multipartFile;
        }
    }

    public static final class MultipartResolverResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return MultipartResolver.class == metaData.getParamType();
        }

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) throws Exception {
            return ((InvocationBean)inv).getModuleEngine().getMultipartResolver();
        }
    }

    public static final class MultipartHttpServletRequestResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return MultipartHttpServletRequest.class == metaData.getParamType();
        }

        public MultipartRequest resolve(Invocation inv, ParamMetaData metaData) {
            if (inv.getRequest() instanceof MultipartHttpServletRequest) {
                return (MultipartHttpServletRequest)inv.getRequest();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"cann't set MultipartRequest param to method , the request is not a MultipartRequest");
            }
            return null;
        }
    }

    public static final class MultipartRequestResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return MultipartRequest.class == metaData.getParamType() || MultipartHttpServletRequest.class == metaData.getParamType();
        }

        public MultipartRequest resolve(Invocation inv, ParamMetaData metaData) {
            if (inv.getRequest() instanceof MultipartRequest) {
                return (MultipartRequest)inv.getRequest();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"cann't set MultipartRequest param to method , the request is not a MultipartRequest");
            }
            return null;
        }
    }

    public static final class StringResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return String.class == metaData.getParamType();
        }

        @Override
        public String resolve(Invocation inv, ParamMetaData metaData) {
            for (String paramName : metaData.getParamNames()) {
                String value;
                if (paramName == null || (value = inv.getParameter(paramName)) == null) continue;
                return value;
            }
            return null;
        }
    }

    public static final class ModuleResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return Module.class == metaData.getParamType();
        }

        @Override
        public Module resolve(Invocation inv, ParamMetaData metaData) {
            return ((InvocationBean)inv).getModule();
        }
    }

    public static final class FlashResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return Flash.class == metaData.getParamType();
        }

        @Override
        public Flash resolve(Invocation inv, ParamMetaData metaData) {
            return inv.getFlash();
        }
    }

    public static final class ModelResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return Model.class == metaData.getParamType();
        }

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) {
            return inv.getModel();
        }
    }

    public static final class HttpSessionResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return HttpSession.class == metaData.getParamType();
        }

        public HttpSession resolve(Invocation inv, ParamMetaData metaData) {
            boolean create = true;
            Create createAnnotation = metaData.getAnnotation(Create.class);
            if (createAnnotation != null) {
                create = createAnnotation.value();
            }
            return inv.getRequest().getSession(create);
        }
    }

    public static final class ServletContextResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return ServletContext.class == metaData.getParamType();
        }

        public ServletContext resolve(Invocation inv, ParamMetaData metaData) {
            return inv.getServletContext();
        }
    }

    public static final class ResponseResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return HttpServletResponse.class == metaData.getParamType() || ServletResponse.class == metaData.getParamType();
        }

        public ServletResponse resolve(Invocation inv, ParamMetaData metaData) {
            return inv.getResponse();
        }
    }

    public static final class RequestResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return HttpServletRequest.class == metaData.getParamType() || ServletRequest.class == metaData.getParamType();
        }

        public HttpServletRequest resolve(Invocation inv, ParamMetaData metaData) {
            return inv.getRequest();
        }
    }

    public static final class MessageSourceResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return MessageSource.class == metaData.getParamType();
        }

        public MessageSource resolve(Invocation inv, ParamMetaData metaData) {
            return inv.getApplicationContext();
        }
    }

    public static final class ApplicationContextResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return ApplicationContext.class == metaData.getParamType() || WebApplicationContext.class == metaData.getParamType();
        }

        public ApplicationContext resolve(Invocation inv, ParamMetaData metaData) {
            return inv.getApplicationContext();
        }
    }

    public static final class InvocationResolver
    implements ParamResolver {
        @Override
        public boolean supports(ParamMetaData metaData) {
            return Invocation.class == metaData.getParamType();
        }

        @Override
        public Invocation resolve(Invocation inv, ParamMetaData metaData) {
            return inv;
        }
    }

    private static class IndexAliasResolver
    implements ParamResolver {
        ParamResolver inner;

        public IndexAliasResolver(ParamResolver inner) {
            this.inner = inner;
        }

        @Override
        public boolean supports(ParamMetaData metaData) {
            if (this.inner.supports(metaData)) {
                ResolverFactoryImpl.addIndexAliasParamNameIfNeccessary(metaData);
                return true;
            }
            return false;
        }

        @Override
        public Object resolve(Invocation inv, ParamMetaData metaData) throws Exception {
            return this.inner.resolve(inv, metaData);
        }

        public String toString() {
            return this.inner.toString();
        }
    }
}

