/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.paramresolver;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.paoding.rose.web.annotation.FlashParam;
import net.paoding.rose.web.annotation.Param;
import org.apache.commons.lang.StringUtils;
import org.springframework.util.ClassUtils;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.multipart.MultipartFile;

public class ParameterNameDiscovererImpl {
    public String[] getParameterNames(Method method) {
        Class<?>[] parameterTypes = method.getParameterTypes();
        Annotation[][] parameterAnnotations = method.getParameterAnnotations();
        String[] names = new String[parameterTypes.length];
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        for (int i = 0; i < names.length; ++i) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = parameterAnnotations[i]) {
                String name = null;
                if (annotation instanceof Param) {
                    name = ((Param)annotation).value();
                } else if (annotation instanceof FlashParam) {
                    name = ((FlashParam)annotation).value();
                }
                if (name == null) continue;
                if (!StringUtils.isNotEmpty((String)name)) break;
                names[i] = name;
                if (parameterTypes[i] != BindingResult.class && parameterTypes[i] != Errors.class || name.endsWith("BindingResult")) break;
                names[i] = name + "BindingResult";
                break;
            }
            if (names[i] != null) continue;
            if ((parameterTypes[i] == BindingResult.class || parameterTypes[i] == Errors.class) && i > 0 && names[i - 1] != null) {
                names[i] = names[i - 1] + "BindingResult";
                continue;
            }
            String rawName = this.getParameterRawName(parameterTypes[i]);
            if (rawName == null) continue;
            names[i] = rawName;
            Integer count = (Integer)counts.get(rawName);
            if (count == null) {
                counts.put(rawName, 1);
                continue;
            }
            counts.put(rawName, count + 1);
            if (count == 1) {
                for (int j = 0; j < i; ++j) {
                    if (names[j] == null || !names[j].equals(rawName)) continue;
                    names[j] = rawName + "1";
                    break;
                }
            }
            if (names[i] != rawName) continue;
            names[i] = names[i] + (count + 1);
        }
        HashSet<String> uniques = new HashSet<String>();
        for (String name : names) {
            if (name == null) continue;
            if (uniques.contains(name)) {
                throw new IllegalArgumentException("params with same name: '" + name + "'");
            }
            uniques.add(name);
        }
        return names;
    }

    protected String getParameterRawName(Class<?> clz) {
        if (ClassUtils.isPrimitiveOrWrapper(clz) || clz == String.class || Map.class.isAssignableFrom(clz) || Collection.class.isAssignableFrom(clz) || clz.isArray() || clz == MultipartFile.class) {
            return null;
        }
        if (clz == MultipartFile.class) {
            return null;
        }
        return ClassUtils.getShortNameAsProperty(clz);
    }

    public String[] getParameterNames(Constructor ctor) {
        throw new UnsupportedOperationException();
    }
}

