/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.paramresolver;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.paoding.rose.web.paramresolver.ParamMetaData;

class ParamMetaDataImpl
implements ParamMetaData {
    private Class<?> controllerClass;
    private Method method;
    private Class<?> paramType;
    private String[] paramNames = new String[2];
    private Map<Object, Object> userObjectMap;
    private Annotation[] annotations;
    private int index;

    public ParamMetaDataImpl(Class<?> controllerClass, Method method, Class<?> paramType, String paramName, int index) {
        this.controllerClass = controllerClass;
        this.method = method;
        this.setParamName(paramName);
        this.paramType = paramType;
        this.index = index;
        this.annotations = method.getParameterAnnotations()[index];
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        for (Annotation annotation : this.annotations) {
            if (!annotationClass.isInstance(annotation)) continue;
            return (T)((Annotation)annotationClass.cast(annotation));
        }
        return null;
    }

    @Override
    public <T extends Annotation> boolean isAnnotationPresent(Class<T> annotationClass) {
        return this.getAnnotation(annotationClass) != null;
    }

    @Override
    public synchronized void setUserObject(Object key, Object userObject) {
        if (this.userObjectMap == null) {
            this.userObjectMap = new HashMap<Object, Object>();
        }
        if (userObject == null) {
            this.userObjectMap.remove(key);
        } else {
            this.userObjectMap.put(key, userObject);
        }
    }

    @Override
    public synchronized Object getUserObject(Object key) {
        return this.userObjectMap == null ? null : this.userObjectMap.get(key);
    }

    @Override
    public Class<?> getControllerClass() {
        return this.controllerClass;
    }

    public void setControllerClass(Class<?> controllerClass) {
        this.controllerClass = controllerClass;
    }

    @Override
    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    @Override
    public Class<?> getParamType() {
        return this.paramType;
    }

    public void setParamType(Class<?> paramType) {
        this.paramType = paramType;
    }

    @Override
    public String getParamName() {
        return this.paramNames[0];
    }

    @Override
    public void addAliasParamName(String aliasParamName) {
        if (this.paramNames[1] == null) {
            this.paramNames[1] = aliasParamName;
        } else {
            String[] newArray = Arrays.copyOf(this.paramNames, this.paramNames.length + 1);
            newArray[this.paramNames.length] = aliasParamName;
            this.paramNames = newArray;
        }
    }

    @Override
    public String[] getParamNames() {
        return this.paramNames;
    }

    public void setParamName(String paramName) {
        this.paramNames[0] = paramName;
    }

    public String toString() {
        return this.controllerClass.getName() + "#" + this.method.getName() + "@" + this.index;
    }
}

