/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.paramresolver;

import java.lang.reflect.Method;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.annotation.DefValue;
import net.paoding.rose.web.annotation.Param;
import net.paoding.rose.web.impl.validation.ParameterBindingResult;
import net.paoding.rose.web.paramresolver.ParamMetaData;
import net.paoding.rose.web.paramresolver.ParamMetaDataImpl;
import net.paoding.rose.web.paramresolver.ParamResolver;
import net.paoding.rose.web.paramresolver.ParameterNameDiscovererImpl;
import net.paoding.rose.web.paramresolver.ResolverFactory;
import net.paoding.rose.web.paramresolver.SafedTypeConverterFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.SimpleTypeConverter;
import org.springframework.beans.TypeMismatchException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.validation.FieldError;
import org.springframework.validation.ObjectError;

public final class MethodParameterResolver {
    private static Log logger = LogFactory.getLog(MethodParameterResolver.class);
    private final Method method;
    private final String[] parameterNames;
    private final ParamResolver[] resolvers;
    private final ParamMetaData[] paramMetaDatas;

    public MethodParameterResolver(Class<?> controllerClazz, Method method, ParameterNameDiscovererImpl parameterNameDiscoverer, ResolverFactory resolverFactory) {
        this.method = method;
        Class<?>[] parameterTypes = method.getParameterTypes();
        this.parameterNames = parameterNameDiscoverer.getParameterNames(method);
        this.resolvers = new ParamResolver[parameterTypes.length];
        this.paramMetaDatas = new ParamMetaData[parameterTypes.length];
        for (int i = 0; i < parameterTypes.length; ++i) {
            ParamMetaDataImpl paramMetaData = new ParamMetaDataImpl(controllerClazz, method, parameterTypes[i], this.parameterNames[i], i);
            this.paramMetaDatas[i] = paramMetaData;
            this.resolvers[i] = resolverFactory.supports(paramMetaData);
        }
    }

    public ParamMetaData[] getParamMetaDatas() {
        return this.paramMetaDatas;
    }

    public String[] getParameterNames() {
        return this.parameterNames;
    }

    public Method getMethod() {
        return this.method;
    }

    public Param getParamAnnotationAt(int index) {
        return this.paramMetaDatas[index].getAnnotation(Param.class);
    }

    public Object[] resolve(Invocation inv, ParameterBindingResult parameterBindingResult) throws Exception {
        Object[] parameters = new Object[this.paramMetaDatas.length];
        for (int i = 0; i < this.resolvers.length; ++i) {
            if (this.resolvers[i] == null) continue;
            try {
                DefValue defValudeAnnotation;
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Resolves parameter " + this.paramMetaDatas[i].getParamType().getSimpleName() + " using " + this.resolvers[i].getClass().getName()));
                }
                parameters[i] = this.resolvers[i].resolve(inv, this.paramMetaDatas[i]);
                if (parameters[i] instanceof InitializingBean) {
                    ((InitializingBean)parameters[i]).afterPropertiesSet();
                }
                if (parameters[i] != null || (defValudeAnnotation = this.paramMetaDatas[i].getAnnotation(DefValue.class)) == null || this.paramMetaDatas[i].getParamType() != String.class) continue;
                parameters[i] = defValudeAnnotation.value();
                continue;
            }
            catch (TypeMismatchException e) {
                String paramName;
                logger.debug((Object)"", (Throwable)e);
                if (this.paramMetaDatas[i].getParamType().isPrimitive()) {
                    SimpleTypeConverter typeConverter;
                    DefValue defValudeAnnotation = this.paramMetaDatas[i].getAnnotation(DefValue.class);
                    if (defValudeAnnotation == null || "$$paoding-rose.param.nativeDefualt".equals(defValudeAnnotation.value())) {
                        if (this.paramMetaDatas[i].getParamType() == Integer.TYPE) {
                            parameters[i] = 0;
                        } else if (this.paramMetaDatas[i].getParamType() == Long.TYPE) {
                            parameters[i] = 0L;
                        } else if (this.paramMetaDatas[i].getParamType() == Boolean.TYPE) {
                            parameters[i] = Boolean.FALSE;
                        } else if (this.paramMetaDatas[i].getParamType() == Double.TYPE) {
                            parameters[i] = 0.0;
                        } else if (this.paramMetaDatas[i].getParamType() == Float.TYPE) {
                            parameters[i] = Float.valueOf(0.0f);
                        } else {
                            typeConverter = SafedTypeConverterFactory.getCurrentConverter();
                            parameters[i] = typeConverter.convertIfNecessary((Object)"0", this.paramMetaDatas[i].getParamType());
                        }
                    } else {
                        typeConverter = SafedTypeConverterFactory.getCurrentConverter();
                        parameters[i] = typeConverter.convertIfNecessary((Object)defValudeAnnotation.value(), this.paramMetaDatas[i].getParamType());
                    }
                }
                if ((paramName = this.parameterNames[i]) == null) {
                    String name;
                    String[] arr$ = this.paramMetaDatas[i].getParamNames();
                    int len$ = arr$.length;
                    for (int i$ = 0; i$ < len$ && (paramName = (name = arr$[i$])) == null; ++i$) {
                    }
                }
                Assert.isTrue((paramName != null ? 1 : 0) != 0);
                FieldError fieldError = new FieldError("method", paramName, (Object)inv.getParameter(paramName), true, new String[]{e.getErrorCode()}, (Object[])new String[]{inv.getParameter(paramName)}, null);
                parameterBindingResult.addError((ObjectError)fieldError);
                continue;
            }
            catch (Exception e) {
                logger.error((Object)"", (Throwable)e);
                throw e;
            }
        }
        return parameters;
    }
}

