/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.instruction;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.util.SpringUtils;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.impl.thread.InvocationBean;
import net.paoding.rose.web.impl.view.ViewDispatcher;
import net.paoding.rose.web.impl.view.ViewDispatcherImpl;
import net.paoding.rose.web.impl.view.ViewPathCache;
import net.paoding.rose.web.instruction.AbstractInstruction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.servlet.View;

public class ViewInstruction
extends AbstractInstruction {
    protected static Log logger = LogFactory.getLog(ViewInstruction.class);
    public static final String ROSE_INVOCATION = "roseInvocation";
    private static Map<String, ViewPathCache> globalViewPathCaches = new HashMap<String, ViewPathCache>();
    private final String name;
    private String viewDispatcherName = "viewDispatcher";

    public ViewInstruction(String name) {
        this.name = name;
    }

    @Override
    public void doRender(Invocation inv) throws Exception {
        String name = this.resolvePlaceHolder(this.name, inv);
        ViewDispatcher viewResolver = this.getViewDispatcher(inv);
        String viewPath = this.getViewPath((InvocationBean)inv, name);
        if (viewPath != null) {
            HttpServletRequest request = inv.getRequest();
            HttpServletResponse response = inv.getResponse();
            View view = viewResolver.resolveViewName(inv, viewPath, request.getLocale());
            if (!Thread.interrupted()) {
                inv.addModel(ROSE_INVOCATION, inv);
                view.render(inv.getModel().getAttributes(), request, response);
            } else {
                logger.info((Object)"interrupted");
            }
        }
    }

    private String getViewPath(InvocationBean inv, String viewName) throws IOException {
        int queryStringIndex;
        String viewPath;
        String viewRelativePath;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("resolving view name = '" + viewName + "'"));
        }
        if (viewName.charAt(0) == '/' && !viewName.startsWith("/views/")) {
            return viewName;
        }
        if (viewName.startsWith("/views/")) {
            viewRelativePath = "";
            viewName = viewName.substring("/views/".length());
        } else {
            viewRelativePath = inv.getViewModule().getRelativePath();
        }
        ViewPathCache viewPathCache = globalViewPathCaches.get(viewRelativePath);
        if (viewPathCache == null) {
            String directoryPath = "/views" + viewRelativePath;
            File directoryFile = new File(inv.getServletContext().getRealPath(directoryPath));
            if (!directoryFile.exists()) {
                String msg = "404: view directory not found, you need to create it in your webapp:" + directoryPath;
                logger.error((Object)msg);
                inv.getResponse().sendError(404, msg);
                return null;
            }
            viewPathCache = new ViewPathCache(viewRelativePath);
            globalViewPathCaches.put(viewRelativePath, viewPathCache);
        }
        if ((viewPath = (queryStringIndex = viewName.indexOf(63)) < 0 ? this.getViewPathFromCache(inv, viewPathCache, viewName) : this.getViewPathFromCache(inv, viewPathCache, viewName.substring(0, queryStringIndex)) + viewName.substring(queryStringIndex)) != null && logger.isDebugEnabled()) {
            logger.debug((Object)("found '" + viewPath + "' for viewName '" + viewName + "'"));
        }
        return viewPath;
    }

    private String getViewPathFromCache(InvocationBean inv, ViewPathCache viewPathCache, String viewName) throws IOException {
        String viewFileName;
        File directoryFile;
        String directoryPath;
        String notDirectoryViewName;
        int viewNameIndex;
        String viewPath = viewPathCache.getViewPath(viewName);
        if (viewPath != null) {
            return viewPath;
        }
        boolean debugEnabled = logger.isDebugEnabled();
        if (debugEnabled) {
            logger.debug((Object)("to find viewPath by viewName '" + viewName + "'"));
        }
        if ((viewNameIndex = viewName.lastIndexOf(47)) > 0) {
            notDirectoryViewName = viewName.substring(viewNameIndex + 1);
            if (viewName.charAt(0) == '/') {
                directoryPath = viewName.substring(0, viewNameIndex);
                directoryFile = new File(inv.getServletContext().getRealPath(directoryPath));
            } else {
                directoryPath = viewPathCache.getDirectoryPath();
                String subDirPath = viewName.substring(0, viewNameIndex);
                File tempHome = new File(inv.getServletContext().getRealPath(directoryPath));
                if (!tempHome.exists()) {
                    directoryFile = null;
                } else {
                    directoryFile = this.searchDirectory(tempHome, subDirPath);
                    if (directoryFile != null) {
                        subDirPath = directoryFile.getPath().substring(tempHome.getPath().length()).replace('\\', '/');
                        directoryPath = directoryPath + subDirPath;
                    }
                }
            }
        } else {
            directoryPath = viewPathCache.getDirectoryPath();
            notDirectoryViewName = viewName;
            directoryFile = new File(inv.getServletContext().getRealPath(directoryPath));
        }
        if (directoryFile == null || !directoryFile.exists()) {
            logger.error((Object)("not found directoryPath '" + directoryPath + "' for directoryFile '" + directoryFile + "' of view named '" + viewName + "'"));
            inv.getResponse().sendError(404, "not found directoryPath '" + directoryPath + "'");
            return null;
        }
        if (debugEnabled) {
            logger.debug((Object)("found directory " + directoryFile.getAbsolutePath()));
        }
        if ((viewFileName = this.searchViewFile(directoryFile, notDirectoryViewName, false)) == null) {
            viewFileName = this.searchViewFile(directoryFile, notDirectoryViewName, true);
        }
        if (viewFileName == null) {
            String msg = "not found view file '" + notDirectoryViewName + "' in " + directoryPath;
            if (logger.isWarnEnabled()) {
                logger.warn((Object)msg);
            }
            inv.getResponse().sendError(404, msg);
            return null;
        }
        viewPath = directoryPath + "/" + viewFileName;
        viewPathCache.setViewPath(viewName, viewPath);
        return viewPath;
    }

    private File searchDirectory(File tempHome, String subDirPath) {
        String[] subDirs;
        for (final String subDir : subDirs = StringUtils.split((String)subDirPath, (String)"/")) {
            File file = new File(tempHome, subDir);
            if (!file.exists()) {
                String[] candidates = tempHome.list(new FilenameFilter(){

                    @Override
                    public boolean accept(File dir, String name) {
                        return name.equalsIgnoreCase(subDir);
                    }
                });
                if (candidates.length == 0) {
                    tempHome = null;
                    break;
                }
                tempHome = new File(tempHome, candidates[0]);
                continue;
            }
            tempHome = file;
        }
        return tempHome;
    }

    private String searchViewFile(File directoryFile, final String fileNameToFind, final boolean ignoreCase) {
        Object[] viewFiles = directoryFile.list(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String fileName) {
                String _notDirectoryViewName = fileNameToFind;
                String _fileName = fileName;
                if (ignoreCase) {
                    _fileName = fileName.toLowerCase();
                    _notDirectoryViewName = fileNameToFind.toLowerCase();
                }
                if (_fileName.startsWith(_notDirectoryViewName) && new File(dir, fileName).isFile()) {
                    if (fileName.length() == fileNameToFind.length() && fileNameToFind.lastIndexOf(46) != -1) {
                        return true;
                    }
                    if (fileName.length() > fileNameToFind.length() && fileName.charAt(fileNameToFind.length()) == '.') {
                        return true;
                    }
                }
                return false;
            }
        });
        Arrays.sort(viewFiles);
        return viewFiles.length == 0 ? null : viewFiles[0];
    }

    protected ViewDispatcher getViewDispatcher(Invocation inv) {
        ViewDispatcher viewDispatcher = (ViewDispatcher)SpringUtils.getBean((ListableBeanFactory)inv.getApplicationContext(), this.viewDispatcherName);
        if (viewDispatcher == null) {
            viewDispatcher = this.registerViewDispatcher(inv.getApplicationContext());
        }
        return viewDispatcher;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ViewDispatcher registerViewDispatcher(WebApplicationContext applicationContext) {
        WebApplicationContext webApplicationContext = applicationContext;
        synchronized (webApplicationContext) {
            if (SpringUtils.getBean((ListableBeanFactory)applicationContext, this.viewDispatcherName) == null) {
                AnnotatedGenericBeanDefinition beanDefinition = new AnnotatedGenericBeanDefinition(ViewDispatcherImpl.class);
                ((BeanDefinitionRegistry)applicationContext.getAutowireCapableBeanFactory()).registerBeanDefinition(this.viewDispatcherName, (BeanDefinition)beanDefinition);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("registered bean definition:" + ViewDispatcherImpl.class.getName()));
                }
            }
            return (ViewDispatcher)SpringUtils.getBean((ListableBeanFactory)applicationContext, this.viewDispatcherName);
        }
    }
}

