/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.instruction;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.instruction.AbstractInstruction;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class TextInstruction
extends AbstractInstruction {
    protected static Log logger = LogFactory.getLog(TextInstruction.class);
    private String text;

    public String text() {
        return this.text;
    }

    public TextInstruction text(String text) {
        this.text = text;
        return this;
    }

    @Override
    public void doRender(Invocation inv) throws Exception {
        HttpServletResponse response;
        String oldEncoding;
        if (StringUtils.isEmpty((String)this.text)) {
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("trying to render text:" + this.text));
        }
        if (StringUtils.isBlank((String)(oldEncoding = (response = inv.getResponse()).getCharacterEncoding())) || oldEncoding.startsWith("ISO-")) {
            String encoding = inv.getRequest().getCharacterEncoding();
            Assert.isTrue((encoding != null ? 1 : 0) != 0);
            response.setCharacterEncoding(encoding);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set response.characterEncoding by default:" + response.getCharacterEncoding()));
            }
        }
        if (response.getContentType() == null) {
            response.setContentType("text/html");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("set response content-type by default: " + response.getContentType()));
            }
        }
        this.sendResponse(response, this.text);
    }

    private void sendResponse(HttpServletResponse response, String text) throws IOException {
        if (StringUtils.isNotEmpty((String)text)) {
            PrintWriter out = response.getWriter();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("write text to response:" + text));
            }
            out.print(text);
        }
    }

    public String toString() {
        return this.text;
    }
}

