/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.instruction;

import java.io.IOException;
import javax.servlet.ServletException;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.instruction.AbstractInstruction;
import net.paoding.rose.web.instruction.Instruction;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class RedirectInstruction
extends AbstractInstruction {
    protected static Log logger = LogFactory.getLog(RedirectInstruction.class);
    private String location;
    private Integer sc;

    @Override
    public void doRender(Invocation inv) throws IOException {
        String location = this.resolvePlaceHolder(this.location(), inv);
        if (this.sc == null || this.sc == 302) {
            inv.getResponse().sendRedirect(location);
        } else {
            Assert.isTrue((this.sc == 301 ? 1 : 0) != 0);
            inv.getResponse().setStatus(this.sc.intValue());
            inv.getResponse().setHeader("Location", location);
        }
    }

    public RedirectInstruction permanently() {
        this.sc = 301;
        return this;
    }

    public RedirectInstruction module(final String module) {
        this.preInstruction = new Instruction(){

            @Override
            public void render(Invocation inv) throws IOException, ServletException, Exception {
                String ctxpath = inv.getRequestPath().getCtxpath();
                if (module.length() == 0) {
                    if (ctxpath.length() == 0) {
                        RedirectInstruction.this.location("/");
                    } else {
                        RedirectInstruction.this.location(ctxpath);
                    }
                } else if (module.charAt(0) != '/') {
                    RedirectInstruction.this.location(ctxpath + "/" + module);
                } else {
                    RedirectInstruction.this.location(ctxpath + module);
                }
            }
        };
        return this;
    }

    public RedirectInstruction controller(final String controller) {
        this.preInstruction = new Instruction(){

            @Override
            public void render(Invocation inv) throws IOException, ServletException, Exception {
                String controllerPath = controller;
                if (controller.length() > 0 && controller.charAt(0) != '/') {
                    controllerPath = "/" + controller;
                }
                RequestPath requestPath = inv.getRequestPath();
                RedirectInstruction.this.location(requestPath.getCtxpath() + requestPath.getModulePath() + controllerPath);
            }
        };
        return this;
    }

    public RedirectInstruction action(final String action) {
        this.preInstruction = new Instruction(){

            @Override
            public void render(Invocation inv) throws IOException, ServletException, Exception {
                String actionPath = action;
                if (action.length() > 0 && action.charAt(0) != '/') {
                    actionPath = "/" + action;
                }
                RequestPath requestPath = inv.getRequestPath();
                RedirectInstruction.this.location(requestPath.getCtxpath() + requestPath.getModulePath() + requestPath.getControllerPath() + actionPath);
            }
        };
        return this;
    }

    public String location() {
        return this.location;
    }

    public RedirectInstruction location(String location) {
        this.location = location;
        return this;
    }
}

