/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.instruction;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.ServletException;
import net.paoding.rose.util.SpringUtils;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.impl.thread.InvocationBean;
import net.paoding.rose.web.instruction.Forward;
import net.paoding.rose.web.instruction.HttpError;
import net.paoding.rose.web.instruction.InputStreamInstruction;
import net.paoding.rose.web.instruction.Instruction;
import net.paoding.rose.web.instruction.InstructionExecutor;
import net.paoding.rose.web.instruction.Redirect;
import net.paoding.rose.web.instruction.RedirectInstruction;
import net.paoding.rose.web.instruction.Text;
import net.paoding.rose.web.instruction.ViewInstruction;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;

public class InstructionExecutorImpl
implements InstructionExecutor {
    private Log logger = LogFactory.getLog(this.getClass());

    @Override
    public Object render(Invocation inv, Object instruction) throws IOException, ServletException, Exception {
        if ((instruction = this.translatesToInstructionObject((InvocationBean)inv, instruction)) != null && !Thread.currentThread().isInterrupted()) {
            ((Instruction)instruction).render(inv);
        }
        return instruction;
    }

    private Instruction translatesToInstructionObject(InvocationBean inv, Object instruction) throws StackOverflowError {
        int count = 0;
        while (!(instruction instanceof Instruction)) {
            if (count++ > 50) {
                throw new StackOverflowError("Unable to parse the instruction to an Instruction object less than " + count + " times. Is the instruction" + " that returned by your controller" + " action is right?");
            }
            if (Thread.interrupted() || instruction == null) {
                return null;
            }
            if (instruction.getClass() != String.class && !ClassUtils.isPrimitiveOrWrapper(instruction.getClass()) && instruction.getClass().getComponentType() == null && instruction.getClass().getAnnotation(Component.class) != null) {
                SpringUtils.autowire(instruction, (ApplicationContext)inv.getApplicationContext());
            }
            instruction = this.parseInstruction(inv, instruction);
        }
        return (Instruction)instruction;
    }

    protected Object parseInstruction(Invocation inv, Object ins) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("parset instruction:" + ins.getClass().getName() + ": '" + ins + "'"));
        }
        if (ClassUtils.isPrimitiveOrWrapper(ins.getClass())) {
            return Text.text(ins);
        }
        if (ins instanceof CharSequence) {
            String str = ins.toString();
            if (str.length() == 0 || str.equals("@")) {
                return null;
            }
            if (str.charAt(0) == '@') {
                return Text.text(str.substring(1));
            }
            if (str.charAt(0) == '/') {
                return new ViewInstruction(str);
            }
            if (str.startsWith("r:") || str.startsWith("redirect:")) {
                StringInstruction si = new StringInstruction(false, str.substring(str.indexOf(58) + 1));
                if (si.innerInstruction.startsWith("http://") || si.innerInstruction.startsWith("https://")) {
                    return Redirect.location(si.innerInstruction);
                }
                return si;
            }
            if (str.startsWith("pr:") || str.startsWith("perm-redirect:")) {
                StringInstruction si = new StringInstruction(false, str.substring(str.indexOf(58) + 1));
                si.permanentlyWhenRedirect = true;
                if (si.innerInstruction.startsWith("http://") || si.innerInstruction.startsWith("https://")) {
                    return si.permanentlyIfNecessary(Redirect.location(si.innerInstruction));
                }
                return si;
            }
            if (str.startsWith("f:") || str.startsWith("forward:")) {
                return new StringInstruction(true, str.substring(str.indexOf(58) + 1));
            }
            if (str.startsWith("e:") || str.startsWith("error:")) {
                int begin = str.indexOf(58) + 1;
                int codeEnd = str.indexOf(59);
                if (codeEnd == -1) {
                    String text = str.substring(begin);
                    if (text.length() > 0 && NumberUtils.isNumber((String)text)) {
                        return HttpError.code(Integer.parseInt(text));
                    }
                    return HttpError.code(500, text);
                }
                return HttpError.code(Integer.parseInt(str.substring(begin, codeEnd)), str.substring(codeEnd + 1).trim());
            }
            if (str.startsWith("s:") || str.startsWith("status:")) {
                int begin = str.indexOf(58) + 1;
                int codeEnd = str.indexOf(59, begin);
                if (codeEnd == -1) {
                    inv.getResponse().setStatus(Integer.parseInt(str.substring(begin)));
                    return null;
                }
                inv.getResponse().setStatus(Integer.parseInt(str.substring(begin, codeEnd)));
                for (int i = codeEnd; i < str.length(); ++i) {
                    if (str.charAt(i) == ' ') continue;
                    str = str.substring(i + 1);
                    break;
                }
            }
            if (str.equals(":continue")) {
                return null;
            }
            return new StringInstruction(null, str);
        }
        if (ins.getClass() == StringInstruction.class) {
            int i;
            StringInstruction fr = (StringInstruction)ins;
            String str = fr.innerInstruction;
            int queryIndex = str.indexOf(63);
            int n = i = queryIndex == -1 ? str.length() - 1 : queryIndex - 1;
            while (i >= 0) {
                if (str.charAt(i) == ':') {
                    if (i > 0 && str.charAt(i - 1) == '\\') {
                        str = str.substring(0, i - 1) + str.substring(i);
                        --i;
                    } else {
                        int cmdBeforeBegin;
                        int cmdEnd = i;
                        for (cmdBeforeBegin = i - 1; cmdBeforeBegin >= 0 && str.charAt(cmdBeforeBegin) != ':'; --cmdBeforeBegin) {
                        }
                        String prefix = str.subSequence(cmdBeforeBegin + 1, cmdEnd).toString();
                        String body = str.subSequence(i + 1, str.length()).toString();
                        if ("a".equals(prefix) || "action".equals(prefix)) {
                            if (fr.isReirect()) {
                                return fr.permanentlyIfNecessary(Redirect.action(body));
                            }
                            return Forward.action(body);
                        }
                        if ("c".equals(prefix) || "controller".equals(prefix)) {
                            if (fr.isReirect()) {
                                return fr.permanentlyIfNecessary(Redirect.controller(body));
                            }
                            return Forward.controller(body);
                        }
                        if ("m".equals(prefix) || "module".equals(prefix)) {
                            if (fr.isReirect()) {
                                return fr.permanentlyIfNecessary(Redirect.module(body));
                            }
                            return Forward.module(body);
                        }
                        this.logger.warn((Object)("skip the prefix '" + prefix + ":' of " + str));
                        if (fr.isReirect()) {
                            return fr.permanentlyIfNecessary(Redirect.location(str));
                        }
                        if (fr.isForward()) {
                            return Forward.path(str);
                        }
                        return new ViewInstruction(str);
                    }
                }
                --i;
            }
            if (fr.isReirect()) {
                return fr.permanentlyIfNecessary(Redirect.location(str));
            }
            if (fr.isForward()) {
                return Forward.path(str);
            }
            return new ViewInstruction(str);
        }
        if (ins instanceof InputStream) {
            return new InputStreamInstruction((InputStream)ins);
        }
        if (ins instanceof byte[]) {
            return new InputStreamInstruction(new ByteArrayInputStream((byte[])ins));
        }
        return Text.text(ins.toString());
    }

    private class StringInstruction {
        Boolean forward;
        String innerInstruction;
        boolean permanentlyWhenRedirect = false;

        public StringInstruction(Boolean forward, String innerInstruction) {
            this.forward = forward;
            this.innerInstruction = innerInstruction;
        }

        public RedirectInstruction permanentlyIfNecessary(RedirectInstruction redirectInstruction) {
            if (this.permanentlyWhenRedirect) {
                redirectInstruction.permanently();
            }
            return redirectInstruction;
        }

        public boolean isReirect() {
            return this.forward != null && this.forward == false;
        }

        public boolean isForward() {
            return this.forward != null && this.forward != false;
        }

        public String toString() {
            return this.forward == null ? "" : (this.forward != false ? "f:" : "r:") + this.innerInstruction;
        }
    }
}

