/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.instruction;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.instruction.AbstractInstruction;
import net.paoding.rose.web.instruction.Instruction;

public class ForwardInstruction
extends AbstractInstruction {
    private String path;

    @Override
    public void doRender(Invocation inv) throws ServletException, IOException {
        String path = this.resolvePlaceHolder(this.path, inv);
        inv.getRequest().getRequestDispatcher(path).forward((ServletRequest)inv.getRequest(), (ServletResponse)inv.getResponse());
    }

    public ForwardInstruction module(final String module) {
        this.preInstruction = new Instruction(){

            @Override
            public void render(Invocation inv) throws IOException, ServletException, Exception {
                String modulePath = module;
                if (module.length() > 0 && module.charAt(0) != '/') {
                    modulePath = "/" + module;
                }
                ForwardInstruction.this.path(modulePath);
            }
        };
        return this;
    }

    public ForwardInstruction controller(final String controller) {
        this.preInstruction = new Instruction(){

            @Override
            public void render(Invocation inv) throws IOException, ServletException, Exception {
                String controllerPath = controller;
                if (controller.length() > 0 && controller.charAt(0) != '/') {
                    controllerPath = "/" + controller;
                }
                ForwardInstruction.this.path(inv.getRequestPath().getModulePath() + controllerPath);
            }
        };
        return this;
    }

    public ForwardInstruction action(final String action) {
        this.preInstruction = new Instruction(){

            @Override
            public void render(Invocation inv) throws IOException, ServletException, Exception {
                String actionPath = action;
                if (action.length() > 0 && action.charAt(0) != '/') {
                    actionPath = "/" + action;
                }
                RequestPath requestPath = inv.getRequestPath();
                ForwardInstruction.this.path(requestPath.getModulePath() + requestPath.getControllerPath() + actionPath);
            }
        };
        return this;
    }

    public ForwardInstruction path(String path) {
        this.path = path;
        return this;
    }

    public String path() {
        return this.path;
    }
}

