/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.view;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import net.paoding.rose.util.SpringUtils;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.impl.view.DyContentTypeViewResolver;
import net.paoding.rose.web.impl.view.ViewDispatcher;
import net.paoding.rose.web.impl.view.velocity.RoseVelocityConfigurer;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.ConfigurableWebApplicationContext;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;
import org.springframework.web.servlet.view.velocity.VelocityConfig;
import org.springframework.web.servlet.view.velocity.VelocityLayoutViewResolver;
import org.springframework.web.servlet.view.velocity.VelocityViewResolver;

public class ViewDispatcherImpl
implements ViewDispatcher,
ApplicationContextAware {
    private static Log logger = LogFactory.getLog(ViewDispatcherImpl.class);
    private ViewResolver jspViewResolver;
    private ViewResolver internalResourceViewResolver = new InternalResourceViewResolver();
    private ConfigurableWebApplicationContext applicationContext;
    private Map<String, VelocityViewResolver> velocityViewResolvers = new HashMap<String, VelocityViewResolver>();

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = (ConfigurableWebApplicationContext)applicationContext;
        SpringUtils.autowire(this.internalResourceViewResolver, applicationContext);
    }

    public ConfigurableWebApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Override
    public View resolveViewName(Invocation inv, String viewPath, Locale locale) throws Exception {
        ViewResolver viewResolver = this.getSpringViewResolver(inv, viewPath);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("found viewResolver '" + viewResolver + "' for viewPath '" + viewPath + "'"));
        }
        return viewResolver.resolveViewName(viewPath, locale);
    }

    protected ViewResolver getSpringViewResolver(Invocation inv, String viewPath) throws IOException {
        if (viewPath.endsWith(".vm")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"to get velocity view resolver.");
            }
            return this.getVelocityViewResolver(inv, viewPath);
        }
        if (viewPath.endsWith(".xml")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"to get velocity view resolver.");
            }
            return new DyContentTypeViewResolver(this.getVelocityViewResolver(inv, viewPath), "text/xml");
        }
        if (viewPath.endsWith(".jsp")) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"to get jsp view resolver.");
            }
            return this.getJspViewResolver();
        }
        int lastIndex = viewPath.lastIndexOf(46);
        if (lastIndex >= 0) {
            if (viewPath.endsWith(".js") || viewPath.endsWith(".css") || viewPath.endsWith(".ico") || viewPath.endsWith(".html") || viewPath.endsWith(".htm") || viewPath.endsWith(".txt") || viewPath.endsWith(".jpg") || viewPath.endsWith(".gif")) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"to get internal resource resolver.");
                }
                return this.internalResourceViewResolver;
            }
            String beanName = viewPath.substring(lastIndex + 1) + "ViewResolver";
            ViewResolver resolver = (ViewResolver)SpringUtils.getBean((ListableBeanFactory)this.getApplicationContext(), beanName);
            return resolver != null ? resolver : this.internalResourceViewResolver;
        }
        return this.internalResourceViewResolver;
    }

    private String getDirectory(String viewPath) {
        int index = viewPath.lastIndexOf(47);
        return index == -1 ? "" : viewPath.substring(0, index);
    }

    protected ViewResolver getJspViewResolver() throws IOException {
        if (this.jspViewResolver != null) {
            return this.jspViewResolver;
        }
        String beanName = "jspViewResolver";
        this.jspViewResolver = (ViewResolver)SpringUtils.getBean((ListableBeanFactory)this.getApplicationContext(), beanName);
        if (this.jspViewResolver == null) {
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(InternalResourceViewResolver.class);
            MutablePropertyValues propertyValues = new MutablePropertyValues();
            propertyValues.addPropertyValue(new PropertyValue("viewClass", JstlView.class));
            beanDefinition.setPropertyValues(propertyValues);
            ((BeanDefinitionRegistry)this.getApplicationContext().getBeanFactory()).registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
            logger.info((Object)("registered bean definition named " + beanName + ": " + InternalResourceViewResolver.class.getName()));
            this.jspViewResolver = (ViewResolver)SpringUtils.getBean((ListableBeanFactory)this.getApplicationContext(), beanName);
        }
        return this.jspViewResolver;
    }

    protected ViewResolver getVelocityViewResolver(Invocation inv, String viewPath) throws IOException {
        VelocityViewResolver viewResolver = this.velocityViewResolvers.get(viewPath);
        if (viewResolver != null) {
            return viewResolver;
        }
        String viewDirectory = this.getDirectory(viewPath);
        viewResolver = this.velocityViewResolvers.get(viewDirectory);
        if (viewResolver != null) {
            this.velocityViewResolvers.put(viewPath, viewResolver);
            return viewResolver;
        }
        StringBuilder sb = new StringBuilder();
        boolean beUpperCase = false;
        for (int i = 0; i < viewDirectory.length(); ++i) {
            if (viewDirectory.charAt(i) != '/') {
                if (beUpperCase) {
                    sb.append(Character.toUpperCase(viewDirectory.charAt(i)));
                    beUpperCase = false;
                    continue;
                }
                sb.append(viewDirectory.charAt(i));
                continue;
            }
            beUpperCase = true;
        }
        String beanName = sb.toString() + "VelocityViewResolver";
        viewResolver = (VelocityViewResolver)SpringUtils.getBean((ListableBeanFactory)this.getApplicationContext(), beanName);
        if (viewResolver == null) {
            String temp = viewDirectory;
            String layoutUrl = null;
            while (temp.length() > 0) {
                File layout;
                String _layoutUrl = temp + "/layout.vm";
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("is default layout file exist? " + _layoutUrl));
                }
                if ((layout = new File(inv.getServletContext().getRealPath(_layoutUrl))).exists()) {
                    layoutUrl = _layoutUrl;
                    if (!logger.isDebugEnabled()) break;
                    logger.debug((Object)("found default layout file " + _layoutUrl));
                    break;
                }
                int i = temp.lastIndexOf(47);
                if (i <= 0) break;
                temp = temp.substring(0, i);
            }
            if (layoutUrl == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("not found layout file for " + viewDirectory));
                }
                beanName = "velocityViewResolver";
                viewResolver = (VelocityViewResolver)SpringUtils.getBean((ListableBeanFactory)this.getApplicationContext(), beanName);
            }
            if (viewResolver == null) {
                viewResolver = this.createVelocityViewResolver(inv, beanName, layoutUrl);
            }
        }
        this.velocityViewResolvers.put(viewDirectory, viewResolver);
        this.velocityViewResolvers.put(viewPath, viewResolver);
        return viewResolver;
    }

    private VelocityViewResolver createVelocityViewResolver(Invocation inv, String beanName, String layoutUrl) throws MalformedURLException, IOException {
        if (SpringUtils.getBean((ListableBeanFactory)this.getApplicationContext(), VelocityConfig.class) == null) {
            URL propertiesLocation = inv.getServletContext().getResource("/WEB-INF/velocity.properties");
            Properties velocityProperties = new Properties();
            if (propertiesLocation != null) {
                InputStream is = propertiesLocation.openStream();
                velocityProperties.load(is);
                is.close();
            }
            if (StringUtils.isBlank((String)velocityProperties.getProperty("input.encoding"))) {
                velocityProperties.setProperty("input.encoding", "UTF-8");
            }
            if (StringUtils.isBlank((String)velocityProperties.getProperty("output.encoding"))) {
                velocityProperties.setProperty("output.encoding", "UTF-8");
            }
            GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
            beanDefinition.setBeanClass(RoseVelocityConfigurer.class);
            MutablePropertyValues propertyValues = new MutablePropertyValues();
            propertyValues.addPropertyValue(new PropertyValue("velocityProperties", (Object)velocityProperties));
            propertyValues.addPropertyValue(new PropertyValue("resourceLoaderPath", (Object)"/"));
            beanDefinition.setPropertyValues(propertyValues);
            ((BeanDefinitionRegistry)this.getApplicationContext().getBeanFactory()).registerBeanDefinition("velocityConfigurer", (BeanDefinition)beanDefinition);
            logger.info((Object)("registered bean definition named velocityConfigurer: " + RoseVelocityConfigurer.class.getName()));
        }
        GenericBeanDefinition beanDefinition = new GenericBeanDefinition();
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        if (layoutUrl == null) {
            beanDefinition.setBeanClass(VelocityViewResolver.class);
        } else {
            beanDefinition.setBeanClass(VelocityLayoutViewResolver.class);
            propertyValues.addPropertyValue(new PropertyValue("layoutUrl", (Object)layoutUrl));
        }
        propertyValues.addPropertyValue(new PropertyValue("contentType", (Object)"text/html;charset=UTF-8"));
        String toolboxConfigLocation = "/WEB-INF/velocity-toolbox.xml";
        propertyValues.addPropertyValue(new PropertyValue("cache", (Object)Boolean.TRUE));
        URL toolbox = inv.getServletContext().getResource(toolboxConfigLocation);
        if (toolbox == null) {
            toolboxConfigLocation = "/WEB-INF/toolbox.xml";
            toolbox = inv.getServletContext().getResource(toolboxConfigLocation);
        }
        if (toolbox != null) {
            propertyValues.addPropertyValue(new PropertyValue("toolboxConfigLocation", (Object)toolboxConfigLocation));
        }
        beanDefinition.setPropertyValues(propertyValues);
        ((BeanDefinitionRegistry)this.getApplicationContext().getBeanFactory()).registerBeanDefinition(beanName, (BeanDefinition)beanDefinition);
        logger.info((Object)("registered bean definition named " + beanName + ": " + VelocityViewResolver.class.getName()));
        return (VelocityViewResolver)SpringUtils.getBean((ListableBeanFactory)this.getApplicationContext(), beanName);
    }
}

