/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.thread;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.web.Dispatcher;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.InvocationUtils;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.annotation.ReqMethod;
import net.paoding.rose.web.impl.mapping.EngineGroup;
import net.paoding.rose.web.impl.mapping.MappingNode;
import net.paoding.rose.web.impl.mapping.MatchResult;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.thread.ActionEngine;
import net.paoding.rose.web.impl.thread.AfterCompletion;
import net.paoding.rose.web.impl.thread.ControllerEngine;
import net.paoding.rose.web.impl.thread.EngineChain;
import net.paoding.rose.web.impl.thread.InvocationBean;
import net.paoding.rose.web.impl.thread.LinkedEngine;
import net.paoding.rose.web.impl.thread.ModuleEngine;
import net.paoding.rose.web.impl.thread.ParameteredUriRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;

public class Rose
implements EngineChain {
    protected static final Log logger = LogFactory.getLog(Rose.class);
    private final List<Module> modules;
    private final MappingNode mappingTree;
    private final RequestPath path;
    private final HttpServletRequest originalHttpRequest;
    private final HttpServletResponse originalHttpResponse;
    private boolean started;
    private List<LinkedEngine> engines = new ArrayList<LinkedEngine>(6);
    private List<MatchResult> matchResults;
    private InvocationBean inv;
    private int curIndexOfChain;
    private final LinkedList<AfterCompletion> afterCompletions = new LinkedList();

    public Rose(List<Module> modules, MappingNode mappingTree, HttpServletRequest httpRequest, HttpServletResponse httpResponse, RequestPath requestPath) {
        this.mappingTree = mappingTree;
        this.modules = modules;
        this.originalHttpRequest = httpRequest;
        this.originalHttpResponse = httpResponse;
        this.path = requestPath;
    }

    public MappingNode getMappingTree() {
        return this.mappingTree;
    }

    public InvocationBean getInvocation() {
        return this.inv;
    }

    public List<Module> getModules() {
        return this.modules;
    }

    public List<LinkedEngine> getEngines() {
        return this.engines;
    }

    public boolean start() throws Throwable {
        if (this.started) {
            throw new IllegalStateException("don't start again");
        }
        this.started = true;
        return this.innerStart();
    }

    public List<MatchResult> getMatchResults() {
        return this.matchResults;
    }

    @Override
    public Object doNext() throws Throwable {
        return this.engines.get(--this.curIndexOfChain).execute(this);
    }

    private boolean innerStart() throws Throwable {
        boolean debugEnabled = logger.isDebugEnabled();
        ArrayList<MatchResult> matchResults = this.mappingTree.match(this.path);
        if (matchResults == null) {
            if (debugEnabled) {
                logger.debug((Object)("not rose uri: '" + this.path.getUri() + "'"));
            }
            return false;
        }
        MatchResult lastMatched = (MatchResult)matchResults.get(matchResults.size() - 1);
        EngineGroup leafEngineGroup = lastMatched.getMappingNode().getLeafEngines();
        if (leafEngineGroup.size() == 0) {
            if (debugEnabled) {
                logger.debug((Object)("not rose uri, not exits leaf engines for it: '" + this.path.getUri() + "'"));
            }
            return false;
        }
        LinkedEngine leafEngine = this.select(leafEngineGroup.getEngines(this.path.getMethod()));
        if (leafEngine == null) {
            StringBuilder allow = new StringBuilder();
            String gap = ", ";
            for (ReqMethod method : leafEngineGroup.getAllowedMethods()) {
                allow.append(method.toString()).append(", ");
            }
            if (allow.length() > 0) {
                allow.setLength(allow.length() - ", ".length());
            }
            this.originalHttpResponse.addHeader("Allow", allow.toString());
            this.originalHttpResponse.sendError(405, this.path.getUri());
            return true;
        }
        if (debugEnabled) {
            ActionEngine actionEngine = (ActionEngine)leafEngine.getTarget();
            logger.debug((Object)("mapped '" + this.path.getUri() + "' to " + actionEngine.getControllerClass().getName() + "#" + actionEngine.getMethod().getName()));
        }
        MappingNode moduleNode = null;
        MappingNode controllerNode = null;
        for (LinkedEngine tempEngine = leafEngine; tempEngine != null; tempEngine = tempEngine.getParent()) {
            this.engines.add(tempEngine);
            Class<?> target = tempEngine.getTarget().getClass();
            if (target == ModuleEngine.class) {
                moduleNode = tempEngine.getNode();
                continue;
            }
            if (target != ControllerEngine.class) continue;
            controllerNode = tempEngine.getNode();
        }
        StringBuilder sb = new StringBuilder(this.path.getUri().length());
        MatchResult moduleMatchResult = null;
        MatchResult controllerMatchResult = null;
        for (int i = 0; i < matchResults.size(); ++i) {
            MatchResult matchResult = (MatchResult)matchResults.get(i);
            sb.append(matchResult.getValue());
            if (matchResult.getMappingNode() == moduleNode) {
                moduleMatchResult = matchResult;
                this.path.setModulePath(sb.toString());
                Assert.notNull((Object)this.engines.get(2));
                sb.setLength(0);
            }
            if (matchResult.getMappingNode() != controllerNode) continue;
            controllerMatchResult = matchResult;
            this.path.setControllerPath(sb.toString());
            Assert.notNull((Object)this.engines.get(1));
            sb.setLength(0);
        }
        this.path.setActionPath(sb.toString());
        Assert.notNull(moduleMatchResult);
        Assert.notNull(controllerMatchResult);
        this.matchResults = matchResults;
        this.curIndexOfChain = this.engines.size();
        HashMap<String, String> uriParameters = null;
        for (int i = matchResults.size() - 1; i >= 0; --i) {
            MatchResult matchResult = (MatchResult)matchResults.get(i);
            String name = matchResult.getParameterName();
            if (name == null) continue;
            if (uriParameters == null) {
                uriParameters = new HashMap<String, String>(matchResults.size() << 1);
            }
            uriParameters.put(name, matchResult.getValue());
        }
        Object httpRequest = this.originalHttpRequest;
        if (uriParameters != null && uriParameters.size() > 0) {
            httpRequest = new ParameteredUriRequest(this.originalHttpRequest, (Map<String, String>)uriParameters);
        }
        HttpServletRequest originalThreadRequest = InvocationUtils.getCurrentThreadRequest();
        Invocation preInvocation = null;
        if (this.path.getDispatcher() != Dispatcher.REQUEST) {
            preInvocation = InvocationUtils.getInvocation(this.originalHttpRequest);
        }
        InvocationBean inv = new InvocationBean((HttpServletRequest)httpRequest, this.originalHttpResponse, this.path);
        inv.setRose(this);
        inv.setPreInvocation(preInvocation);
        InvocationUtils.bindRequestToCurrentThread(httpRequest);
        InvocationUtils.bindInvocationToRequest(inv, httpRequest);
        this.inv = inv;
        Throwable error = null;
        try {
            Object instuction = this.doNext();
            if (":continue".equals(instuction)) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Throwable local) {
            error = local;
            throw local;
        }
        finally {
            for (AfterCompletion task : this.afterCompletions) {
                try {
                    task.afterCompletion(inv, error);
                }
                catch (Throwable e) {
                    logger.error((Object)"", e);
                }
            }
            if (originalThreadRequest != null) {
                InvocationUtils.bindRequestToCurrentThread(originalThreadRequest);
            } else {
                InvocationUtils.unindRequestFromCurrentThread();
            }
            if (preInvocation != null) {
                InvocationUtils.bindInvocationToRequest(preInvocation, httpRequest);
            }
        }
        return true;
    }

    private LinkedEngine select(LinkedEngine[] engines) {
        LinkedEngine selectedEngine = null;
        int score = 0;
        for (LinkedEngine engine : engines) {
            int candidate = engine.isAccepted(this.originalHttpRequest);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Score of " + engine.getClass().getName() + ":" + candidate));
            }
            if (candidate <= score) continue;
            selectedEngine = engine;
            score = candidate;
        }
        if (logger.isDebugEnabled()) {
            if (selectedEngine == null) {
                logger.debug((Object)"No engine selected.");
            } else {
                String msg;
                if (selectedEngine.getTarget() instanceof ActionEngine) {
                    ActionEngine actionEngine = (ActionEngine)selectedEngine.getTarget();
                    msg = actionEngine.getController().getClass().getName() + "#" + actionEngine.getMethod().getName();
                } else {
                    msg = selectedEngine.toString();
                }
                logger.debug((Object)("Engine selected:" + msg));
            }
        }
        return selectedEngine;
    }

    @Override
    public void addAfterCompletion(AfterCompletion task) {
        this.afterCompletions.addFirst(task);
    }
}

