/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.thread;

import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.impl.thread.AfterCompletion;
import net.paoding.rose.web.impl.thread.Engine;
import net.paoding.rose.web.impl.thread.InvocationBean;
import net.paoding.rose.web.impl.thread.Rose;
import net.paoding.rose.web.instruction.InstructionExecutor;
import net.paoding.rose.web.instruction.InstructionExecutorImpl;
import net.paoding.rose.web.var.FlashImpl;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RootEngine
implements Engine {
    protected final Log logger = LogFactory.getLog(this.getClass());
    protected InstructionExecutor instructionExecutor = new InstructionExecutorImpl();

    public RootEngine(InstructionExecutor instructionExecutor) {
        if (instructionExecutor != null) {
            this.instructionExecutor = instructionExecutor;
        }
    }

    @Override
    public int isAccepted(HttpServletRequest rose) {
        return 1;
    }

    @Override
    public Object execute(Rose rose) throws Throwable {
        RequestPath requestPath;
        InvocationBean inv = rose.getInvocation();
        HttpServletRequest request = inv.getRequest();
        if (request.getCharacterEncoding() == null) {
            request.setCharacterEncoding("UTF-8");
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("set request.characterEncoding by default:" + request.getCharacterEncoding()));
            }
        }
        if ((requestPath = inv.getRequestPath()).isIncludeRequest()) {
            this.saveAttributesBeforeInclude(inv);
            rose.addAfterCompletion(new AfterCompletion(){

                @Override
                public void afterCompletion(Invocation inv, Throwable ex) throws Exception {
                    RootEngine.this.restoreRequestAttributesAfterInclude(inv);
                }
            });
        }
        inv.addModel("invocation", inv);
        inv.addModel("ctxpath", requestPath.getCtxpath());
        Object instruction = rose.doNext();
        if (Thread.currentThread().isInterrupted()) {
            this.logger.info((Object)"stop to render: thread is interrupted");
        } else {
            FlashImpl flash;
            if (!requestPath.isIncludeRequest() && (flash = (FlashImpl)inv.getFlash(false)) != null) {
                flash.writeNewMessages();
            }
            this.instructionExecutor.render(inv, instruction);
        }
        return instruction;
    }

    @Override
    public void destroy() {
    }

    private void saveAttributesBeforeInclude(Invocation inv) {
        HttpServletRequest request = inv.getRequest();
        this.logger.debug((Object)"Taking snapshot of request attributes before include");
        HashMap<String, Object> attributesSnapshot = new HashMap<String, Object>();
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            attributesSnapshot.put(attrName, request.getAttribute(attrName));
        }
        inv.setAttribute("$$paoding-rose.attributesBeforeInclude", attributesSnapshot);
    }

    private void restoreRequestAttributesAfterInclude(Invocation inv) {
        this.logger.debug((Object)"Restoring snapshot of request attributes after include");
        HttpServletRequest request = inv.getRequest();
        Map attributesSnapshot = (Map)inv.getAttribute("$$paoding-rose.attributesBeforeInclude");
        HashSet<String> attrsToCheck = new HashSet<String>();
        Enumeration attrNames = request.getAttributeNames();
        while (attrNames.hasMoreElements()) {
            String attrName = (String)attrNames.nextElement();
            attrsToCheck.add(attrName);
        }
        for (String attrName : attrsToCheck) {
            Object attrValue = attributesSnapshot.get(attrName);
            if (attrValue != null) {
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug((Object)("Restoring original value of attribute [" + attrName + "] after include"));
                }
                request.setAttribute(attrName, attrValue);
                continue;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Removing attribute [" + attrName + "] after include"));
            }
            request.removeAttribute(attrName);
        }
    }

    public String toString() {
        return "root";
    }
}

