/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.thread;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public class ParameteredUriRequest
extends HttpServletRequestWrapper {
    private final Map<String, String> parameters;

    public ParameteredUriRequest(HttpServletRequest request, Map<String, String> parameters) {
        super(request);
        this.parameters = parameters;
    }

    public String getParameter(String name) {
        String value = super.getParameter(name);
        if (value == null) {
            value = this.parameters.get(name);
        }
        return value;
    }

    public Map getParameterMap() {
        HashMap<String, String[]> map = new HashMap<String, String[]>(super.getParameterMap());
        for (Map.Entry<String, String> entry : this.parameters.entrySet()) {
            if (map.containsKey(entry.getKey())) continue;
            map.put(entry.getKey(), new String[]{this.parameters.get(entry.getKey())});
        }
        return Collections.unmodifiableMap(map);
    }

    public String[] getParameterValues(String name) {
        String _value;
        String[] value = super.getParameterValues(name);
        if ((value == null || value.length == 0) && (_value = this.parameters.get(name)) != null) {
            value = new String[]{_value};
        }
        return value == null || value.length == 0 ? null : value;
    }

    public Enumeration getParameterNames() {
        final Enumeration requestParamNames = super.getParameterNames();
        return new Enumeration<String>(){
            final Iterator<String> matchResultParamNames;
            {
                this.matchResultParamNames = new ArrayList(ParameteredUriRequest.this.parameters.keySet()).iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.matchResultParamNames.hasNext() || requestParamNames.hasMoreElements();
            }

            @Override
            public String nextElement() {
                if (this.matchResultParamNames.hasNext()) {
                    return this.matchResultParamNames.next();
                }
                if (requestParamNames.hasMoreElements()) {
                    return (String)requestParamNames.nextElement();
                }
                throw new NoSuchElementException();
            }
        };
    }
}

