/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.thread;

import java.lang.reflect.InvocationTargetException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import net.paoding.rose.RoseConstants;
import net.paoding.rose.util.SpringUtils;
import net.paoding.rose.util.StackTraceSimplifier;
import net.paoding.rose.web.ControllerErrorHandler;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.annotation.MultipartCleanup;
import net.paoding.rose.web.annotation.NotForSubModules;
import net.paoding.rose.web.annotation.SuppressMultipartResolver;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.thread.AfterCompletion;
import net.paoding.rose.web.impl.thread.Engine;
import net.paoding.rose.web.impl.thread.InvocationBean;
import net.paoding.rose.web.impl.thread.Rose;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.multipart.MultipartException;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.multipart.MultipartResolver;
import org.springframework.web.multipart.commons.CommonsMultipartResolver;
import org.springframework.web.util.WebUtils;

public class ModuleEngine
implements Engine {
    private static Log logger = LogFactory.getLog(ModuleEngine.class);
    private final Module module;
    private final MultipartResolver multipartResolver;

    public ModuleEngine(Module module) {
        if (module == null) {
            throw new NullPointerException("module");
        }
        this.module = module;
        this.multipartResolver = ModuleEngine.initMultipartResolver((ApplicationContext)module.getApplicationContext());
    }

    public Module getModule() {
        return this.module;
    }

    public MultipartResolver getMultipartResolver() {
        return this.multipartResolver;
    }

    @Override
    public int isAccepted(HttpServletRequest rose) {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object execute(Rose rose) throws Throwable {
        InvocationBean inv = rose.getInvocation();
        inv.getRequest().setAttribute(RoseConstants.WEB_APPLICATION_CONTEXT_ATTRIBUTE, (Object)this.module.getApplicationContext());
        boolean isMultiPartRequest = false;
        try {
            isMultiPartRequest = this.checkMultipart(inv);
            Object object = rose.doNext();
            return object;
        }
        catch (Throwable invException) {
            Throwable cause = invException;
            while (cause instanceof InvocationTargetException) {
                cause = ((InvocationTargetException)cause).getTargetException();
            }
            Module errorHandlerModule = this.module;
            ControllerErrorHandler errorHandler = errorHandlerModule.getErrorHandler();
            while (errorHandler == null && errorHandlerModule != null) {
                if ((errorHandlerModule = errorHandlerModule.getParent()) != null) {
                    errorHandler = errorHandlerModule.getErrorHandler();
                    if (errorHandler == null || !errorHandler.getClass().isAnnotationPresent(NotForSubModules.class)) continue;
                    errorHandler = null;
                    continue;
                }
                errorHandler = null;
                break;
            }
            Object instruction = null;
            if (errorHandler != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("exception happended\uff1b " + errorHandler.getClass().getName() + " will handle the exception: " + cause.getClass().getName() + ":" + cause.getMessage()));
                }
                rose.getInvocation().setViewModule(errorHandlerModule);
                HttpServletRequest request = rose.getInvocation().getRequest();
                WebUtils.exposeErrorRequestAttributes((HttpServletRequest)request, (Throwable)cause, null);
                StackTraceSimplifier.simplify(cause);
                instruction = errorHandler.onError(rose.getInvocation(), cause);
            }
            if (errorHandler == null || instruction == null) {
                if (invException instanceof Exception) {
                    throw (Exception)invException;
                }
                throw (Error)invException;
            }
            Object object = instruction;
            return object;
        }
        finally {
            if (isMultiPartRequest) {
                this.cleanupMultipart(inv);
            }
        }
    }

    @Override
    public void destroy() {
        WebApplicationContext applicationContext = this.module.getApplicationContext();
        if (applicationContext instanceof AbstractApplicationContext) {
            ((AbstractApplicationContext)applicationContext).close();
        }
    }

    public String toString() {
        return this.module.getUrl().toString();
    }

    protected boolean checkMultipart(Invocation inv) throws MultipartException {
        if (inv.getRequest().getMethod() == null) {
            throw new NullPointerException("request.method");
        }
        if (this.multipartResolver.isMultipart(inv.getRequest())) {
            if (inv.getRequest() instanceof MultipartHttpServletRequest) {
                logger.debug((Object)"Request is already a MultipartHttpServletRequest");
                return true;
            }
            if (!inv.getMethod().isAnnotationPresent(SuppressMultipartResolver.class)) {
                inv.setRequest((HttpServletRequest)this.multipartResolver.resolveMultipart(inv.getRequest()));
                return true;
            }
        }
        return false;
    }

    protected void cleanupMultipart(Invocation inv) {
        HttpServletRequest src = inv.getRequest();
        while (src != null && !(src instanceof MultipartHttpServletRequest) && src instanceof HttpServletRequestWrapper) {
            src = (HttpServletRequest)((HttpServletRequestWrapper)src).getRequest();
        }
        if (src instanceof MultipartHttpServletRequest) {
            final MultipartHttpServletRequest request = (MultipartHttpServletRequest)src;
            MultipartCleanup multipartCleaner = inv.getMethod().getAnnotation(MultipartCleanup.class);
            if (multipartCleaner == null || multipartCleaner.after() == MultipartCleanup.After.CONTROLLER_INVOCATION) {
                this.multipartResolver.cleanupMultipart(request);
            } else {
                inv.addAfterCompletion(new AfterCompletion(){

                    @Override
                    public void afterCompletion(Invocation inv, Throwable ex) throws Exception {
                        ModuleEngine.this.multipartResolver.cleanupMultipart(request);
                    }
                });
            }
        }
    }

    private static MultipartResolver initMultipartResolver(ApplicationContext context) {
        MultipartResolver multipartResolver = (MultipartResolver)SpringUtils.getBean((ListableBeanFactory)context, MultipartResolver.class);
        if (multipartResolver != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Using MultipartResolver [" + multipartResolver + "]"));
            }
        } else {
            multipartResolver = new CommonsMultipartResolver();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No found MultipartResolver in context, Using MultipartResolver by default [" + multipartResolver + "]"));
            }
        }
        return multipartResolver;
    }
}

