/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.thread;

import javax.servlet.http.HttpServletRequest;
import net.paoding.rose.web.impl.mapping.MappingNode;
import net.paoding.rose.web.impl.thread.Engine;
import net.paoding.rose.web.impl.thread.Rose;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class LinkedEngine
implements Engine {
    protected final Log logger = LogFactory.getLog(this.getClass());
    private LinkedEngine parent;
    private Engine target;
    private MappingNode node;

    public LinkedEngine(LinkedEngine parent, Engine target, MappingNode node) {
        this.parent = parent;
        this.target = target;
        this.node = node;
    }

    public MappingNode getNode() {
        return this.node;
    }

    public LinkedEngine getParent() {
        return this.parent;
    }

    public Engine getTarget() {
        return this.target;
    }

    @Override
    public int isAccepted(HttpServletRequest request) {
        return this.target.isAccepted(request);
    }

    @Override
    public Object execute(Rose rose) throws Throwable {
        if (Thread.currentThread().isInterrupted()) {
            this.logger.info((Object)"stop to call the next engine: thread is interrupted");
            return null;
        }
        return this.target.execute(rose);
    }

    @Override
    public void destroy() {
        this.target.destroy();
    }
}

