/*
 * Decompiled with CFR 0.152.
 */
package net.paoding.rose.web.impl.thread;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.paoding.rose.web.Invocation;
import net.paoding.rose.web.InvocationUtils;
import net.paoding.rose.web.RequestPath;
import net.paoding.rose.web.impl.mapping.MatchResult;
import net.paoding.rose.web.impl.module.Module;
import net.paoding.rose.web.impl.thread.ActionEngine;
import net.paoding.rose.web.impl.thread.AfterCompletion;
import net.paoding.rose.web.impl.thread.ControllerEngine;
import net.paoding.rose.web.impl.thread.Engine;
import net.paoding.rose.web.impl.thread.LinkedEngine;
import net.paoding.rose.web.impl.thread.ModuleEngine;
import net.paoding.rose.web.impl.thread.Rose;
import net.paoding.rose.web.paramresolver.ParamMetaData;
import net.paoding.rose.web.var.Flash;
import net.paoding.rose.web.var.FlashImpl;
import net.paoding.rose.web.var.Model;
import net.paoding.rose.web.var.ModelImpl;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.Assert;
import org.springframework.validation.BindingResult;
import org.springframework.web.context.WebApplicationContext;

public final class InvocationBean
implements Invocation {
    public static final Object[] UN_INITIATED_ARRAY = new Object[0];
    private static final Log logger = LogFactory.getLog(InvocationBean.class);
    private Object[] methodParameters = UN_INITIATED_ARRAY;
    private Map<String, Object> attributes;
    private HttpServletRequest request;
    private HttpServletResponse response;
    private RequestPath requestPath;
    private transient Model model;
    private transient Flash flash;
    private Invocation preInvocation;
    private boolean multiPartRequest;
    private List<BindingResult> bindingResults;
    private List<String> bindingResultNames;
    private Rose rose;
    private Module viewModule;
    private ActionEngine actionEngine;
    private ControllerEngine controllerEngine;
    private ModuleEngine moduleEngine;

    public InvocationBean(HttpServletRequest request, HttpServletResponse response, RequestPath requestPath) {
        this.setRequest(request);
        this.setResponse(response);
        this.setRequestPath(requestPath);
    }

    public void setRose(Rose rose) {
        this.rose = rose;
    }

    public Rose getRose() {
        return this.rose;
    }

    protected boolean isMethodParametersInitiated() {
        return this.methodParameters != UN_INITIATED_ARRAY;
    }

    @Override
    public WebApplicationContext getApplicationContext() {
        return this.getModule().getApplicationContext();
    }

    public void setMethodParameters(Object[] methodParameters) {
        this.methodParameters = methodParameters;
    }

    @Override
    public Object getController() {
        ControllerEngine engine = this.getControllerEngine();
        return engine.getController();
    }

    @Override
    public Class<?> getControllerClass() {
        ControllerEngine engine = this.getControllerEngine();
        return engine.getControllerClass();
    }

    public Module getModule() {
        return this.getModuleEngine().getModule();
    }

    public Module getViewModule() {
        return this.viewModule == null ? this.getModule() : this.viewModule;
    }

    public void setViewModule(Module viewModule) {
        this.viewModule = viewModule;
    }

    @Override
    public Method getMethod() {
        return this.getActionEngine().getMethod();
    }

    @Override
    public boolean isAnnotationPresent(Class<? extends Annotation> annotationClass) {
        return this.getMethod().isAnnotationPresent(annotationClass) || this.getControllerClass().isAnnotationPresent(annotationClass);
    }

    @Override
    public <T extends Annotation> T getAnnotation(Class<T> annotationClass) {
        T t = this.getMethod().getAnnotation(annotationClass);
        if (t == null) {
            t = this.getControllerClass().getAnnotation(annotationClass);
        }
        return t;
    }

    public ModuleEngine getModuleEngine() {
        if (this.moduleEngine != null) {
            return this.moduleEngine;
        }
        this.moduleEngine = (ModuleEngine)this.getEngine(ModuleEngine.class);
        return this.moduleEngine;
    }

    public ControllerEngine getControllerEngine() {
        if (this.controllerEngine != null) {
            return this.controllerEngine;
        }
        this.controllerEngine = (ControllerEngine)this.getEngine(ControllerEngine.class);
        return this.controllerEngine;
    }

    public ActionEngine getActionEngine() {
        if (this.actionEngine != null) {
            return this.actionEngine;
        }
        this.actionEngine = (ActionEngine)this.getEngine(ActionEngine.class);
        return this.actionEngine;
    }

    private <T extends Engine> T getEngine(Class<? extends Engine> engineClass) {
        for (LinkedEngine engine : this.rose.getEngines()) {
            if (engine.getTarget().getClass() != engineClass) continue;
            Engine t = engine.getTarget();
            return (T)t;
        }
        throw new Error("cannot found " + engineClass.getName());
    }

    @Override
    public String[] getMethodParameterNames() {
        return (String[])ArrayUtils.clone((Object[])this.getActionEngine().getParameterNames());
    }

    @Override
    public Object[] getMethodParameters() {
        return this.methodParameters;
    }

    @Override
    public Object getMethodParameter(String name) {
        if (!this.isMethodParametersInitiated()) {
            throw new IllegalStateException();
        }
        String[] names = this.getActionEngine().getParameterNames();
        for (int i = 0; i < names.length; ++i) {
            if (name == null || !name.equals(names[i])) continue;
            return this.methodParameters[i];
        }
        return null;
    }

    @Override
    public String getParameter(String name) {
        return this.request.getParameter(name);
    }

    @Override
    public void changeMethodParameter(int index, Object newValue) {
        if (!this.isMethodParametersInitiated()) {
            throw new IllegalStateException();
        }
        if (newValue != this.methodParameters[index]) {
            if (logger.isDebugEnabled()) {
                String[] names = this.getActionEngine().getParameterNames();
                logger.debug((Object)("change method parameter " + names[index] + " (index=" + index + ") from '" + this.methodParameters[index] + "' to '" + newValue + "'"));
            }
            Object oldValue = this.methodParameters[index];
            this.methodParameters[index] = newValue;
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("change method parameter at " + index + ": " + oldValue + "->" + newValue));
            }
        }
    }

    @Override
    public void changeMethodParameter(String name, Object newValue) {
        if (!this.isMethodParametersInitiated()) {
            throw new IllegalStateException();
        }
        if (StringUtils.isEmpty((String)name)) {
            throw new NullPointerException("parameter name");
        }
        String[] names = this.getActionEngine().getParameterNames();
        for (int i = 0; i < names.length; ++i) {
            if (!name.equals(names[i])) continue;
            this.changeMethodParameter(i, newValue);
            return;
        }
    }

    @Override
    public void changeMethodParameter(ParamMetaData paramMeta, Object newValue) {
        this.changeMethodParameter(paramMeta.getIndex(), newValue);
    }

    @Override
    public void addModel(Object value) {
        this.getModel().add(value);
    }

    @Override
    public void addModel(String name, Object value) {
        this.getModel().add(name, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Model getModel() {
        if (this.model != null) {
            return this.model;
        }
        InvocationBean invocationBean = this;
        synchronized (invocationBean) {
            ModelImpl model = (ModelImpl)this.getRequest().getAttribute("$$paoding-rose.model");
            if (model == null || model.getInvocation() != this) {
                ModelImpl parent = model;
                model = new ModelImpl(this);
                if (parent != null && this.requestPath.isForwardRequest()) {
                    model.merge(parent.getAttributes());
                }
                this.getRequest().setAttribute("$$paoding-rose.model", (Object)model);
            }
            this.model = model;
        }
        return this.model;
    }

    @Override
    public Object getModel(String name) {
        return this.getModel().get(name);
    }

    @Override
    public synchronized Object getAttribute(String name) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(name);
    }

    @Override
    public synchronized void removeAttribute(String name) {
        if (this.attributes != null) {
            this.attributes.remove(name);
        }
    }

    @Override
    public synchronized Set<String> getAttributeNames() {
        if (this.attributes == null) {
            return Collections.emptySet();
        }
        return this.attributes.keySet();
    }

    @Override
    public synchronized Invocation setAttribute(String name, Object value) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, Object>();
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("setAttribute(" + name + "=" + value + ")"));
        }
        this.attributes.put(name, value);
        return this;
    }

    @Override
    public void addFlash(String name, String msg) {
        this.getFlash(true).add(name, msg);
    }

    @Override
    public Flash getFlash() {
        return this.getFlash(true);
    }

    @Override
    public Flash getFlash(boolean create) {
        if (this.flash != null) {
            return this.flash;
        }
        Flash flash = (Flash)this.getRequest().getAttribute("$$paoding-rose.flash");
        if (flash == null && create) {
            flash = new FlashImpl(this);
            this.getRequest().setAttribute("$$paoding-rose.flash", (Object)flash);
        }
        this.flash = flash;
        return this.flash;
    }

    @Override
    public RequestPath getRequestPath() {
        return this.requestPath;
    }

    @Override
    public HttpServletRequest getRequest() {
        return this.request;
    }

    @Override
    public HttpServletResponse getResponse() {
        return this.response;
    }

    @Override
    public void setRequest(HttpServletRequest request) {
        if (request == null) {
            throw new NullPointerException("request");
        }
        if (request == this.request) {
            return;
        }
        if (this.request == null) {
            this.request = request;
        } else {
            if (this.request == InvocationUtils.getCurrentThreadRequest()) {
                InvocationUtils.bindRequestToCurrentThread(request);
            }
            this.request = request;
        }
    }

    @Override
    public ServletContext getServletContext() {
        return this.getModule().getApplicationContext().getServletContext();
    }

    public void setResponse(HttpServletResponse response) {
        this.response = response;
    }

    public void setRequestPath(RequestPath requestPath) {
        this.requestPath = requestPath;
    }

    @Override
    public Invocation getPreInvocation() {
        return this.preInvocation;
    }

    public void setPreInvocation(Invocation preInvocation) {
        this.preInvocation = preInvocation;
    }

    @Override
    public Invocation getHeadInvocation() {
        Invocation inv = this;
        while (inv.getPreInvocation() != null) {
            inv = inv.getPreInvocation();
        }
        return inv;
    }

    public void setMultiPartRequest(boolean multiPartRequest) {
        this.multiPartRequest = multiPartRequest;
    }

    public boolean isMultiPartRequest() {
        return this.multiPartRequest;
    }

    @Override
    public List<BindingResult> getBindingResults() {
        this.fetchBindingResults();
        return this.bindingResults;
    }

    @Override
    public List<String> getBindingResultNames() {
        this.fetchBindingResults();
        return this.bindingResultNames;
    }

    @Override
    public BindingResult getParameterBindingResult() {
        return (BindingResult)this.getModel().get(BindingResult.MODEL_KEY_PREFIX + "parameterBindingResult");
    }

    @Override
    public BindingResult getBindingResult(String name) {
        Assert.notNull((Object)name);
        if (name instanceof String) {
            BindingResult br;
            if (!name.endsWith("BindingResult")) {
                name = name + "BindingResult";
            }
            if ((br = (BindingResult)this.getModel().get(BindingResult.MODEL_KEY_PREFIX + name)) == null) {
                br = this.getParameterBindingResult();
            }
            return br;
        }
        return null;
    }

    protected void fetchBindingResults() {
        if (this.bindingResults == null) {
            Map<String, Object> attributes = this.getModel().getAttributes();
            ArrayList<String> bindingResultNames = new ArrayList<String>();
            ArrayList<BindingResult> bindingResults = new ArrayList<BindingResult>();
            for (String key : attributes.keySet()) {
                Object value;
                if (!key.startsWith(BindingResult.MODEL_KEY_PREFIX) || !((value = attributes.get(key)) instanceof BindingResult)) continue;
                bindingResults.add((BindingResult)value);
                bindingResultNames.add(((BindingResult)value).getObjectName());
            }
            this.bindingResults = Collections.unmodifiableList(bindingResults);
            this.bindingResultNames = Collections.unmodifiableList(bindingResultNames);
        }
    }

    @Override
    public String getResourceId() {
        StringBuilder sb = new StringBuilder(255);
        sb.append(this.getRequest().getContextPath());
        for (MatchResult matchResult : this.rose.getMatchResults()) {
            sb.append(matchResult.getMappingNode().getMappingPath());
        }
        return sb.toString();
    }

    @Override
    public void addAfterCompletion(AfterCompletion afterComletion) {
        this.rose.addAfterCompletion(afterComletion);
    }

    public String toString() {
        return this.requestPath.getUri();
    }
}

